/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import oracle.dbtools.raptor.timesten.performancemonitor.GridSummaryPane;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;

public class PerformanceBarChart
extends BorderPane {
    private DashboardSummaryInfo info;
    private BarChart<String, Number> barChart;
    private Text text;
    private String title;

    public PerformanceBarChart(String string, String string2) {
        this.text = new Text(string);
        this.text.setFont(GridSummaryPane.TITLE_FONT);
        this.setTop((Node)this.text);
        this.title = string;
        this.barChart = new BarChart((Axis)new CategoryAxis(), (Axis)new NumberAxis());
        this.barChart.getYAxis().setLabel(string2);
        this.barChart.setLegendVisible(false);
        this.setCenter((Node)this.barChart);
    }

    public void refreshPane(HashMap<String, DashboardSummaryInfo> hashMap) {
        this.barChart.getData().clear();
        XYChart.Series series = new XYChart.Series();
        for (String string : hashMap.keySet()) {
            DashboardSummaryInfo dashboardSummaryInfo = hashMap.get(string);
            XYChart.Data data = new XYChart.Data((Object)dashboardSummaryInfo.getTitle(), (Object)dashboardSummaryInfo.getAverage());
            series.getData().add((Object)data);
        }
        this.barChart.getData().add((Object)series);
        block5: for (int i = 0; i < series.getData().size(); ++i) {
            String string;
            string = (XYChart.Data)series.getData().get(i);
            switch (i) {
                case 1: {
                    string.getNode().setStyle("-fx-bar-fill: navy;");
                    continue block5;
                }
                case 2: {
                    string.getNode().setStyle("-fx-bar-fill: firebrick;");
                    continue block5;
                }
            }
        }
    }
}

