/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.Storage;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;

public class TTGridRootNode
extends AbstractNode {
    private List<GridObject> grids = new ArrayList<GridObject>();
    private static TTGridRootNode INSTANCE;
    private static Storage storage;
    private String currentGrid;
    private String currentHost;
    private String currentInstance;
    private String currentDB;
    private TreePath gridPath;
    private String currentDir = null;

    public static TTGridRootNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TTGridRootNode();
            URL uRL = Storage.getStorageURL();
            storage = Storage.createStorage(uRL);
            try {
                storage.load();
            }
            catch (IOException iOException) {
                Logger.severe(TTGridRootNode.class, (Throwable)iOException);
            }
        }
        return INSTANCE;
    }

    public static Storage getStorage() {
        return storage;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public String getShortLabel() {
        return Messages.getString("TimesTenGrid.timesTenGrid");
    }

    public void addGrid(GridObject gridObject) {
        this.grids.add(gridObject);
        this.add((Element)gridObject.getGridNode().getGridRootNode(), true);
    }

    public void removeGrid(GridObject gridObject) {
        this.grids.remove(gridObject);
        this.remove((Element)gridObject.getGridNode().getGridRootNode(), true);
    }

    public GridObject getGrid(String string) {
        if (string != null && string.contains("(")) {
            string = string.substring(0, string.indexOf("(")).trim();
        }
        for (GridObject gridObject : this.grids) {
            if (!gridObject.getName().equals(string)) continue;
            return gridObject;
        }
        return null;
    }

    public void setCurrentGrid(String string) {
        this.currentGrid = string;
    }

    public String getCurrentGrid() {
        return this.currentGrid;
    }

    public void setCurrentInstance(String string) {
        this.currentInstance = string;
    }

    public String getCurrentInstance() {
        return this.currentInstance;
    }

    public void setCurrentHost(String string) {
        this.currentHost = string;
    }

    public String getCurrentHost() {
        return this.currentHost;
    }

    public TreePath getGridPath() {
        return this.gridPath;
    }

    public void setGridPath(TreePath treePath) {
        this.gridPath = treePath;
    }

    public void setCurrentDB(String string) {
        this.currentDB = string;
    }

    public String getCurrentDB() {
        return this.currentDB;
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(String string) {
        this.currentDir = string;
    }

    public String getAvailableSampleGridName() {
        int n = 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = "";
        for (GridObject gridObject : this.grids) {
            arrayList.add(gridObject.getShortName().toLowerCase());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.contains(object = "grid" + n++)) continue;
            return object;
        }
        return "grid" + n;
    }
}

