/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.Context;

public class SummaryPanel
extends JPanel {
    static final Logger logger = Logger.getLogger(SummaryPanel.class.getName());
    static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn")};
    static final int ATTRIBUTE_COLUMN_INDEX = 0;
    static final int VALUE_COLUMN_INDEX = 1;
    private JTable _summaryTable;
    private JScrollPane _scrollPane;
    private List<String> summaryAttr;
    private List<String> summaryVal;
    private SummaryTableModel _model;

    public SummaryPanel() {
        this.init();
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public SummaryPanel(JButton jButton) {
        this.init();
        this.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._model = new SummaryTableModel();
        this._summaryTable = new JTable(this._model){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return super.getCellRenderer(n, n2);
            }
        };
        this._summaryTable.setAutoResizeMode(0);
        this._summaryTable.setRowSelectionAllowed(false);
        this._summaryTable.setColumnSelectionAllowed(false);
        this._scrollPane = new JScrollPane(this._summaryTable);
    }

    public void setEmptyBorderOnScrollPane() {
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
    }

    public void loadContent(Context context) {
        this.summaryVal = (List)context.getProperty("SummaryVals");
        this.summaryAttr = (List)context.getProperty("SummaryAttr");
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._summaryTable, true, true);
            this.showData();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(SummaryPanel.this._summaryTable, true, true);
                        SummaryPanel.this.showData();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private void showData() {
        this._model.fireTableRowsUpdated(0, this._model.getRowCount() - 1);
    }

    class SummaryTableModel
    extends AbstractTableModel {
        SummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            return SummaryPanel.this.summaryAttr.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return SummaryPanel.this.summaryAttr.get(n);
                }
                case 1: {
                    return SummaryPanel.this.summaryVal.get(n);
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    SummaryPanel.this.summaryAttr.set(n, (String)object);
                }
                case 1: {
                    SummaryPanel.this.summaryVal.set(n, (String)object);
                }
            }
        }
    }
}

