/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class TableIndexViewer
extends TTTableViewer {
    private MyTableModel _model;
    protected static Logger _logger = Logger.getLogger(TableIndexViewer.class.getPackage().getName());

    @Override
    protected final String GetPurposeTxt() {
        return "index details";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this._model.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableIndexViewer.this._model.fireTableDataChanged();
                }
            });
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theIndexInfoColumnNames;
        private int theNoColumnsInIndexInfo;
        private String[] theTableColumNames;

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws SQLException {
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                String string = null;
                String string2 = null;
                boolean bl = false;
                String string3 = TableIndexViewer.this._dbObject.getSchemaName();
                String string4 = TableIndexViewer.this._dbObject.getObjectName();
                String string5 = TableIndexViewer.this._dbObject.getObjectType();
                this.theRows.clear();
                Connection connection = TableIndexViewer.this._dbObject.getConnection();
                statement2 = connection.createStatement();
                if (string5.equalsIgnoreCase("TABLE") || string5.equalsIgnoreCase("MATERIALIZED VIEW")) {
                    resultSet2 = statement2.executeQuery("SELECT tblid, numcols from sys.tables where rtrim(tblname) ='" + string4 + "' and rtrim(tblowner) = '" + string3 + "'");
                } else if (string5.equalsIgnoreCase("INDEX")) {
                    resultSet2 = statement2.executeQuery("SELECT t.tblid, i.tblid, numcols, ixid from sys.tables t, sys.indexes i where rtrim(ixname) ='" + string4 + "' and rtrim(ixowner) = '" + string3 + "' and t.tblid = i.tblid");
                    bl = true;
                } else {
                    _logger.log(Level.WARNING, "Index information not supported for" + string4);
                    return;
                }
                while (resultSet2.next()) {
                    int n;
                    int n2;
                    if (bl) {
                        n2 = resultSet2.getInt(1);
                        int n3 = resultSet2.getInt(4);
                        n = resultSet2.getInt(3);
                        string = " where t.tblid = " + n2 + " and ixid = " + n3;
                        string2 = "select rtrim(TBLOWNER) \"Table Owner\", rtrim(TBLNAME) \"Table Name\", IXTYPE \"Index Type\", ISUNIQUE Uniqueness, ISPRIMARY \"Primary\", KEYCNT \"Column Count\", KEYCOLS Columns, PAGESPARAM Pages, NLSSORTSTR from sys.tables t, sys.indexes i " + (String)string + " order by ixname, ixtype, isprimary asc";
                    } else {
                        n2 = resultSet2.getInt(1);
                        n = resultSet2.getInt(2);
                        string = " where tblid = " + n2;
                        string2 = "select rtrim(IXOWNER) \"Index Owner\", rtrim(IXNAME) \"Index Name\", IXTYPE \"Index Type\", ISUNIQUE Uniqueness, ISPRIMARY \"Primary\", KEYCNT \"Column Count\", KEYCOLS Columns, PAGESPARAM Pages, NLSSORTSTR from sys.indexes " + string + " order by ixname, ixtype, isprimary asc";
                    }
                    this.theTableColumNames = new String[n];
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SELECT colnum, rtrim(COLNAME) from SYS.COLUMNS where ID= " + n2);
                    while (resultSet.next()) {
                        this.theTableColumNames[resultSet.getInt((int)1) - 1] = resultSet.getString(2);
                    }
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string2);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    this.theNoColumnsInIndexInfo = resultSetMetaData.getColumnCount();
                    this.theIndexInfoColumnNames = new String[this.theNoColumnsInIndexInfo];
                    for (int i = 1; i <= this.theNoColumnsInIndexInfo; ++i) {
                        this.theIndexInfoColumnNames[i - 1] = resultSetMetaData.getColumnName(i);
                    }
                    while (resultSet.next()) {
                        Object[] objectArray = new Object[this.theNoColumnsInIndexInfo];
                        int n4 = 0;
                        block25: for (int i = 1; i <= this.theNoColumnsInIndexInfo; ++i) {
                            switch (i) {
                                case 1: 
                                case 2: {
                                    objectArray[i - 1] = resultSet.getString(i);
                                    continue block25;
                                }
                                case 3: {
                                    int n5 = resultSet.getInt(i);
                                    if (n5 == 0) {
                                        objectArray[i - 1] = "Hash";
                                        continue block25;
                                    }
                                    if (n5 == 1 || n5 == 3) {
                                        objectArray[i - 1] = "Range";
                                        continue block25;
                                    }
                                    if (n5 == 2) {
                                        objectArray[i - 1] = "Bitmap";
                                        continue block25;
                                    }
                                    objectArray[i - 1] = "Unknown (" + n5 + ")";
                                    continue block25;
                                }
                                case 4: {
                                    byte[] byArray = resultSet.getBytes(i);
                                    String string6 = new String(byArray);
                                    if (byArray[0] == 0) {
                                        objectArray[i - 1] = "Non-unique";
                                        continue block25;
                                    }
                                    objectArray[i - 1] = "Unique";
                                    continue block25;
                                }
                                case 5: {
                                    byte[] byArray = resultSet.getBytes(i);
                                    if (byArray[0] == 0) {
                                        objectArray[i - 1] = "No";
                                        continue block25;
                                    }
                                    objectArray[i - 1] = "Yes";
                                    continue block25;
                                }
                                case 6: {
                                    n4 = resultSet.getInt(i);
                                    objectArray[i - 1] = Integer.toString(n4);
                                    continue block25;
                                }
                                case 7: {
                                    byte[] byArray = resultSet.getBytes(i);
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                                    byteBuffer.order(ByteOrder.nativeOrder());
                                    StringBuffer stringBuffer = new StringBuffer(128);
                                    for (int j = 0; j < n4 - 1; ++j) {
                                        stringBuffer.append(this.theTableColumNames[byteBuffer.getShort() - 1]);
                                        stringBuffer.append(",");
                                    }
                                    stringBuffer.append(this.theTableColumNames[byteBuffer.getShort() - 1]);
                                    objectArray[i - 1] = stringBuffer;
                                    continue block25;
                                }
                                case 8: 
                                case 9: {
                                    objectArray[i - 1] = resultSet.getObject(i);
                                }
                            }
                        }
                        this.theRows.add(objectArray);
                    }
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information" + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return this.theIndexInfoColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumnsInIndexInfo) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theIndexInfoColumnNames[n];
        }
    }
}

