/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.model.Project;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

@Deprecated
public final class JavaProjectIndexer {
    private static JavaProjectIndexer _indexer = new JavaProjectIndexer();
    private static AsyncScheduler INDEX_SCHEDULER = new AsyncScheduler("JavaProjectIndex", 5, 1);
    private Set _indexedSet = new HashSet(50);

    public static JavaProjectIndexer getJavaProjectIndexer() {
        return _indexer;
    }

    private JavaProjectIndexer() {
    }

    private LocatorTask locatorIndexProject(Project project) {
        this.clearIndexed(project);
        LocatorTask task = new LocatorTask(project);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
        return task;
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            return this._indexedSet.contains(project);
        }
    }

    public boolean waitUntilIndexed(Project project) {
        if (this.isIndexed(project)) {
            return true;
        }
        if (!project.isOpen()) {
            return false;
        }
        this.locatorIndexProject(project);
        while (!this.isIndexed(project)) {
            JavaProjectIndexer.sleep(50);
        }
        return true;
    }

    private void markIndexed(final Project project) {
        project.runUnderReadLock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (project.isOpen()) {
                        JavaProjectIndexer.this._indexedSet.add(project);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            this._indexedSet.remove(project);
        }
    }

    private class LocatorTask
    extends IndexTask {
        private Thread thread;

        public LocatorTask(Project project) {
            super(project);
        }

        @Override
        protected ProgressTrackedTask getProgressTrackedTask(final Project project) {
            return new ProgressTrackedTask(){

                public boolean isIndeterminate() {
                    return true;
                }

                public int getCurrentValue() {
                    return 0;
                }

                public int getMinimum() {
                    return 0;
                }

                public int getMaximum() {
                    return 100;
                }

                public String getCurrentText() {
                    return project != null ? LocatorTask.this.getProgressBarText(project) : "";
                }

                public String getTaskDescription() {
                    return project != null ? LocatorTask.this.getProgressBarTooltipText(project) : "";
                }

                public void run() {
                    while (!LocatorTask.this.isFinished() && !LocatorTask.this.cancelled) {
                        LocatorTask.sleep((int)100);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void buildIndex(final Project project) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!JavaProjectIndexer.this.isIndexed(project)) {
                        JavaManager jm = JavaManager.getJavaManager(project);
                        JavaClassLocator locator = jm.getJavaClassLocator();
                        if (locator instanceof JavaClassLocator2) {
                            try {
                                ((JavaClassLocator2)locator).buildIndexInterruptibly();
                                JavaProjectIndexer.this.markIndexed(project);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            locator.buildIndex();
                            JavaProjectIndexer.this.markIndexed(project);
                        }
                    }
                }
            };
            LocatorTask locatorTask = this;
            synchronized (locatorTask) {
                if (this.cancelled) {
                    return;
                }
                this.thread = new Thread(r, "class-locator-index-" + project.getShortLabel());
                this.thread.start();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        protected String getStatusBarText(Project project) {
            String projectName = project.getShortLabel();
            String statusText = JavaArb.format(376, projectName);
            return statusText;
        }

        @Override
        protected String getProgressBarText(Project project) {
            return JavaArb.getString(377);
        }

        @Override
        protected String getProgressBarTooltipText(Project project) {
            return this.getStatusBarText(project);
        }

        @Override
        protected synchronized void requestCancelImpl() {
            super.requestCancelImpl();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    private abstract class IndexTask
    extends AsyncTask {
        private Project _project;
        protected volatile boolean cancelled;

        public IndexTask(Project project) {
            this._project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() {
            if (this._project != null && this._project.isOpen()) {
                final ProgressTrackedTask trackedTask = this.getProgressTrackedTask(this._project);
                final ProgressTracker tracker = Ide.getStatusBar().getProgressTracker();
                Runnable addTrackerOnUIThread = new Runnable(){

                    @Override
                    public void run() {
                        tracker.addTask(trackedTask, "BackgroundKeywordIndexer");
                    }
                };
                SwingUtilities.invokeLater(addTrackerOnUIThread);
                String statusText = this.getStatusBarText(this._project);
                if (statusText != null && statusText.length() > 0) {
                    Ide.getStatusBar().setText(statusText);
                }
                try {
                    this.buildIndex(this._project);
                }
                finally {
                    if (statusText != null && statusText.equals(Ide.getStatusBar().getText())) {
                        Ide.getStatusBar().setText("");
                    }
                }
            }
            return Boolean.TRUE;
        }

        protected abstract ProgressTrackedTask getProgressTrackedTask(Project var1);

        protected abstract void buildIndex(Project var1);

        protected abstract String getStatusBarText(Project var1);

        protected abstract String getProgressBarText(Project var1);

        protected abstract String getProgressBarTooltipText(Project var1);

        protected void requestCancelImpl() {
            this.cancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.cancelled;
        }
    }
}

