/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.clients.uieditor;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProjectFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.util.JRLClassLoader;

class CombinedProvider
extends CachedFileProvider {
    private CachedFileProvider _primaryProvider;
    private URLPath _secondaryPath;
    private BaseClassLocator _secondaryLocator;
    private ClassLoader _primaryLoader;
    private JavaClassLocator _mainLocator;

    CombinedProvider(ProviderContext context, CachedFileProvider primaryProvider, URLPath secondaryPath) {
        super(context);
        this._primaryProvider = primaryProvider;
        this._primaryLoader = null;
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._secondaryPath = secondaryPath;
        this._secondaryLocator = factory.getPathLocator(null, secondaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        ClassLoader checkPrimary = this._primaryProvider.getClassLoader();
        CombinedProvider combinedProvider = this;
        synchronized (combinedProvider) {
            if (this._primaryLoader != checkPrimary) {
                this._primaryLoader = null;
                this.clearClassLoader();
            }
            if (this._defaultClassLoader == null) {
                this._primaryLoader = checkPrimary;
                ClassLoader osgiAndProjectsLoader = this._primaryProvider.getClassLoader(CombinedProvider.class.getClassLoader());
                this._defaultClassLoader = new JRLClassLoader(osgiAndProjectsLoader, (JavaResourceLocator)this._secondaryLocator);
            }
            return this._defaultClassLoader;
        }
    }

    public void reloadProjectPaths() {
        ((ProjectFileProvider)this._primaryProvider).reloadClassLocator();
        this.flushCache();
        this.clearCompiledInfo();
        this.clearClassLoader();
    }

    public void beginCacheUse() {
        super.beginCacheUse();
        this._primaryProvider.beginCacheUse();
    }

    public void endCacheUse() {
        super.endCacheUse();
        this._primaryProvider.endCacheUse();
    }

    public void flushCache() {
        super.flushCache();
        this._primaryProvider.flushCache();
    }

    public JavaClassLocator getClassLocator() {
        return this._secondaryLocator;
    }

    public JavaClassLocator getPublicClassLocator() {
        if (this._mainLocator == null) {
            this._mainLocator = new CombinedLocator();
        }
        return this._mainLocator;
    }

    public JavaFile getFile(URL url) {
        URL[] paths = this._secondaryPath.getEntries();
        int pathCount = paths == null ? 0 : paths.length;
        for (int i = 0; i < pathCount; ++i) {
            URL path = paths[i];
            if (!URLFileSystem.isBaseURLFor((URL)path, (URL)url)) continue;
            return super.getFile(url);
        }
        JavaFile javaFile = this._primaryProvider.getFile(url);
        if (javaFile == null) {
            javaFile = super.getFile(url);
        }
        return javaFile;
    }

    JavaFile getOwningFile(JavaClass javaClass) {
        return this.getJavaFile(javaClass);
    }

    public SourceFile getSourceFile(URL sourceURL) {
        return this._primaryProvider.getSourceFile(sourceURL);
    }

    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        return this._primaryProvider.createSourceFile(sourceURL);
    }

    public JavaClass getClass(String fqName) {
        JavaClass javaClass = this._primaryProvider.getClass(fqName);
        if (javaClass == null) {
            javaClass = super.getClass(fqName);
        }
        return javaClass;
    }

    public JavaClass getClassInterruptibly(String fqName) throws InterruptedException {
        JavaClass javaClass = this._primaryProvider.getClassInterruptibly(fqName);
        if (javaClass == null) {
            javaClass = super.getClassInterruptibly(fqName);
        }
        return javaClass;
    }

    public JavaClass getClass(String fqPrefix, String name) {
        JavaClass javaClass = this._primaryProvider.getClass(fqPrefix, name);
        if (javaClass == null) {
            javaClass = super.getClass(fqPrefix, name);
        }
        return javaClass;
    }

    public JavaClass getClassInterruptibly(String fqPrefix, String name) throws InterruptedException {
        JavaClass javaClass = this._primaryProvider.getClassInterruptibly(fqPrefix, name);
        if (javaClass == null) {
            javaClass = super.getClassInterruptibly(fqPrefix, name);
        }
        return javaClass;
    }

    public JavaClass getClassByVMName(String fqVMName) {
        JavaClass javaClass = this._primaryProvider.getClassByVMName(fqVMName);
        if (javaClass == null) {
            javaClass = super.getClassByVMName(fqVMName);
        }
        return javaClass;
    }

    public JavaClass getClassByVMNameInterruptibly(String fqVMName) throws InterruptedException {
        JavaClass javaClass = this._primaryProvider.getClassByVMNameInterruptibly(fqVMName);
        if (javaClass == null) {
            javaClass = super.getClassByVMNameInterruptibly(fqVMName);
        }
        return javaClass;
    }

    public SourceClass getSourceClass(String fqName) {
        return this._primaryProvider.getSourceClass(fqName);
    }

    public SourceClass getSourceClassInterruptibly(String fqName) throws InterruptedException {
        return this._primaryProvider.getSourceClassInterruptibly(fqName);
    }

    public TextBuffer getTextBuffer(URL url) {
        return this._primaryProvider.getTextBuffer(url);
    }

    private class CombinedLocator
    implements JavaClassLocator,
    JavaResourceLocator {
        private CombinedLocator() {
        }

        public void buildIndex() {
        }

        public Collection<String> getPackages(String packagePrefix) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryPackages = primaryLocator.getPackages(packagePrefix);
            Collection secondaryPackages = CombinedProvider.this._secondaryLocator.getPackages(packagePrefix);
            int count = primaryPackages.size() + secondaryPackages.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection<String> getClassesInPackage(String packagePrefix) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesInPackage(packagePrefix);
            Collection secondaryClasses = CombinedProvider.this._secondaryLocator.getClassesInPackage(packagePrefix);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection<String> getAllClasses() {
            return this.getAllClasses(null);
        }

        public Collection<String> getAllClasses(ClassNameFilter filter) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryClasses = primaryLocator.getAllClasses(filter);
            Collection secondaryClasses = CombinedProvider.this._secondaryLocator.getAllClasses(filter);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection<String> getAllPackages() {
            return this.getAllPackages(null);
        }

        public Collection<String> getAllPackages(PackageNameFilter filter) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryPackages = primaryLocator.getAllPackages(filter);
            Collection secondaryPackages = CombinedProvider.this._secondaryLocator.getAllPackages(filter);
            int count = primaryPackages.size() + secondaryPackages.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection<String> getClassesByName(String name, boolean matchCase) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesByName(name, matchCase);
            Collection secondaryClasses = CombinedProvider.this._secondaryLocator.getClassesByName(name, matchCase);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection<String> getClassesByPrefix(String prefix, boolean matchCase) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesByPrefix(prefix, matchCase);
            Collection secondaryClasses = CombinedProvider.this._secondaryLocator.getClassesByPrefix(prefix, matchCase);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public URL getURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            URL resultURL = primaryLocator.getURL(fqClassName);
            if (resultURL == null) {
                resultURL = CombinedProvider.this._secondaryLocator.getClassURL(fqClassName);
            }
            return resultURL;
        }

        public URL getSourceURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            return primaryLocator.getSourceURL(fqClassName);
        }

        public URL getClassURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            URL resultURL = primaryLocator.getClassURL(fqClassName);
            if (resultURL == null) {
                resultURL = CombinedProvider.this._secondaryLocator.getClassURL(fqClassName);
            }
            return resultURL;
        }

        public URL getResourceURL(String resourceName) {
            URL resultURL = null;
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            if (primaryLocator instanceof JavaResourceLocator) {
                resultURL = ((JavaResourceLocator)primaryLocator).getResourceURL(resourceName);
            }
            if (resultURL == null) {
                resultURL = CombinedProvider.this._secondaryLocator.getResourceURL(resourceName);
            }
            return resultURL;
        }

        public Collection<URL> getResourceURLs(String resourceName) {
            LinkedList<URL> result = new LinkedList<URL>();
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            if (primaryLocator instanceof JavaResourceLocator) {
                result.addAll(((JavaResourceLocator)primaryLocator).getResourceURLs(resourceName));
            }
            result.addAll(CombinedProvider.this._secondaryLocator.getResourceURLs(resourceName));
            return result;
        }

        public String getModuleNameOfClass(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.this._primaryProvider.getClassLocator();
            String result = primaryLocator.getModuleNameOfClass(fqClassName);
            if (result == null) {
                result = CombinedProvider.this._secondaryLocator.getModuleNameOfClass(fqClassName);
            }
            return result;
        }
    }
}

