/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.controls.SortedListModel;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdeveloper.builder.cls.ClassBuilderPanel;
import oracle.jdeveloper.builder.iface.InterfaceBuilderPanel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilter2V2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.dialogs.ClassPackageListItem;
import oracle.jdeveloper.util.Helpers;

public class InterfaceSelectionPanel
extends JPanel {
    private final JList _interfaceList = new JList();
    private final JButton _addButton = new JButton();
    private final JButton _removeButton = new JButton();
    private final JScrollPane _scroller = new JScrollPane(this._interfaceList);
    private final JLabel _listLabel = new JLabel();
    private String _initialSearchString = "";
    private Project _project;
    private static final InterfaceOnlyFilter FILTER = new InterfaceOnlyFilter();

    public InterfaceSelectionPanel() {
        this((Project)null);
    }

    public InterfaceSelectionPanel(Project project) {
        this.setProject(project);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProject(Project project) {
        this._project = project;
    }

    public void setInitialSearchString(String initialSearchString) {
        this._initialSearchString = initialSearchString == null ? "" : initialSearchString;
    }

    public void setListLabel(String label) {
        ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._scroller, (String)label);
    }

    public List<String> getInterfaces() {
        DefaultListModel model = (DefaultListModel)this._interfaceList.getModel();
        int count = model.size();
        if (count > 0) {
            ArrayList<String> list = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                list.add(model.get(i).toString());
            }
            return list;
        }
        return Collections.emptyList();
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(375, 98));
        EventHandler handler = new EventHandler();
        IconicButtonUI.install((AbstractButton)this._addButton);
        this._addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._addButton.setToolTipText(BuilderArb.getString(158));
        this._addButton.addActionListener(handler);
        IconicButtonUI.install((AbstractButton)this._removeButton);
        this._removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._removeButton.setToolTipText(BuilderArb.getString(159));
        this._removeButton.setEnabled(false);
        this._removeButton.addActionListener(handler);
        SortedListModel listModel = new SortedListModel();
        listModel.setComparator((Comparator)ClassPackageListItem.COMPARATOR);
        this._interfaceList.setModel(listModel);
        this._interfaceList.setCellRenderer(new ListDataItemCellRenderer());
        this._interfaceList.addListSelectionListener(handler);
        ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._scroller, (String)BuilderArb.getString(157));
        ControlBar bar = new ControlBar();
        bar.add((Component)this._addButton);
        bar.add((Component)this._removeButton);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar((JComponent)this._scroller, this._listLabel, bar);
        this.setLayout(new BorderLayout());
        this.add((Component)componentWithTitlebar);
    }

    private void checkEnableRemoveButton() {
        this._removeButton.setEnabled(this._interfaceList.getSelectedIndices().length > 0);
    }

    private void whenAdd() {
        Assert.precondition((this._project != null ? 1 : 0) != 0, (String)"The project has not been initialized.");
        String packageName = null;
        for (Container component = this.getParent(); component != null; component = component.getParent()) {
            if (component instanceof ClassBuilderPanel) {
                packageName = ((ClassBuilderPanel)component).getPackageName();
                break;
            }
            if (component instanceof InterfaceBuilderPanel) {
                packageName = ((InterfaceBuilderPanel)component).getPackageName();
                break;
            }
            if (component instanceof Dialog) break;
        }
        FILTER.setPackage(packageName);
        String[] results = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this._project, 2, true, FILTER, this._initialSearchString);
        if (results.length > 0) {
            ListSelectionModel listSelectionModel = this._interfaceList.getSelectionModel();
            listSelectionModel.clearSelection();
            DefaultListModel model = (DefaultListModel)this._interfaceList.getModel();
            for (int i = 0; i < results.length; ++i) {
                ClassPackageListItem interfaceItem = new ClassPackageListItem(results[i], ClassPackageListItem.Type.INTERFACE_ITEM_UNQ);
                int index = model.indexOf((Object)interfaceItem);
                if (index != -1) {
                    listSelectionModel.addSelectionInterval(index, index);
                    continue;
                }
                model.addElement(interfaceItem);
                int newIndex = model.indexOf((Object)interfaceItem);
                listSelectionModel.addSelectionInterval(newIndex, newIndex);
            }
        }
    }

    private void whenRemove() {
        int first = this._interfaceList.getLeadSelectionIndex();
        Object[] selected = this._interfaceList.getSelectedValues();
        DefaultListModel model = (DefaultListModel)this._interfaceList.getModel();
        for (int i = 0; i < selected.length; ++i) {
            int index = model.indexOf(selected[i]);
            model.remove(index);
        }
        int size = model.size();
        if (size > 0) {
            int newIndex = Math.min(size - 1, first);
            this._interfaceList.setSelectedIndex(Math.max(newIndex, 0));
        }
        this.checkEnableRemoveButton();
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == InterfaceSelectionPanel.this._addButton) {
                InterfaceSelectionPanel.this.whenAdd();
            } else if (source == InterfaceSelectionPanel.this._removeButton) {
                InterfaceSelectionPanel.this.whenRemove();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            InterfaceSelectionPanel.this.checkEnableRemoveButton();
        }
    }

    private static class InterfaceOnlyFilter
    implements ClassPackageBrowserFilter2V2 {
        private String pkg;

        private InterfaceOnlyFilter() {
        }

        @Override
        public void setContext(Context context) {
        }

        private void setPackage(String pkg) {
            this.pkg = pkg;
        }

        @Override
        public boolean acceptPackage(String pkg) {
            return true;
        }

        @Override
        public boolean acceptClass(JavaClass cls) {
            return cls.isInterface() && (this.pkg == null || Helpers.isClassAccessible(cls, this.pkg));
        }
    }
}

