/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.CompoundType;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public abstract class SequenceOf
extends CompoundType {
    public SequenceOf(Tag tag) {
        super("", tag);
    }

    public SequenceOf(String name, Tag tag) {
        super(name, tag);
    }

    public SequenceOf(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            if (value instanceof ArrayList) {
                this.value(value);
            } else {
                throw new ClassCastException();
            }
        }
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        this.reset();
        is.mark(Integer.MAX_VALUE);
        ASNReader local = is.decodeStructure(this);
        if (local == null) {
            is.reset();
            throw new ASNException(1, "Decoding SEQUENCE OF");
        }
        while (true) {
            ArrayList e = this.cloneComponents();
            int found = 0;
            try {
                for (Type t : e) {
                    try {
                        t.decode(local);
                        ++found;
                    }
                    catch (ASNException x) {
                        if (x.getCurrentIndex() != 1 || t.isOptional()) continue;
                        is.reset();
                        throw x;
                    }
                }
                this.iterator().add(e);
            }
            catch (EOFException x) {
                if (found > 0) {
                    this.iterator().add(e);
                }
                return;
            }
        }
    }

    @Override
    public void value(Object value) {
        this.reset();
        if (value instanceof IType) {
            value = ((IType)value).value();
        }
        if (value instanceof ArrayList) {
            Iterator frame = ((ArrayList)value).iterator();
            int i = 1;
            while (frame.hasNext()) {
                IType td = (IType)this.cloneComponents().iterator().next();
                td.value(frame.next());
                this.iterator().add(td);
                ++i;
            }
        } else {
            RuntimeException x = new RuntimeException();
            x.printStackTrace(System.err);
            throw x;
        }
    }

    public String toString() {
        String cn = this.getClass().getName();
        String ls = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(ls);
        sb.append("-- Begin ").append(cn).append(" (SEQUENCE OF)").append(ls);
        int i = 1;
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            Object t = it.next();
            sb.append("-- frame #").append(i++).append(" (").append(t.getClass().getName()).append("): ").append(String.valueOf(t)).append(ls);
        }
        sb.append("-- End ").append(cn).append(" (SEQUENCE OF)");
        return sb.toString();
    }
}

