/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;

public class TwoPortLinkItem
extends LinkItem {
    private LinkPort _source;
    private LinkPort _destination;
    private LinkPort[] _sourcePorts;
    private LinkPort[] _destPorts;
    private boolean _sourceLocked = false;
    private boolean _destLocked = false;

    public TwoPortLinkItem(LinkPort source, LinkPort destination) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        this._setSourcePort(source, false);
        this.setDestinationPort(destination);
    }

    public TwoPortLinkItem(LinkPort[] sourcePorts, LinkPort[] destPorts) {
        if (sourcePorts == null || destPorts == null || sourcePorts.length < 1 || destPorts.length < 1) {
            throw new IllegalArgumentException();
        }
        this._sourcePorts = new LinkPort[sourcePorts.length];
        this._destPorts = new LinkPort[destPorts.length];
        System.arraycopy(sourcePorts, 0, this._sourcePorts, 0, this._sourcePorts.length);
        System.arraycopy(destPorts, 0, this._destPorts, 0, this._destPorts.length);
        this.setPorts(new LinkPort[]{this._sourcePorts[0], this._destPorts[0]});
        this.updatePorts(null);
    }

    @Override
    public void setPorts(LinkPort[] ports) {
        if (ports == null || ports.length < 2) {
            throw new IllegalArgumentException();
        }
        this._setSourcePort(ports[0], false);
        this.setDestinationPort(ports[1]);
    }

    @Override
    public LinkPort[] getPorts() {
        LinkPort[] temp = new LinkPort[]{this._source, this._destination};
        return temp;
    }

    @Override
    public int getPortCount() {
        return 2;
    }

    public void setSourcePort(LinkPort source) {
        this._setSourcePort(source, true);
    }

    public void setDestinationPort(LinkPort destination) {
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        if (this._destination != null) {
            this._destination.removeLinkPortListener(this);
        }
        this._destination = destination;
        this._destination.addLinkPortListener(this);
        this.updateBounds();
        this.repaintItem();
    }

    public LinkPort getSourcePort() {
        return this._source;
    }

    public LinkPort getDestinationPort() {
        return this._destination;
    }

    public void lockPort(LinkPort lock) {
        if (lock == this._destination) {
            this._destLocked = true;
        } else if (lock == this._source) {
            this._sourceLocked = true;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void unlockPort(LinkPort lock) {
        if (lock == this._destination) {
            this._destLocked = false;
        } else if (lock == this._source) {
            this._sourceLocked = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected LinkPort[] updatePorts(LinkPort altered) {
        LinkPort curr;
        int i;
        LinkPort[] linkPortArray;
        LinkPort[] sources;
        LinkPort oldSource = this._source;
        LinkPort oldDest = this._destination;
        if (this._sourceLocked) {
            LinkPort[] linkPortArray2 = new LinkPort[1];
            v1 = linkPortArray2;
            linkPortArray2[0] = this._source;
        } else {
            v1 = sources = this._sourcePorts != null ? this._sourcePorts : LinkTool.getLinkPorts(this.getSourcePort().getItem());
        }
        if (this._destLocked) {
            LinkPort[] linkPortArray3 = new LinkPort[1];
            linkPortArray = linkPortArray3;
            linkPortArray3[0] = this._destination;
        } else {
            linkPortArray = this._destPorts != null ? this._destPorts : LinkTool.getLinkPorts(this.getDestinationPort().getItem());
        }
        LinkPort[] dests = linkPortArray;
        Point2D[] sourcePoints = new Point2D[sources.length];
        Point2D[] destPoints = new Point2D[dests.length];
        for (i = 0; i < sourcePoints.length; ++i) {
            curr = sources[i];
            sourcePoints[i] = curr.isDead() ? null : ItemUtils.itemToDevice(curr.getItem(), curr.getX(), curr.getY());
        }
        for (i = 0; i < destPoints.length; ++i) {
            curr = dests[i];
            destPoints[i] = curr.isDead() ? null : ItemUtils.itemToDevice(curr.getItem(), curr.getX(), curr.getY());
        }
        int newSource = 0;
        int newDest = 0;
        double lowDistance = Double.MAX_VALUE;
        for (int i2 = 0; i2 < sourcePoints.length; ++i2) {
            Point2D currSource = sourcePoints[i2];
            if (currSource == null) continue;
            for (int j = 0; j < destPoints.length; ++j) {
                double distance;
                Point2D currDest = destPoints[j];
                if (currDest == null || !((distance = GeometryUtils.segmentLength(currSource.getX(), currSource.getY(), currDest.getX(), currDest.getY())) < lowDistance)) continue;
                lowDistance = distance;
                newSource = i2;
                newDest = j;
            }
        }
        LinkPort[] newPorts = new LinkPort[]{sources[newSource], dests[newDest]};
        if (newPorts[0] != oldSource || newPorts[1] != oldDest) {
            this.setPorts(newPorts);
        } else {
            this.updateBounds();
        }
        this.repaintItem();
        return newPorts;
    }

    private void _setSourcePort(LinkPort source, boolean update) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this._source != null) {
            this._source.removeLinkPortListener(this);
        }
        this._source = source;
        this._source.addLinkPortListener(this);
        if (update) {
            this.updateBounds();
            this.repaintItem();
        }
    }
}

