/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.svg.CustomShapesParser;
import oracle.dss.util.svg.SVGShapesHandler;
import oracle.dss.util.xml.SecureParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser
extends CustomShapesParser {
    public SVGParser(ErrorHandler eh) {
        super(eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFile(String path) {
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(path);
            this.parseFile(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
        }
    }

    @Override
    public void parseFile(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            SAXParser saxParser = SecureParserFactory.getSAXParser();
            SVGShapesHandler myHandler = new SVGShapesHandler(this);
            saxParser.parse(stream, (DefaultHandler)myHandler);
        }
        catch (Exception e) {
            if (this.m_eh != null) {
                this.m_eh.log("Problem parsing SVG Custom Shapes File: " + e.getStackTrace(), this.getClass().getName(), "parseFile");
            }
            e.printStackTrace();
        }
    }
}

