/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.presutil;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.presutil.FontTextEntry;
import oracle.dss.presutil.PresUtils;
import oracle.dss.presutil.XMLWriter;
import oracle.dss.util.ErrorHandler;

public class SVGWriter
extends XMLWriter {
    private boolean m_bCommonScriptWritten = false;
    private boolean m_bTooltipsScriptWritten = false;
    private boolean m_bCommonScrollbarScriptWritten = false;
    private boolean m_bHScrollScriptWritten = false;
    private boolean m_bVScrollScriptWritten = false;
    private boolean m_bFontEmbedding = false;
    private Map m_fontTextMap = null;
    protected boolean m_fontTextMapped = false;
    protected ArrayList m_scriptIds = null;
    protected String m_id;
    private static final int NORMALIZED_FONT_SIZE = 100;
    protected static final String TOOLTIP_LINE_DELIMITER = ";; ";
    protected static final String NAMESPACE_SVG = "http://www.w3.org/2000/svg";
    protected static final String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
    protected static final String NAMESPACE_XLINK = "http://www.w3.org/1999/xlink";
    protected static final String JS_SHOW_TITLE_TOOLTIP = "bi_showSVGTitleTooltip(evt, beanName)";
    protected static final String JS_SHOW_TOOLTIP = "bi_showSVGTooltip(evt, lines, bAutoHide, beanName)";
    protected static final String JS_HIDE_TOOLTIP = "bi_hideSVGTooltip(beanName)";
    public static final String ELEM_A = "a";
    public static final String ELEM_CIRCLE = "circle";
    public static final String ELEM_CLIP_PATH = "clipPath";
    public static final String ELEM_DEFS = "defs";
    public static final String ELEM_DESC = "desc";
    public static final String ELEM_ELLIPSE = "ellipse";
    public static final String ELEM_FONT = "font";
    public static final String ELEM_FONT_FACE = "font-face";
    public static final String ELEM_G = "g";
    public static final String ELEM_GLYPH = "glyph";
    public static final String ELEM_IMAGE = "image";
    public static final String ELEM_LINE = "line";
    public static final String ELEM_LINEAR_GRADIENT = "linearGradient";
    public static final String ELEM_METADATA = "metadata";
    public static final String ELEM_MISSING_GLYPH = "missing-glyph";
    public static final String ELEM_PATH = "path";
    public static final String ELEM_PATTERN = "pattern";
    public static final String ELEM_POLYGON = "polygon";
    public static final String ELEM_POLYLINE = "polyline";
    public static final String ELEM_RADIAL_GRADIENT = "radialGradient";
    public static final String ELEM_RECT = "rect";
    public static final String ELEM_SCRIPT = "script";
    public static final String ELEM_ENCSCRIPT = "orabiscript";
    public static final String ELEM_STOP = "stop";
    public static final String ELEM_SVG = "svg";
    public static final String ELEM_TEXT = "text";
    public static final String ELEM_TITLE = "title";
    public static final String ATTR_ASCENT = "ascent";
    public static final String ATTR_CLIP_PATH = "clip-path";
    public static final String ATTR_CX = "cx";
    public static final String ATTR_CY = "cy";
    public static final String ATTR_D = "d";
    public static final String ATTR_DESCENT = "descent";
    public static final String ATTR_FILL = "fill";
    public static final String ATTR_FILL_OPACITY = "fill-opacity";
    public static final String ATTR_FONT_FAMILY = "font-family";
    public static final String ATTR_FONT_SIZE = "font-size";
    public static final String ATTR_FONT_STYLE = "font-style";
    public static final String ATTR_FONT_WEIGHT = "font-weight";
    public static final String ATTR_GRADIENT_UNITS = "gradientUnits";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_HORIZ_ADV_X = "horiz-adv-x";
    public static final String ATTR_ID = "id";
    public static final String ATTR_OFFSET = "offset";
    public static final String ATTR_ONCLICK = "onclick";
    public static final String ATTR_ONFOCUSIN = "onfocusin";
    public static final String ATTR_ONFOCUSOUT = "onfocusout";
    public static final String ATTR_ONLOAD = "onload";
    public static final String ATTR_ONMOUSEDOWN = "onmousedown";
    public static final String ATTR_ONMOUSEMOVE = "onmousemove";
    public static final String ATTR_ONMOUSEOUT = "onmouseout";
    public static final String ATTR_ONMOUSEOVER = "onmouseover";
    public static final String ATTR_ONMOUSEUP = "onmouseup";
    public static final String ATTR_PATTERN_UNITS = "patternUnits";
    public static final String ATTR_POINTS = "points";
    public static final String ATTR_POINTER_EVENTS = "pointer-events";
    public static final String ATTR_R = "r";
    public static final String ATTR_RX = "rx";
    public static final String ATTR_RY = "ry";
    public static final String ATTR_STOP_COLOR = "stop-color";
    public static final String ATTR_STOP_OPACITY = "stop-opacity";
    public static final String ATTR_STROKE = "stroke";
    public static final String ATTR_STROKE_DASHARRAY = "stroke-dasharray";
    public static final String ATTR_STROKE_DASHOFFSET = "stroke-dashoffset";
    public static final String ATTR_STROKE_LINECAP = "stroke-linecap";
    public static final String ATTR_STROKE_MITERLIMIT = "stroke-miterlimit";
    public static final String ATTR_STROKE_OPACITY = "stroke-opacity";
    public static final String ATTR_STROKE_WIDTH = "stroke-width";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_TEXT_DECORATION = "text-decoration";
    public static final String ATTR_TRANSFORM = "transform";
    public static final String ATTR_UNICODE = "unicode";
    public static final String ATTR_UNITS_PER_EM = "units-per-em";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_X = "x";
    public static final String ATTR_X1 = "x1";
    public static final String ATTR_X2 = "x2";
    public static final String ATTR_XLINK_HREF = "xlink:href";
    public static final String ATTR_Y = "y";
    public static final String ATTR_Y1 = "y1";
    public static final String ATTR_Y2 = "y2";

    public SVGWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
    }

    public SVGWriter(OutputStream os, ErrorHandler eh) {
        this(os, eh, null);
    }

    public SVGWriter(Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
    }

    public SVGWriter(Writer writer, ErrorHandler eh) {
        this(writer, eh, null);
    }

    public void setFontEmbedding(boolean bEmbed) {
        this.m_bFontEmbedding = bEmbed;
    }

    public boolean isFontEmbedding() {
        return this.m_bFontEmbedding;
    }

    public void writeSVGHeader() throws IOException, Exception {
        this.writeXMLHeader("1.0", null);
        this.print("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" ");
        this.println("\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">");
    }

    public boolean startSVGElement() throws IOException, Exception {
        this.startElement(ELEM_SVG);
        this.writeAttribute("xmlns", NAMESPACE_SVG);
        this.writeAttribute("xmlns:xlink", NAMESPACE_XLINK);
        return true;
    }

    public void writeTitleElement(String title) throws IOException, Exception {
        this.startElement(ELEM_TITLE);
        this.writeText(title);
        this.endElement();
    }

    public boolean startLineElement(int x1, int y1, int x2, int y2) throws IOException, Exception {
        this.startElement(ELEM_LINE);
        this.writeAttribute(ATTR_X1, x1);
        this.writeAttribute(ATTR_Y1, y1);
        this.writeAttribute(ATTR_X2, x2);
        this.writeAttribute(ATTR_Y2, y2);
        return true;
    }

    public boolean startLineElement(double x1, double y1, double x2, double y2) throws IOException, Exception {
        this.startElement(ELEM_LINE);
        this.writeAttribute(ATTR_X1, x1);
        this.writeAttribute(ATTR_Y1, y1);
        this.writeAttribute(ATTR_X2, x2);
        this.writeAttribute(ATTR_Y2, y2);
        return true;
    }

    public boolean startRectElement(int x, int y, int width, int height) throws IOException, Exception {
        this.startElement(ELEM_RECT);
        this.writeAttribute(ATTR_X, x);
        this.writeAttribute(ATTR_Y, y);
        this.writeAttribute(ATTR_WIDTH, width);
        this.writeAttribute(ATTR_HEIGHT, height);
        return true;
    }

    public boolean startRectElement(Rectangle rect) throws IOException, Exception {
        if (rect != null) {
            return this.startRectElement(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.m_eh != null) {
            this.m_eh.log("rect null", this.getClass().getName(), "public boolean startRectElement(Rectangle rect)");
        }
        return false;
    }

    public boolean startRoundedRectElement(int x, int y, int width, int height, int rx, int ry) throws IOException, Exception {
        boolean written = this.startRectElement(x, y, width, height);
        if (written) {
            this.writeAttribute(ATTR_RX, rx / 2);
            this.writeAttribute(ATTR_RY, ry / 2);
        }
        return written;
    }

    public boolean startRoundedRectElement(Rectangle rect, int rx, int ry) throws IOException, Exception {
        if (rect != null) {
            boolean written = this.startRectElement(rect);
            if (written) {
                this.writeAttribute(ATTR_RX, rx / 2);
                this.writeAttribute(ATTR_RY, ry / 2);
            }
            return written;
        }
        if (this.m_eh != null) {
            this.m_eh.log("rect null", this.getClass().getName(), "public boolean startRectElement(Rectangle rect)");
        }
        return false;
    }

    public boolean startCircleElement(int cx, int cy, int r) throws IOException, Exception {
        this.startElement(ELEM_CIRCLE);
        this.writeAttribute(ATTR_CX, cx);
        this.writeAttribute(ATTR_CY, cy);
        this.writeAttribute(ATTR_R, r);
        return true;
    }

    public boolean startEllipseElement(int cx, int cy, int rx, int ry) throws IOException, Exception {
        this.startElement(ELEM_ELLIPSE);
        this.writeAttribute(ATTR_CX, cx);
        this.writeAttribute(ATTR_CY, cy);
        this.writeAttribute(ATTR_RX, rx);
        this.writeAttribute(ATTR_RY, ry);
        return true;
    }

    public boolean startEllipseElement(Rectangle rect) throws IOException, Exception {
        int rx = rect.width / 2;
        int ry = rect.height / 2;
        int cx = rect.x + rx;
        int cy = rect.y + ry;
        return this.startEllipseElement(cx, cy, rx, ry);
    }

    public boolean startCircleOrEllipseElement(Rectangle rect) throws IOException, Exception {
        int rx = rect.width / 2;
        int ry = rect.height / 2;
        int cx = rect.x + rx;
        int cy = rect.y + ry;
        if (rx == ry) {
            return this.startCircleElement(cx, cy, rx);
        }
        return this.startEllipseElement(cx, cy, rx, ry);
    }

    public boolean startPolylineElement(Point[] points) throws IOException, Exception {
        if (points != null && points.length > 0) {
            this.startElement(ELEM_POLYLINE);
            this.writeAttribute(ATTR_FILL, "none");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < points.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(points[i].getX());
                sb.append(',');
                sb.append(points[i].getY());
            }
            this.writeAttribute(ATTR_POINTS, sb.toString());
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("invalid polyline information", this.getClass().getName(), "public boolean startPolylineElement(Points[] points)");
        }
        return false;
    }

    public boolean startPolygonElement(int[] xCoords, int[] yCoords, int count) throws IOException, Exception {
        int numPoints = count;
        if (numPoints < 0) {
            numPoints = xCoords.length;
        }
        if (xCoords != null && yCoords != null && xCoords.length >= numPoints && yCoords.length >= numPoints) {
            this.startElement(ELEM_POLYGON);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < numPoints; ++i) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(xCoords[i]);
                sb.append(',');
                sb.append(yCoords[i]);
            }
            this.writeAttribute(ATTR_POINTS, sb.toString());
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("invalid polygon information", this.getClass().getName(), "public boolean startPolygonElement(int[] xCoords, int[] yCoords, int count)");
        }
        return false;
    }

    public boolean startPolygonElement(Polygon p) throws IOException, Exception {
        if (p != null) {
            return this.startPolygonElement(p.xpoints, p.ypoints, p.npoints);
        }
        if (this.m_eh != null) {
            this.m_eh.log("null Polygon", this.getClass().getName(), "public boolean startPolygonElement(Polygon p)");
        }
        return false;
    }

    public boolean startPathElement(Shape shape) throws IOException, Exception {
        boolean ret = false;
        if (shape != null) {
            String pathString = this.convertShapeToPath(shape);
            if (pathString != null && pathString.length() > 0) {
                this.startElement(ELEM_PATH);
                this.writeAttribute(ATTR_D, pathString);
                ret = true;
            } else if (this.m_eh != null) {
                this.m_eh.log("no points on path", this.getClass().getName(), "public boolean startPathElement(Shape shape)");
            }
        } else if (this.m_eh != null) {
            this.m_eh.log("null Shape", this.getClass().getName(), "public boolean startPathElement(Shape shape)");
        }
        return ret;
    }

    public boolean startTextElement(int x, int y) throws IOException, Exception {
        this.startElement(ELEM_TEXT);
        this.writeAttribute("xml:space", "preserve");
        this.writeAttribute(ATTR_X, x);
        this.writeAttribute(ATTR_Y, y);
        return true;
    }

    public boolean startImageElement(int width, int height, String url) throws IOException, Exception {
        if (url != null) {
            this.startElement(ELEM_IMAGE);
            this.writeAttribute(ATTR_XLINK_HREF, url);
            this.writeAttribute(ATTR_WIDTH, width);
            this.writeAttribute(ATTR_HEIGHT, height);
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("url null", this.getClass().getName(), "public boolean startImageElement(int width, int height, String url)");
        }
        return false;
    }

    public void writeImageElement(int x, int y, int width, int height, String url) throws IOException, Exception {
        if (this.startImageElement(width, height, url)) {
            this.writeAttribute(ATTR_X, x);
            this.writeAttribute(ATTR_Y, y);
            this.endElement();
        }
    }

    public void writeFontAttributes(Font font) throws IOException, Exception {
        String fontFamily;
        String fontSize;
        String fontWeight;
        StringBuilder sb = new StringBuilder();
        String fontStyle = SVGWriter.getFontStyle(font.getStyle());
        if (fontStyle != null) {
            sb.append(fontStyle);
        }
        if ((fontWeight = SVGWriter.getFontWeight(font.getStyle())) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(fontWeight);
        }
        if ((fontSize = SVGWriter.getFontSize(font.getSize())) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(fontSize);
        }
        if ((fontFamily = SVGWriter.getFontFamily(font.getName(), true)) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(fontFamily);
        }
        if (sb.length() > 0) {
            sb.insert(0, "font:");
            this.writeAttribute(ATTR_STYLE, sb.toString());
        }
        this.writeTextDecorationAttribute(font);
    }

    public void writeFontFamilyAttribute(String name) throws IOException, Exception {
        this.writeFontFamilyAttribute(name, true);
    }

    public void writeFontFamilyAttribute(String name, boolean bQuotes) throws IOException, Exception {
        String mappedName = SVGWriter.getFontFamily(name, bQuotes);
        if (mappedName != null) {
            this.writeAttribute(ATTR_FONT_FAMILY, mappedName);
        }
    }

    protected static String getFontFamily(String name, boolean bQuotes) {
        String ret = PresUtils.mapJavaFontToHTMLFont(name, true);
        if (bQuotes && ret.indexOf(32) > -1) {
            StringBuilder sb = new StringBuilder(ret);
            sb.insert(0, '\'');
            sb.append('\'');
            ret = sb.toString();
        }
        return ret;
    }

    public void writeFontSizeAttribute(int size) throws IOException, Exception {
        this.writeAttribute(ATTR_FONT_SIZE, SVGWriter.getFontSize(size));
    }

    protected static String getFontSize(int size) {
        return Integer.toString(size) + "px";
    }

    public void writeFontStyleAttribute(int style) throws IOException, Exception {
        String s = SVGWriter.getFontStyle(style);
        if (s != null) {
            this.writeAttribute(ATTR_FONT_STYLE, s);
        }
    }

    protected static String getFontStyle(int style) {
        if ((style & 2) == 2) {
            return "italic";
        }
        return null;
    }

    public void writeFontWeightAttribute(int style) throws IOException, Exception {
        String w = SVGWriter.getFontWeight(style);
        if (w != null) {
            this.writeAttribute(ATTR_FONT_WEIGHT, w);
        }
    }

    public void writeTextDecorationAttribute(Font font) throws IOException, Exception {
        String d = SVGWriter.getTextDecoration(font);
        if (d != null) {
            this.writeAttribute(ATTR_TEXT_DECORATION, d);
        }
    }

    protected static String getFontWeight(int style) {
        if ((style & 1) == 1) {
            return "bold";
        }
        return null;
    }

    protected static String getTextDecoration(Font font) {
        Map<TextAttribute, ?> fontAttributeMap = font.getAttributes();
        Integer value = (Integer)fontAttributeMap.get(TextAttribute.UNDERLINE);
        if (value != null && value == TextAttribute.UNDERLINE_ON) {
            return "underline";
        }
        return null;
    }

    @Override
    public void writeAttribute(String name, Color color) throws IOException, Exception {
        boolean bFill = name.equals(ATTR_FILL);
        boolean bStroke = name.equals(ATTR_STROKE);
        if (bFill || bStroke) {
            if (color == null) {
                this.writeAttribute(name, "none");
                return;
            }
            int alpha = color.getAlpha();
            if (alpha < 255) {
                double opacity = (double)alpha / 255.0;
                if (opacity < 0.0) {
                    opacity = 0.0;
                } else if (opacity > 255.0) {
                    opacity = 255.0;
                }
                if (bFill) {
                    this.writeAttribute(ATTR_FILL_OPACITY, opacity);
                } else if (bStroke) {
                    this.writeAttribute(ATTR_STROKE_OPACITY, opacity);
                }
            }
        }
        super.writeAttribute(name, color);
    }

    public boolean writeTooltip(String[] tooltipsArray) throws IOException, Exception {
        return this.writeTooltip(tooltipsArray, null, null);
    }

    public boolean writeTooltip(String[] tooltipsArray, String onMouseOverJS, String onMouseOutJS) throws IOException, Exception {
        String tooltips = SVGWriter.concatTooltipText(tooltipsArray);
        if (tooltips != null && tooltips.length() > 0) {
            String preJs = "var beanName = \"" + this.getFilteredBeanName() + "\";";
            String js = preJs + "bi_showSVGTitleTooltip(evt, beanName);";
            if (onMouseOverJS != null && onMouseOverJS.length() > 0) {
                js = onMouseOverJS + js;
            }
            this.writeAttribute(ATTR_ONMOUSEOVER, js);
            js = preJs + "bi_hideSVGTooltip(beanName);";
            if (onMouseOutJS != null && onMouseOutJS.length() > 0) {
                js = onMouseOutJS + js;
            }
            this.writeAttribute(ATTR_ONMOUSEOUT, js);
            this.writeTitleElement(tooltips);
            return true;
        }
        if (onMouseOverJS != null && onMouseOverJS.length() > 0) {
            this.writeAttribute(ATTR_ONMOUSEOVER, onMouseOverJS);
        }
        if (onMouseOutJS != null && onMouseOutJS.length() > 0) {
            this.writeAttribute(ATTR_ONMOUSEOUT, onMouseOutJS);
        }
        return false;
    }

    protected static String concatTooltipText(String[] tooltips) {
        if (tooltips == null || tooltips.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tooltips.length; ++i) {
            if (tooltips[i] == null || tooltips[i].length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(TOOLTIP_LINE_DELIMITER);
            }
            sb.append(tooltips[i]);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void writeTooltipsScript() throws IOException, Exception {
        if (this.m_bTooltipsScriptWritten) {
            return;
        }
        this.writeCommonScript();
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_tooltips");
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_showSVGTooltip(evt, lines, bAutoHide, beanName)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var tooltipGroup = document.getElementById(beanName+\"_biTooltipGroup\");");
        this.println("    if (tooltipGroup != null)");
        this.println("      bi_removeTextElems(tooltipGroup);");
        this.println("    else");
        this.println("      tooltipGroup = bi_createTooltipGroupElem(svgRoot, beanName);");
        this.println("    if (tooltipGroup != null)");
        this.println("    {");
        this.println("      var tooltipRect = document.getElementById(beanName+\"_biTooltipRect\");");
        this.println("      if (tooltipRect != null)");
        this.println("      {");
        this.println("        if (lines == null || lines.length == 0)");
        this.println("          return;");
        this.println("        var tooltips = new Array(lines.length);");
        this.println("        var textLength = 0;");
        this.println("        for (var i = 0; i < lines.length; i++)");
        this.println("        {");
        this.println("          tooltips[i] = bi_createTooltipTextElem(tooltipGroup, lines[i]);");
        this.println("          var tmpLength = 0;");
        this.println("          if (lines[i].length > 0)");
        this.println("            tmpLength = tooltips[i].getComputedTextLength();");
        this.println("          if (tmpLength > textLength)");
        this.println("            textLength = tmpLength;");
        this.println("        }");
        this.println("        var fontSize = parseInt(tooltips[0].getAttributeNS(null, \"font-size\"));");
        this.println("        var lineHeight = fontSize + 2;");
        this.println("        var textXOffset = 3;");
        this.println("        var textYOffset = 3;");
        this.println("        var bboxWidth = textLength + ( 2 * textXOffset);");
        this.println("        var bboxHeight = (lineHeight * lines.length) + ( 2 * textYOffset);");
        this.println("        var tooltipX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("        var tooltipY = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot) - bboxHeight - fontSize, evt.target);");
        this.println("        var boundsWidth = parseInt(svgRoot.getAttributeNS(null, \"width\"));");
        this.println("        var boundsHeight = parseInt(svgRoot.getAttributeNS(null, \"height\"));");
        this.println("        if ((tooltipX + bboxWidth + 1) > boundsWidth)");
        this.println("          tooltipX = boundsWidth - bboxWidth - 1;");
        this.println("        if (tooltipY < 0)");
        this.println("          tooltipY = 0;");
        this.println("        tooltipRect.setAttributeNS(null, \"x\", 0);");
        this.println("        tooltipRect.setAttributeNS(null, \"y\", 0);");
        this.println("        tooltipRect.setAttributeNS(null, \"width\", bboxWidth);");
        this.println("        tooltipRect.setAttributeNS(null, \"height\", bboxHeight);");
        this.println("        for (var i = 0; i < tooltips.length; i++)");
        this.println("        {");
        this.println("          tooltips[i].setAttributeNS(null, \"x\", textXOffset);");
        this.println("          tooltips[i].setAttributeNS(null, \"y\", (i + 1) * lineHeight);");
        this.println("        }");
        this.println("        tooltipGroup.setAttributeNS(null, \"transform\", ");
        this.println("          \"translate(\" +  tooltipX + \",\" + tooltipY + \")\"");
        this.println("          + \" scale(\" + (1 / svgRoot.currentScale) + \")\");");
        this.println("        tooltipGroup.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("        if (bAutoHide)");
        this.println("          window.bi_SVGTooltipHideTimer = setTimeout(\"var beanName = \\\"\" +beanName+ \"\\\"; bi_hideSVGTooltip(beanName);\", 5000);");
        this.println("      }");
        this.println("    }");
        this.println("}");
        this.println("function bi_showSVGTitleTooltip(evt, beanName)");
        this.println("{");
        this.println("  var obj = evt.target;");
        this.println("  var titleElem = bi_getTitle(obj);");
        this.println("  if (titleElem != null)");
        this.println("  {");
        this.println("    var lines = bi_breakTooltipIntoLines(titleElem.firstChild.data);");
        this.println("    bi_showSVGTooltip(evt, lines, true, beanName);");
        this.println("  }");
        this.println("}");
        this.println();
        this.println("function bi_hideSVGTooltip(beanName)");
        this.println("{");
        this.println("  if (window.bi_SVGTooltipHideTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(window.bi_SVGTooltipHideTimer);");
        this.println("    window.bi_SVGTooltipHideTimer = null;");
        this.println("  }");
        this.println("  var tooltipGroup = document.getElementById(beanName+\"_biTooltipGroup\");");
        this.println("  if (tooltipGroup != null)");
        this.println("  {");
        this.println("    tooltipGroup.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("    bi_removeTextElems(tooltipGroup);");
        this.println("  }");
        this.println("}");
        this.println();
        this.println("function bi_createTooltipGroupElem(pnode, beanName)");
        this.println("{");
        this.println("  var groupElem = document.createElementNS(bi_svgNS, \"g\");");
        this.println("  groupElem.setAttributeNS(null, \"id\", beanName+\"_biTooltipGroup\");");
        this.println("  groupElem.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("  groupElem.setAttributeNS(null, \"pointer-events\", \"none\");");
        this.println("  var rectElem = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  rectElem.setAttributeNS(null, \"id\", beanName+\"_biTooltipRect\");");
        this.println("  rectElem.setAttributeNS(null, \"x\", \"0\");");
        this.println("  rectElem.setAttributeNS(null, \"y\", \"0\");");
        this.println("  rectElem.setAttributeNS(null, \"width\", \"0\");");
        this.println("  rectElem.setAttributeNS(null, \"height\", \"0\");");
        this.println("  rectElem.setAttributeNS(null, \"fill\", \"lightyellow\");");
        this.println("  rectElem.setAttributeNS(null, \"stroke\", \"black\");");
        this.println("  rectElem.setAttributeNS(null, \"visibility\", \"inherit\");");
        this.println("  rectElem.setAttributeNS(null, \"pointer-events\", \"inherit\");");
        this.println("  groupElem.appendChild(rectElem);");
        this.println("  pnode.appendChild(groupElem);");
        this.println("  return groupElem;");
        this.println("}");
        this.println();
        this.println("function bi_createTooltipTextElem(pnode, text)");
        this.println("{");
        this.println("  var textElem = document.createElementNS(bi_svgNS, \"text\");");
        this.println("  textElem.setAttributeNS(bi_xmlNS, \"xml:space\", \"preserve\");");
        this.println("  textElem.setAttributeNS(null, \"x\", 0);");
        this.println("  textElem.setAttributeNS(null, \"y\", 0);");
        this.println("  textElem.setAttributeNS(null, \"font-size\", 10);");
        this.println("  textElem.setAttributeNS(null, \"visibility\", \"inherit\");");
        this.println("  textElem.setAttributeNS(null, \"pointer-events\", \"inherit\");");
        this.println("  pnode.appendChild(textElem);");
        this.println("  textElem.appendChild(document.createTextNode(text));");
        this.println("  return textElem;");
        this.println("}");
        this.println();
        this.println("function bi_removeTextElems(pnode)");
        this.println("{");
        this.println("  var child = pnode.firstChild;");
        this.println("  while (child != null) ");
        this.println("  {");
        this.println("    var nextChild = child.nextSibling;");
        this.println("    if (child.nodeName == \"text\")");
        this.println("      pnode.removeChild(child);");
        this.println("    child = nextChild;");
        this.println("  }");
        this.println("}");
        this.println();
        this.println("function bi_breakTooltipIntoLines(text)");
        this.println("{");
        this.println("  var lines = null;");
        this.println("  if (text != null)");
        this.println("  {");
        this.println("    var newText = new String(text);");
        this.println("    lines = new Array();");
        this.println("    var index = newText.indexOf(\";; \");");
        this.println("    while (index > -1)");
        this.println("    {");
        this.println("      lines.push(newText.substring(0, index));");
        this.println("      newText = newText.substring(index + 3, newText.length);");
        this.println("      index = newText.indexOf(\";; \");");
        this.println("    }");
        this.println("    lines.push(newText);");
        this.println("  }");
        this.println("  return lines;");
        this.println("}");
        this.println();
        this.println("function bi_getTitle(elem)");
        this.println("{");
        this.println("  var children = elem.childNodes;");
        this.println("  for (var i = 0; i <children.length; i++)");
        this.println("  {");
        this.println("    if (children.item(i).nodeType == 1 && ");
        this.println("        children.item(i).nodeName == \"title\")");
        this.println("    {");
        this.println("      return children.item(i);");
        this.println("    }");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bTooltipsScriptWritten = true;
    }

    protected void writeCommonScript() throws IOException, Exception {
        if (this.m_bCommonScriptWritten) {
            return;
        }
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_common");
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("var bi_svgNS = \"http://www.w3.org/2000/svg\";");
        this.println("var bi_xmlNS = \"http://www.w3.org/XML/1998/namespace\";");
        this.println("var bi_bMouseDown = false;");
        this.println("var bi_mouseDownX = 0;");
        this.println("var bi_mouseDownY = 0;");
        this.println("function bi_undoPanZoomTransformX(x, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var newX = (x - svgRoot.currentTranslate.x) / svgRoot.currentScale;");
        this.println("  return newX;");
        this.println("}");
        this.println("function bi_undoPanZoomTransformY(y, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var newY = (y - svgRoot.currentTranslate.y) / svgRoot.currentScale;");
        this.println("  return newY;");
        this.println("}");
        this.println("function bi_getUserPoint(node, x, y)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pan = svgRoot.currentTranslate;");
        this.println("  var scale = svgRoot.currentScale;");
        this.println("  var CTM = bi_getTransformToElement(node);");
        this.println("  var iCTM = CTM.inverse();");
        this.println("  var point = svgRoot.createSVGPoint();");
        this.println("  point.x = (x - pan.x) / scale;");
        this.println("  point.y = (y - pan.y) / scale;");
        this.println("  return point.matrixTransform(iCTM);");
        this.println("}");
        this.println("function bi_getTransformToElement(node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var CTM = null;");
        this.println("  if (navigator.userAgent && (navigator.userAgent.toLowerCase().indexOf('mozilla') != -1))");
        this.println("  {");
        this.println("    try");
        this.println("    {");
        this.println("      CTM = node.getTransformToElement(svgRoot);");
        this.println("    }");
        this.println("    catch (e)");
        this.println("    {");
        this.println("      var prevNode = null;");
        this.println("      var currNode = node;");
        this.println("      while (prevNode != svgRoot)");
        this.println("      {");
        this.println("        if (currNode.getTransformToElement)");
        this.println("        {");
        this.println("          prevNode = currNode;");
        this.println("          currNode = currNode.parentNode;");
        this.println("        }");
        this.println("        else");
        this.println("        {");
        this.println("          CTM = bi_getTransformToElement(currNode.parentNode);");
        this.println("          var postMatrix = null;");
        this.println("          if (prevNode != null)");
        this.println("          {");
        this.println("            try {");
        this.println("              postMatrix = node.getTransformToElement(prevNode);");
        this.println("            } catch (e2) {}");
        this.println("          }");
        this.println("          if (postMatrix != null)");
        this.println("            CTM = CTM.multiply(postMatrix);");
        this.println("          break;");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("  else");
        this.println("  {");
        this.println("    CTM = node.getCTM();");
        this.println("    if (node != svgRoot)");
        this.println("    {");
        this.println("      while (((node = node.parentNode) != svgRoot) && (node.getCTM() != null))");
        this.println("      {");
        this.println("        CTM = node.getCTM().multiply(CTM);");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("  return CTM;");
        this.println("}");
        this.println("function bi_findSVGRoot(node)");
        this.println("{");
        this.println("  var svgRoot = document.documentElement;");
        this.println("  if (svgRoot.nodeName != 'svg' && svgRoot.nodeName != 'SVG')");
        this.println("  {");
        this.println("    while (node)");
        this.println("    {");
        this.println("      if (node.nodeName == 'svg' || node.nodeName == 'SVG')");
        this.println("      {");
        this.println("        svgRoot = node;");
        this.println("        break;");
        this.println("      }");
        this.println("      node = node.parentNode;");
        this.println("    }");
        this.println("  }");
        this.println("  return svgRoot;");
        this.println("}");
        this.println("function bi_findTopSVGRoot(node)");
        this.println("{");
        this.println("  var topSvgRoot = null;");
        this.println("  if (navigator.userAgent && (navigator.userAgent.toLowerCase().indexOf('mozilla') != -1))");
        this.println("  {");
        this.println("    while (node)");
        this.println("    {");
        this.println("      if (node.nodeName == 'svg' || node.nodeName == 'SVG')");
        this.println("        topSvgRoot = node;");
        this.println("      node = node.ownerSVGElement;");
        this.println("    }");
        this.println("  }");
        this.println("  else");
        this.println("  {");
        this.println("    topSvgRoot = bi_findSVGRoot(node);");
        this.println("  }");
        this.println("  return topSvgRoot;");
        this.println("}");
        this.println("function bi_getClientX(evt, svgRoot)");
        this.println("{");
        this.println("  var x = evt.clientX;");
        this.println("  if (navigator.userAgent && (navigator.userAgent.toLowerCase().indexOf('mozilla') != -1))");
        this.println("  {");
        this.println("    x = x + window.pageXOffset - bi_getElementPosition(svgRoot.parentNode).left;");
        this.println("  }");
        this.println("  return x;");
        this.println("}");
        this.println("function bi_getClientY(evt, svgRoot)");
        this.println("{");
        this.println("  var y = evt.clientY;");
        this.println("  if (navigator.userAgent && (navigator.userAgent.toLowerCase().indexOf('mozilla') != -1))");
        this.println("  {");
        this.println("    y = y + window.pageYOffset - bi_getElementPosition(svgRoot.parentNode).top;");
        this.println("  }");
        this.println("  return y;");
        this.println("}");
        this.println("function bi_getElementPosition(node)");
        this.println("{");
        this.println("  var offsetLeft = 0;");
        this.println("  var offsetTop = 0;");
        this.println("  while (node)");
        this.println("  {");
        this.println("    offsetLeft += node.offsetLeft;");
        this.println("    offsetTop += node.offsetTop;");
        this.println("    node = node.offsetParent;");
        this.println("  }");
        this.println("  if (navigator.userAgent && (navigator.userAgent.indexOf(\"Mac\") != -1) && (typeof document.body.leftMargin != \"undefined\"))");
        this.println("  {");
        this.println("    offsetLeft += document.body.leftMargin;");
        this.println("    offsetTop += document.body.topMargin;");
        this.println("  }");
        this.println("  return {left:offsetLeft, top:offsetTop};");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bCommonScriptWritten = true;
    }

    protected void writeCommonScrollbarScript() throws IOException, Exception {
        if (this.m_bCommonScrollbarScriptWritten) {
            return;
        }
        this.writeCommonScript();
        this.writeTooltipsScript();
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_common_scrollbar");
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("var bi_bBodyMouseDown = false;");
        this.println("var bi_scrollTimer = null;");
        this.println("var bi_scrMouseEvent = null;");
        this.println("function BIScrollbar(objName, beanName, base_id, clientCoord, clientSize, thumbCoord, thumbSize, count, index, span, labels, submitJS, bThumbResizable, bReverseDir)");
        this.println("{");
        this.println("  this.objName = objName;");
        this.println("  this.beanName = beanName;");
        this.println("  this.base_id = base_id;");
        this.println("  this.clientCoord = clientCoord;");
        this.println("  this.clientSize = clientSize;");
        this.println("  this.thumbCoord = thumbCoord;");
        this.println("  this.thumbSize = thumbSize;");
        this.println("  this.count = count;");
        this.println("  this.index = index;");
        this.println("  this.span = span;");
        this.println("  this.labels = labels;");
        this.println("  this.submitJS = submitJS;");
        this.println("  this.bThumbResizable = bThumbResizable;");
        this.println("  this.bReverseDir = bReverseDir;");
        this.println("}");
        this.println("function BIScrollMouseEvent(evt)");
        this.println("{");
        this.println("  this.clientX = evt.clientX;");
        this.println("  this.clientY = evt.clientY;");
        this.println("  this.target = evt.target;");
        this.println("}");
        this.println("function bi_mapScrCoordToIndex(coord, scrObj)");
        this.println("{");
        this.println("  var unitSize = scrObj.clientSize / scrObj.count;");
        this.println("  var ratio = (coord - scrObj.clientCoord) / unitSize;");
        this.println("  var index = Math.round(ratio);");
        this.println("  if (index < 0)");
        this.println("    index = 0;");
        this.println("  if (index >= scrObj.count)");
        this.println("    index = index - 1;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    index = scrObj.count - 1 - index;");
        this.println("  return index;");
        this.println("}");
        this.println("function bi_mapScrSizeToCount(size, scrObj)");
        this.println("{");
        this.println("  var unitSize = scrObj.clientSize / scrObj.count;");
        this.println("  var ratio = scrObj.thumbSize / unitSize;");
        this.println("  var count = Math.round(ratio);");
        this.println("  if (count < 1)");
        this.println("    count = 1;");
        this.println("  if (count > scrObj.count)");
        this.println("    count = scrObj.count;");
        this.println("  return count;");
        this.println("}");
        this.println("function bi_scr_validate_th_coord(coord, scrObj)");
        this.println("{");
        this.println("  var min = scrObj.clientCoord;");
        this.println("  var max = min + scrObj.clientSize - scrObj.thumbSize;");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.println("function bi_mapMaxThAScrCoordToIndex(coord, scrObj)");
        this.println("{");
        this.println("  var unitSize = scrObj.clientSize / scrObj.count;");
        this.println("  var ratio = (coord - scrObj.clientCoord) / unitSize;");
        this.println("  var index = Math.round(ratio) - 1;");
        this.println("  if (index < 0)");
        this.println("    index = 0;");
        this.println("  if (index >= scrObj.count)");
        this.println("    index = index - 1;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    index = scrObj.count - 1 - index;");
        this.println("  return index;");
        this.println("}");
        this.println("function bi_scr_validate_th_minEdge(coord, scrObj)");
        this.println("{");
        this.println("  var min = scrObj.clientCoord;");
        this.println("  var max = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.println("function bi_scr_validate_th_maxEdge(coord, scrObj)");
        this.println("{");
        this.println("  var min = scrObj.thumbCoord;");
        this.println("  var max = scrObj.clientCoord + scrObj.clientSize;");
        this.println("  var newCoord = coord;");
        this.println("  if (newCoord < min)");
        this.println("    newCoord = min;");
        this.println("  if (newCoord > max)");
        this.println("    newCoord = max;");
        this.println("  return newCoord;");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bCommonScrollbarScriptWritten = true;
    }

    protected void writeScrollbarObjectScript(String objName, String beanName, String base_id, int clientCoord, int clientSize, int thumbCoord, int thumbSize, int count, int index, int span, String[] labels, String submitJS, boolean bThumbResizable, boolean bReverseDir) throws IOException, Exception {
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_scrollbar_object_" + base_id);
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        StringBuilder sb = new StringBuilder();
        sb.append("var ");
        sb.append(objName);
        sb.append(" = new BIScrollbar(\"");
        sb.append(objName);
        sb.append("\", \"");
        sb.append(beanName);
        sb.append("\", \"");
        sb.append(base_id);
        sb.append("\", ");
        sb.append(clientCoord);
        sb.append(", ");
        sb.append(clientSize);
        sb.append(", ");
        sb.append(thumbCoord);
        sb.append(", ");
        sb.append(thumbSize);
        sb.append(", ");
        sb.append(count);
        sb.append(", ");
        sb.append(index);
        sb.append(", ");
        sb.append(span);
        sb.append(", ");
        if (labels.length > 0) {
            sb.append("new Array(");
            for (int i = 0; i < labels.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"");
                sb.append(labels[i]);
                sb.append("\"");
            }
            sb.append(")");
        } else {
            sb.append("null");
        }
        sb.append(", \"");
        sb.append(submitJS);
        sb.append("\", ");
        sb.append(bThumbResizable);
        sb.append(", ");
        sb.append(bReverseDir);
        sb.append(");");
        this.println(sb.toString());
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected void writeHorizontalScrollbar(int x, int y, int width, int height, double pctThumbSize, double pctThumbOffset, String base_id, int count, int index, int span, String[] labels, String submitJS, boolean bThumbResizable, boolean bReverseDir, String group_id, String beanName) throws IOException, Exception {
        this.writeHorizontalScrollbarScript();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ID, group_id);
        String objName = base_id + "Obj";
        int arrowWidth = height;
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_FILL, "lightgray");
        this.writeAttribute(ATTR_STROKE, Color.black);
        int clientX = x + arrowWidth;
        int clientWidth = width - 2 * arrowWidth;
        this.startRectElement(clientX, y, clientWidth, height);
        this.writeAttribute(ATTR_ID, base_id + "_body");
        this.writeAttribute(ATTR_FILL, Color.white);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_body_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_hscr_body_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_hscr_body_mUp(evt, " + objName + ");");
        this.endElement();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_la_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_hscr_la_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_hscr_la_mUp(evt, " + objName + ");");
        this.startRectElement(x, y, arrowWidth, height);
        this.writeAttribute(ATTR_ID, base_id + "_la_rect");
        this.endElement();
        this.startElement(ELEM_POLYLINE);
        int oneThird = arrowWidth / 3;
        int top = y + oneThird;
        int middle = y + height / 2;
        int bottom = y + height - oneThird;
        int left = x + oneThird;
        int right = x + arrowWidth - oneThird;
        StringBuilder sb = new StringBuilder();
        sb.append(right);
        sb.append(",");
        sb.append(top);
        sb.append(" ");
        sb.append(left);
        sb.append(",");
        sb.append(middle);
        sb.append(" ");
        sb.append(right);
        sb.append(",");
        sb.append(bottom);
        this.writeAttribute(ATTR_POINTS, sb.toString());
        this.writeAttribute(ATTR_POINTER_EVENTS, "none");
        this.endElement();
        this.endElement();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_ra_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_hscr_ra_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_hscr_ra_mUp(evt, " + objName + ");");
        this.startRectElement(x + width - arrowWidth, y, arrowWidth, height);
        this.writeAttribute(ATTR_ID, base_id + "_ra_rect");
        this.endElement();
        this.startElement(ELEM_POLYLINE);
        top = y + oneThird;
        middle = y + height / 2;
        bottom = y + height - oneThird;
        left = x + width - arrowWidth + oneThird;
        right = x + width - oneThird;
        sb = new StringBuilder();
        sb.append(left);
        sb.append(",");
        sb.append(top);
        sb.append(" ");
        sb.append(right);
        sb.append(",");
        sb.append(middle);
        sb.append(" ");
        sb.append(left);
        sb.append(",");
        sb.append(bottom);
        this.writeAttribute(ATTR_POINTS, sb.toString());
        this.writeAttribute(ATTR_POINTER_EVENTS, "none");
        this.endElement();
        this.endElement();
        int thumbWidth = (int)(pctThumbSize * (double)clientWidth);
        int thumbOffset = (int)(pctThumbOffset * (double)clientWidth);
        int thumbCoord = x + arrowWidth + thumbOffset;
        if (bReverseDir) {
            thumbCoord = x + width - arrowWidth - thumbOffset - thumbWidth;
        }
        this.startRectElement(thumbCoord, y, thumbWidth, height);
        this.writeAttribute(ATTR_ID, base_id + "_th");
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_th_mDown(evt, " + objName + ");");
        this.endElement();
        if (bThumbResizable) {
            this.startElement(ELEM_G);
            this.writeAttribute(ATTR_ID, base_id + "_ltha");
            this.startRectElement(thumbCoord, y, arrowWidth - 2 * oneThird, height);
            this.writeAttribute(ATTR_ID, base_id + "_ltha_rect");
            this.writeAttribute(ATTR_FILL, "none");
            this.writeAttribute(ATTR_STROKE, "none");
            this.writeAttribute(ATTR_POINTER_EVENTS, "visible");
            this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_ltha_mDown(evt, " + objName + ");");
            this.endElement();
            this.startElement(ELEM_POLYGON);
            top = y + oneThird;
            middle = y + height / 2;
            bottom = y + height - oneThird;
            left = thumbCoord;
            right = thumbCoord + arrowWidth - 2 * oneThird;
            sb = new StringBuilder();
            sb.append(left);
            sb.append(",");
            sb.append(top);
            sb.append(" ");
            sb.append(right);
            sb.append(",");
            sb.append(middle);
            sb.append(" ");
            sb.append(left);
            sb.append(",");
            sb.append(bottom);
            this.writeAttribute(ATTR_POINTS, sb.toString());
            this.writeAttribute(ATTR_FILL, Color.black);
            this.writeAttribute(ATTR_POINTER_EVENTS, "none");
            this.endElement();
            this.endElement();
            this.startElement(ELEM_G);
            this.writeAttribute(ATTR_ID, base_id + "_rtha");
            this.startRectElement(thumbCoord + thumbWidth - arrowWidth + 2 * oneThird, y, arrowWidth - 2 * oneThird, height);
            this.writeAttribute(ATTR_ID, base_id + "_rtha_rect");
            this.writeAttribute(ATTR_FILL, "none");
            this.writeAttribute(ATTR_STROKE, "none");
            this.writeAttribute(ATTR_POINTER_EVENTS, "visible");
            this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_hscr_rtha_mDown(evt, " + objName + ");");
            this.endElement();
            this.startElement(ELEM_POLYGON);
            top = y + oneThird;
            middle = y + height / 2;
            bottom = y + height - oneThird;
            left = thumbCoord + thumbWidth - arrowWidth + 2 * oneThird;
            right = thumbCoord + thumbWidth;
            sb = new StringBuilder();
            sb.append(right);
            sb.append(",");
            sb.append(top);
            sb.append(" ");
            sb.append(left);
            sb.append(",");
            sb.append(middle);
            sb.append(" ");
            sb.append(right);
            sb.append(",");
            sb.append(bottom);
            this.writeAttribute(ATTR_POINTS, sb.toString());
            this.writeAttribute(ATTR_FILL, Color.black);
            this.writeAttribute(ATTR_POINTER_EVENTS, "none");
            this.endElement();
            this.endElement();
        }
        this.endElement();
        this.writeScrollbarObjectScript(objName, beanName, base_id, clientX, clientWidth, thumbCoord, thumbWidth, count, index, span, labels, submitJS, bThumbResizable, bReverseDir);
        this.endElement();
    }

    protected void writeHorizontalScrollbarScript() throws IOException, Exception {
        if (this.m_bHScrollScriptWritten) {
            return;
        }
        this.writeCommonScrollbarScript();
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_horiz_scrollbar");
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_hscr_th_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_hscr_createThPane(scrObj, evt.target)");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  thumbElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_th_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_hscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("      thumbElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_th_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currX = scrObj.thumbCoord;");
        this.println("    var newX = bi_scr_validate_th_coord(currX + offsetX, scrObj);");
        this.println("    thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("    if (scrObj.bThumbResizable)");
        this.println("      bi_hscr_translateThResizeArrows(newX, scrObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    scrObj.thumbCoord = newX;");
        this.println("    var coord = scrObj.thumbCoord;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("    scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("    var bAutoHide = false;");
        this.println("    var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_la_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var laElem = document.getElementById(scrObj.base_id + \"_la_rect\");");
        this.println("  laElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_hscr_scrLUnitLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_hscr_la_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    var laElem = document.getElementById(scrObj.base_id + \"_la_rect\");");
        this.println("    laElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_ra_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var raElem = document.getElementById(scrObj.base_id + \"_ra_rect\");");
        this.println("  raElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_hscr_scrRUnitLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_hscr_ra_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    var raElem = document.getElementById(scrObj.base_id + \"_ra_rect\");");
        this.println("    raElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_body_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bBodyMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_getUserPoint(evt.target, bi_getClientX(evt, svgRoot), bi_getClientY(evt, svgRoot)).x;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  var thumbX = scrObj.thumbCoord;");
        this.println("  var thumbWidth = scrObj.thumbSize;");
        this.println("  var x = bi_mouseDownX;");
        this.println("  if (x < thumbX)");
        this.println("    bi_hscr_scrLBlockLoop(evt, scrObj);");
        this.println("  else if (x > (thumbX + thumbWidth))");
        this.println("    bi_hscr_scrRBlockLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_hscr_body_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("  {");
        this.println("    bi_bBodyMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_scrRUnit(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currX = scrObj.thumbCoord;");
        this.println("  var newX = bi_scr_validate_th_coord(currX + 2, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_hscr_translateThResizeArrows(newX, scrObj);");
        this.println("  scrObj.thumbCoord = newX;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_scrRBlock(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currX = scrObj.thumbCoord;");
        this.println("  var newX = bi_scr_validate_th_coord(currX + 6, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_hscr_translateThResizeArrows(newX, scrObj);");
        this.println("  scrObj.thumbCoord = newX;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_scrLUnit(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currX = scrObj.thumbCoord;");
        this.println("  var newX = bi_scr_validate_th_coord(currX - 2, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_hscr_translateThResizeArrows(newX, scrObj);");
        this.println("  scrObj.thumbCoord = newX;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_scrLBlock(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currX = scrObj.thumbCoord;");
        this.println("  var newX = bi_scr_validate_th_coord(currX - 6, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_hscr_translateThResizeArrows(newX, scrObj);");
        this.println("  scrObj.thumbCoord = newX;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_scrRUnitLoop(evt, scrObj)");
        this.println("{");
        this.println("  bi_hscr_scrRUnit(evt, scrObj);");
        this.println("  bi_scrollTimer = window.setTimeout(\"bi_hscr_scrRUnitLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("}");
        this.println("function bi_hscr_scrRBlockLoop(evt, scrObj)");
        this.println("{");
        this.println("  var thumbX = scrObj.thumbCoord;");
        this.println("  var thumbWidth = scrObj.thumbSize;");
        this.println("  if (bi_mouseDownX > (thumbX + (thumbWidth / 2)))");
        this.println("  {");
        this.println("    bi_hscr_scrRBlock(evt, scrObj);");
        this.println("    bi_scrollTimer = window.setTimeout(\"bi_hscr_scrRBlockLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_scrLUnitLoop(evt, scrObj)");
        this.println("{");
        this.println("  bi_hscr_scrLUnit(evt, scrObj);");
        this.println("  bi_scrollTimer = window.setTimeout(\"bi_hscr_scrLUnitLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("}");
        this.println("function bi_hscr_scrLBlockLoop(evt, scrObj)");
        this.println("{");
        this.println("  var thumbX = scrObj.thumbCoord;");
        this.println("  var thumbWidth = scrObj.thumbSize;");
        this.println("  if (bi_mouseDownX < (thumbX + (thumbWidth / 2)))");
        this.println("  {");
        this.println("    bi_hscr_scrLBlock(evt, scrObj);");
        this.println("    bi_scrollTimer = window.setTimeout(\"bi_hscr_scrLBlockLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_translateThResizeArrows(newX, scrObj)");
        this.println("{");
        this.println("  var lthaElem = document.getElementById(scrObj.base_id + \"_ltha\");");
        this.println("  var rthaElem = document.getElementById(scrObj.base_id + \"_rtha\");");
        this.println("  var sTranslate = lthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetX = newX - scrObj.thumbCoord;");
        this.println("  var xTranslate = bi_hscr_parseTranslateX(sTranslate);");
        this.println("  if (xTranslate != null)");
        this.println("    offsetX = offsetX + xTranslate;");
        this.println("  sTranslate = \"translate(\" + offsetX + \")\";");
        this.println("  lthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("  rthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_hscr_translateLThResizeArrow(newX, scrObj)");
        this.println("{");
        this.println("  var lthaElem = document.getElementById(scrObj.base_id + \"_ltha\");");
        this.println("  var sTranslate = lthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetX = newX - scrObj.thumbCoord;");
        this.println("  var xTranslate = bi_hscr_parseTranslateX(sTranslate);");
        this.println("  if (xTranslate != null)");
        this.println("    offsetX = offsetX + xTranslate;");
        this.println("  sTranslate = \"translate(\" + offsetX + \")\";");
        this.println("  lthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_hscr_translateRThResizeArrow(newX, scrObj)");
        this.println("{");
        this.println("  var rthaElem = document.getElementById(scrObj.base_id + \"_rtha\");");
        this.println("  var sTranslate = rthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetX = newX - (scrObj.thumbCoord + scrObj.thumbSize);");
        this.println("  var xTranslate = bi_hscr_parseTranslateX(sTranslate);");
        this.println("  if (xTranslate != null)");
        this.println("    offsetX = offsetX + xTranslate;");
        this.println("  sTranslate = \"translate(\" + offsetX + \")\";");
        this.println("  rthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_hscr_parseTranslateX(translate)");
        this.println("{");
        this.println("  if (translate != null)");
        this.println("  {");
        this.println("    var op = translate.indexOf('(');");
        this.println("    var comma = translate.indexOf(',');");
        this.println("    var cp = translate.indexOf(')');");
        this.println("    var xString = null;");
        this.println("    if (comma < 0)");
        this.println("      xString = translate.substring(op+1, cp);");
        this.println("    else");
        this.println("      xString = translate.substring(op+1, comma);");
        this.println("    return eval(xString);");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.println("function bi_hscr_ltha_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_hscr_createLThAPane(scrObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_ltha_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_hscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_ltha_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currX = scrObj.thumbCoord;");
        this.println("    var newX = bi_scr_validate_th_minEdge(currX + offsetX, scrObj);");
        this.println("    var newWidth = scrObj.thumbSize + (currX - newX);");
        this.println("    thumbElem.setAttributeNS(null, \"x\", newX);");
        this.println("    thumbElem.setAttributeNS(null, \"width\", newWidth);");
        this.println("    bi_hscr_translateLThResizeArrow(newX, scrObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    scrObj.thumbCoord = newX;");
        this.println("    scrObj.thumbSize = newWidth;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("    var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("    if (scrObj.bReverseDir)");
        this.println("    {");
        this.println("      var tmpI = maxIndex;");
        this.println("      maxIndex = minIndex;");
        this.println("      minIndex = tmpI;");
        this.println("    }");
        this.println("    if (minIndex > maxIndex)");
        this.println("      minIndex = minIndex - 1;");
        this.println("    if (!scrObj.bReverseDir)");
        this.println("      scrObj.index = minIndex;");
        this.println("    scrObj.span = maxIndex - minIndex + 1;");
        this.println("    var labelIndex = minIndex;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      labelIndex = maxIndex;");
        this.println("    var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_rtha_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownX = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("  bi_hscr_createRThAPane(scrObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("  var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("  if (scrObj.bReverseDir)");
        this.println("  {");
        this.println("    var tmpI = maxIndex;");
        this.println("    maxIndex = minIndex;");
        this.println("    minIndex = tmpI;");
        this.println("  }");
        this.println("  if (maxIndex < minIndex)");
        this.println("    maxIndex = maxIndex + 1;");
        this.println("  var labelIndex = maxIndex;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    labelIndex = minIndex;");
        this.println("  var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_hscr_rtha_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_hscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_rtha_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var x = bi_undoPanZoomTransformX(bi_getClientX(evt, svgRoot), evt.target);");
        this.println("    var offsetX = x - bi_mouseDownX;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currX = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("    var newX = bi_scr_validate_th_maxEdge(currX + offsetX, scrObj);");
        this.println("    var newWidth = scrObj.thumbSize + (newX - currX);");
        this.println("    thumbElem.setAttributeNS(null, \"width\", newWidth);");
        this.println("    bi_hscr_translateRThResizeArrow(newX, scrObj);");
        this.println("    bi_mouseDownX = x;");
        this.println("    scrObj.thumbSize = newWidth;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("    var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("    if (scrObj.bReverseDir)");
        this.println("    {");
        this.println("      var tmpI = maxIndex;");
        this.println("      maxIndex = minIndex;");
        this.println("      minIndex = tmpI;");
        this.println("    }");
        this.println("    if (maxIndex < minIndex)");
        this.println("      maxIndex = maxIndex + 1;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      scrObj.index = minIndex;");
        this.println("    scrObj.span = maxIndex - minIndex + 1;");
        this.println("    var labelIndex = maxIndex;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      labelIndex = minIndex;");
        this.println("    var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_hscr_createLThAPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_hscr_ltha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_hscr_ltha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_hscr_ltha_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_hscr_createRThAPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_hscr_rtha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_hscr_rtha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_hscr_rtha_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_hscr_createThPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_hscr_th_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_hscr_th_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_hscr_th_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bHScrollScriptWritten = true;
    }

    protected void writeVerticalScrollbar(int x, int y, int width, int height, double pctThumbSize, double pctThumbOffset, String base_id, int count, int index, int span, String[] labels, String submitJS, boolean bThumbResizable, boolean bReverseDir, String group_id, String beanName) throws IOException, Exception {
        this.writeVerticalScrollbarScript();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ID, group_id);
        String objName = base_id + "Obj";
        int arrowHeight = width;
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_FILL, "lightgray");
        this.writeAttribute(ATTR_STROKE, Color.black);
        int clientY = y + arrowHeight;
        int clientHeight = height - 2 * arrowHeight;
        this.startRectElement(x, clientY, width, clientHeight);
        this.writeAttribute(ATTR_ID, base_id + "_body");
        this.writeAttribute(ATTR_FILL, Color.white);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_body_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_vscr_body_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_vscr_body_mUp(evt, " + objName + ");");
        this.endElement();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_ua_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_vscr_ua_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_vscr_ua_mUp(evt, " + objName + ");");
        this.startRectElement(x, y, width, arrowHeight);
        this.writeAttribute(ATTR_ID, base_id + "_ua_rect");
        this.endElement();
        this.startElement(ELEM_POLYLINE);
        int oneThird = arrowHeight / 3;
        int top = y + oneThird;
        int bottom = y + arrowHeight - oneThird;
        int left = x + oneThird;
        int center = x + width / 2;
        int right = x + width - oneThird;
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(",");
        sb.append(bottom);
        sb.append(" ");
        sb.append(center);
        sb.append(",");
        sb.append(top);
        sb.append(" ");
        sb.append(right);
        sb.append(",");
        sb.append(bottom);
        this.writeAttribute(ATTR_POINTS, sb.toString());
        this.writeAttribute(ATTR_POINTER_EVENTS, "none");
        this.endElement();
        this.endElement();
        this.startElement(ELEM_G);
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_da_mDown(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEUP, "bi_vscr_da_mUp(evt, " + objName + ");");
        this.writeAttribute(ATTR_ONMOUSEOUT, "bi_vscr_da_mUp(evt, " + objName + ");");
        this.startRectElement(x, y + height - arrowHeight, width, arrowHeight);
        this.writeAttribute(ATTR_ID, base_id + "_da_rect");
        this.endElement();
        this.startElement(ELEM_POLYLINE);
        top = y + height - arrowHeight + oneThird;
        bottom = y + height - oneThird;
        left = x + oneThird;
        center = x + width / 2;
        right = x + width - oneThird;
        sb = new StringBuilder();
        sb.append(left);
        sb.append(",");
        sb.append(top);
        sb.append(" ");
        sb.append(center);
        sb.append(",");
        sb.append(bottom);
        sb.append(" ");
        sb.append(right);
        sb.append(",");
        sb.append(top);
        this.writeAttribute(ATTR_POINTS, sb.toString());
        this.writeAttribute(ATTR_POINTER_EVENTS, "none");
        this.endElement();
        this.endElement();
        int thumbHeight = (int)(pctThumbSize * (double)clientHeight);
        int thumbOffset = (int)(pctThumbOffset * (double)clientHeight);
        int thumbCoord = y + arrowHeight + thumbOffset;
        if (bReverseDir) {
            thumbCoord = y + height - arrowHeight - thumbOffset - thumbHeight;
        }
        this.startRectElement(x, thumbCoord, width, thumbHeight);
        this.writeAttribute(ATTR_ID, base_id + "_th");
        this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_th_mDown(evt, " + objName + ");");
        this.endElement();
        if (bThumbResizable) {
            this.startElement(ELEM_G);
            this.writeAttribute(ATTR_ID, base_id + "_utha");
            this.startRectElement(x, thumbCoord, width, arrowHeight - 2 * oneThird);
            this.writeAttribute(ATTR_ID, base_id + "_utha_rect");
            this.writeAttribute(ATTR_FILL, "none");
            this.writeAttribute(ATTR_STROKE, "none");
            this.writeAttribute(ATTR_POINTER_EVENTS, "visible");
            this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_utha_mDown(evt, " + objName + ");");
            this.endElement();
            this.startElement(ELEM_POLYGON);
            top = thumbCoord;
            bottom = thumbCoord + arrowHeight - 2 * oneThird;
            left = x + oneThird;
            center = x + width / 2;
            right = x + width - oneThird;
            sb = new StringBuilder();
            sb.append(left);
            sb.append(",");
            sb.append(top);
            sb.append(" ");
            sb.append(center);
            sb.append(",");
            sb.append(bottom);
            sb.append(" ");
            sb.append(right);
            sb.append(",");
            sb.append(top);
            this.writeAttribute(ATTR_POINTS, sb.toString());
            this.writeAttribute(ATTR_FILL, Color.black);
            this.writeAttribute(ATTR_POINTER_EVENTS, "none");
            this.endElement();
            this.endElement();
            this.startElement(ELEM_G);
            this.writeAttribute(ATTR_ID, base_id + "_dtha");
            this.startRectElement(x, thumbCoord + thumbHeight - arrowHeight + 2 * oneThird, width, arrowHeight - 2 * oneThird);
            this.writeAttribute(ATTR_ID, base_id + "_dtha_rect");
            this.writeAttribute(ATTR_FILL, "none");
            this.writeAttribute(ATTR_STROKE, "none");
            this.writeAttribute(ATTR_POINTER_EVENTS, "visible");
            this.writeAttribute(ATTR_ONMOUSEDOWN, "bi_vscr_dtha_mDown(evt, " + objName + ");");
            this.endElement();
            this.startElement(ELEM_POLYGON);
            top = thumbCoord + thumbHeight - arrowHeight + 2 * oneThird;
            bottom = thumbCoord + thumbHeight;
            left = x + oneThird;
            center = x + width / 2;
            right = x + width - oneThird;
            sb = new StringBuilder();
            sb.append(left);
            sb.append(",");
            sb.append(bottom);
            sb.append(" ");
            sb.append(center);
            sb.append(",");
            sb.append(top);
            sb.append(" ");
            sb.append(right);
            sb.append(",");
            sb.append(bottom);
            this.writeAttribute(ATTR_POINTS, sb.toString());
            this.writeAttribute(ATTR_FILL, Color.black);
            this.writeAttribute(ATTR_POINTER_EVENTS, "none");
            this.endElement();
            this.endElement();
        }
        this.endElement();
        this.writeScrollbarObjectScript(objName, beanName, base_id, clientY, clientHeight, thumbCoord, thumbHeight, count, index, span, labels, submitJS, bThumbResizable, bReverseDir);
        this.endElement();
    }

    protected void writeVerticalScrollbarScript() throws IOException, Exception {
        if (this.m_bVScrollScriptWritten) {
            return;
        }
        this.writeCommonScrollbarScript();
        this.startElement(ELEM_DEFS);
        this.startElement(this.isEncodingScriptTag() ? ELEM_ENCSCRIPT : ELEM_SCRIPT);
        String scriptId = this.constructId("bi_vert_scrollbar");
        if (scriptId != null) {
            this.writeAttribute(ATTR_ID, scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_vscr_th_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownY = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("  bi_vscr_createThPane(scrObj, evt.target)");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  thumbElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_th_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_vscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("      thumbElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_th_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var y = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("    var offsetY = y - bi_mouseDownY;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currY = scrObj.thumbCoord;");
        this.println("    var newY = bi_scr_validate_th_coord(currY + offsetY, scrObj);");
        this.println("    thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("    if (scrObj.bThumbResizable)");
        this.println("      bi_vscr_translateThResizeArrows(newY, scrObj);");
        this.println("    bi_mouseDownY = y;");
        this.println("    scrObj.thumbCoord = newY;");
        this.println("    var coord = scrObj.thumbCoord;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("    scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("    var bAutoHide = false;");
        this.println("    var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_ua_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var uaElem = document.getElementById(scrObj.base_id + \"_ua_rect\");");
        this.println("  uaElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_vscr_scrUUnitLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_vscr_ua_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    var uaElem = document.getElementById(scrObj.base_id + \"_ua_rect\");");
        this.println("    uaElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_da_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var daElem = document.getElementById(scrObj.base_id + \"_da_rect\");");
        this.println("  daElem.setAttributeNS(null, \"fill\", \"darkgray\");");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  bi_vscr_scrDUnitLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_vscr_da_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    bi_bMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    var daElem = document.getElementById(scrObj.base_id + \"_da_rect\");");
        this.println("    daElem.setAttributeNS(null, \"fill\", \"lightgray\");");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_body_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bBodyMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownY = bi_getUserPoint(evt.target, bi_getClientX(evt, svgRoot), bi_getClientY(evt, svgRoot)).y;");
        this.println("  bi_scrMouseEvent = new BIScrollMouseEvent(evt);");
        this.println("  var bAutoHide = false;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(coord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  var thumbY = scrObj.thumbCoord;");
        this.println("  var thumbHeight = scrObj.thumbSize;");
        this.println("  var y = bi_mouseDownY;");
        this.println("  if (y < thumbY)");
        this.println("    bi_vscr_scrUBlockLoop(evt, scrObj);");
        this.println("  else if (y > (thumbY + thumbHeight))");
        this.println("    bi_vscr_scrDBlockLoop(evt, scrObj);");
        this.println("}");
        this.println("function bi_vscr_body_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_scrollTimer != null)");
        this.println("  {");
        this.println("    clearTimeout(bi_scrollTimer);");
        this.println("    bi_scrollTimer = null;");
        this.println("  }");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("  {");
        this.println("    bi_bBodyMouseDown = false;");
        this.println("    bi_scrMouseEvent = null;");
        this.println("    eval(scrObj.submitJS);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_scrDUnit(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currY = scrObj.thumbCoord;");
        this.println("  var newY = bi_scr_validate_th_coord(currY + 2, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_vscr_translateThResizeArrows(newY, scrObj);");
        this.println("  scrObj.thumbCoord = newY;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_scrDBlock(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currY = scrObj.thumbCoord;");
        this.println("  var newY = bi_scr_validate_th_coord(currY + 6, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_vscr_translateThResizeArrows(newY, scrObj);");
        this.println("  scrObj.thumbCoord = newY;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_scrUUnit(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currY = scrObj.thumbCoord;");
        this.println("  var newY = bi_scr_validate_th_coord(currY - 2, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_vscr_translateThResizeArrows(newY, scrObj);");
        this.println("  scrObj.thumbCoord = newY;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_scrUBlock(evt, scrObj)");
        this.println("{");
        this.println("  var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("  var currY = scrObj.thumbCoord;");
        this.println("  var newY = bi_scr_validate_th_coord(currY - 6, scrObj);");
        this.println("  thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("  if (scrObj.bThumbResizable)");
        this.println("    bi_vscr_translateThResizeArrows(newY, scrObj);");
        this.println("  scrObj.thumbCoord = newY;");
        this.println("  var coord = scrObj.thumbCoord;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    coord = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("  scrObj.index = bi_mapScrCoordToIndex(coord, scrObj);");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[scrObj.index]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_hideSVGTooltip(beanName);");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_scrDUnitLoop(evt, scrObj)");
        this.println("{");
        this.println("  bi_vscr_scrDUnit(evt, scrObj);");
        this.println("  bi_scrollTimer = window.setTimeout(\"bi_vscr_scrDUnitLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("}");
        this.println("function bi_vscr_scrDBlockLoop(evt, scrObj)");
        this.println("{");
        this.println("  var thumbY = scrObj.thumbCoord;");
        this.println("  var thumbHeight = scrObj.thumbSize;");
        this.println("  if (bi_mouseDownY > (thumbY + (thumbHeight / 2)))");
        this.println("  {");
        this.println("    bi_vscr_scrDBlock(evt, scrObj);");
        this.println("    bi_scrollTimer = window.setTimeout(\"bi_vscr_scrDBlockLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_scrUUnitLoop(evt, scrObj)");
        this.println("{");
        this.println("  bi_vscr_scrUUnit(evt, scrObj);");
        this.println("  bi_scrollTimer = window.setTimeout(\"bi_vscr_scrUUnitLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("}");
        this.println("function bi_vscr_scrUBlockLoop(evt, scrObj)");
        this.println("{");
        this.println("  var thumbY = scrObj.thumbCoord;");
        this.println("  var thumbHeight = scrObj.thumbSize;");
        this.println("  if (bi_mouseDownY < (thumbY + (thumbHeight / 2)))");
        this.println("  {");
        this.println("    bi_vscr_scrUBlock(evt, scrObj);");
        this.println("    bi_scrollTimer = window.setTimeout(\"bi_vscr_scrUBlockLoop(bi_scrMouseEvent, \" + scrObj.objName + \")\", 10);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_translateThResizeArrows(newY, scrObj)");
        this.println("{");
        this.println("  var uthaElem = document.getElementById(scrObj.base_id + \"_utha\");");
        this.println("  var dthaElem = document.getElementById(scrObj.base_id + \"_dtha\");");
        this.println("  var sTranslate = uthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetY = newY - scrObj.thumbCoord;");
        this.println("  var yTranslate = bi_vscr_parseTranslateY(sTranslate);");
        this.println("  if (yTranslate != null)");
        this.println("    offsetY = offsetY + yTranslate;");
        this.println("  sTranslate = \"translate(0, \" + offsetY + \")\";");
        this.println("  uthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("  dthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_vscr_translateUThResizeArrow(newY, scrObj)");
        this.println("{");
        this.println("  var uthaElem = document.getElementById(scrObj.base_id + \"_utha\");");
        this.println("  var sTranslate = uthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetY = newY - scrObj.thumbCoord;");
        this.println("  var yTranslate = bi_vscr_parseTranslateY(sTranslate);");
        this.println("  if (yTranslate != null)");
        this.println("    offsetY = offsetY + yTranslate;");
        this.println("  sTranslate = \"translate(0, \" + offsetY + \")\";");
        this.println("  uthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_vscr_translateDThResizeArrow(newY, scrObj)");
        this.println("{");
        this.println("  var dthaElem = document.getElementById(scrObj.base_id + \"_dtha\");");
        this.println("  var sTranslate = dthaElem.getAttributeNS(null, \"transform\");");
        this.println("  var offsetY = newY - (scrObj.thumbCoord + scrObj.thumbSize);");
        this.println("  var yTranslate = bi_vscr_parseTranslateY(sTranslate);");
        this.println("  if (yTranslate != null)");
        this.println("    offsetY = offsetY + yTranslate;");
        this.println("  sTranslate = \"translate(0, \" + offsetY + \")\";");
        this.println("  dthaElem.setAttributeNS(null, \"transform\", sTranslate);");
        this.println("}");
        this.println("function bi_vscr_parseTranslateY(translate)");
        this.println("{");
        this.println("  if (translate != null)");
        this.println("  {");
        this.println("    var op = translate.indexOf('(');");
        this.println("    var comma = translate.indexOf(',');");
        this.println("    var cp = translate.indexOf(')');");
        this.println("    var yString = null;");
        this.println("    if (comma >= 0)");
        this.println("      yString = translate.substring(comma+1, cp);");
        this.println("    return eval(yString);");
        this.println("  }");
        this.println("  return null;");
        this.println("}");
        this.println("function bi_vscr_utha_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownY = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("  bi_vscr_createUThAPane(scrObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var lines = new Array(scrObj.labels[bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj)]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_utha_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_vscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_utha_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var y = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("    var offsetY = y - bi_mouseDownY;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currY = scrObj.thumbCoord;");
        this.println("    var newY = bi_scr_validate_th_minEdge(currY + offsetY, scrObj);");
        this.println("    var newHeight = scrObj.thumbSize + (currY - newY);");
        this.println("    thumbElem.setAttributeNS(null, \"y\", newY);");
        this.println("    thumbElem.setAttributeNS(null, \"height\", newHeight);");
        this.println("    bi_vscr_translateUThResizeArrow(newY, scrObj);");
        this.println("    bi_mouseDownY = y;");
        this.println("    scrObj.thumbCoord = newY;");
        this.println("    scrObj.thumbSize = newHeight;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("    var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("    if (scrObj.bReverseDir)");
        this.println("    {");
        this.println("      var tmpI = maxIndex;");
        this.println("      maxIndex = minIndex;");
        this.println("      minIndex = tmpI;");
        this.println("    }");
        this.println("    if (minIndex > maxIndex)");
        this.println("      minIndex = minIndex - 1;");
        this.println("    if (!scrObj.bReverseDir)");
        this.println("      scrObj.index = minIndex;");
        this.println("    scrObj.span = maxIndex - minIndex + 1;");
        this.println("    var labelIndex = minIndex;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      labelIndex = maxIndex;");
        this.println("    var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_dtha_mDown(evt, scrObj)");
        this.println("{");
        this.println("  bi_bMouseDown = true;");
        this.println("  var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("  bi_mouseDownY = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("  bi_vscr_createDThAPane(scrObj, evt.target)");
        this.println("  var bAutoHide = false;");
        this.println("  var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("  var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("  if (scrObj.bReverseDir)");
        this.println("  {");
        this.println("    var tmpI = maxIndex;");
        this.println("    maxIndex = minIndex;");
        this.println("    minIndex = tmpI;");
        this.println("  }");
        this.println("  if (maxIndex < minIndex)");
        this.println("    maxIndex = maxIndex + 1;");
        this.println("  var labelIndex = maxIndex;");
        this.println("  if (scrObj.bReverseDir)");
        this.println("    labelIndex = minIndex;");
        this.println("  var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("  var beanName = scrObj.beanName;");
        this.println("  bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("}");
        this.println("function bi_vscr_dtha_mUp(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bBodyMouseDown)");
        this.println("    bi_vscr_body_mUp(evt, scrObj);");
        this.println("  else");
        this.println("  {");
        this.println("    if (bi_bMouseDown)");
        this.println("    {");
        this.println("      bi_bMouseDown = false;");
        this.println("      eval(scrObj.submitJS);");
        this.println("    }");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_dtha_mMove(evt, scrObj)");
        this.println("{");
        this.println("  if (bi_bMouseDown)");
        this.println("  {");
        this.println("    var svgRoot = bi_findTopSVGRoot(evt.target);");
        this.println("    var y = bi_undoPanZoomTransformY(bi_getClientY(evt, svgRoot), evt.target);");
        this.println("    var offsetY = y - bi_mouseDownY;");
        this.println("    var thumbElem = document.getElementById(scrObj.base_id + \"_th\");");
        this.println("    var currY = scrObj.thumbCoord + scrObj.thumbSize;");
        this.println("    var newY = bi_scr_validate_th_maxEdge(currY + offsetY, scrObj);");
        this.println("    var newHeight = scrObj.thumbSize + (newY - currY);");
        this.println("    thumbElem.setAttributeNS(null, \"height\", newHeight);");
        this.println("    bi_vscr_translateDThResizeArrow(newY, scrObj);");
        this.println("    bi_mouseDownY = y;");
        this.println("    scrObj.thumbSize = newHeight;");
        this.println("    var bAutoHide = false;");
        this.println("    var maxIndex = bi_mapMaxThAScrCoordToIndex(scrObj.thumbCoord + scrObj.thumbSize, scrObj);");
        this.println("    var minIndex = bi_mapScrCoordToIndex(scrObj.thumbCoord, scrObj);");
        this.println("    if (scrObj.bReverseDir)");
        this.println("    {");
        this.println("      var tmpI = maxIndex;");
        this.println("      maxIndex = minIndex;");
        this.println("      minIndex = tmpI;");
        this.println("    }");
        this.println("    if (maxIndex < minIndex)");
        this.println("      maxIndex = maxIndex + 1;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      scrObj.index = minIndex;");
        this.println("    scrObj.span = maxIndex - minIndex + 1;");
        this.println("    var labelIndex = maxIndex;");
        this.println("    if (scrObj.bReverseDir)");
        this.println("      labelIndex = minIndex;");
        this.println("    var lines = new Array(scrObj.labels[labelIndex]);");
        this.println("    var beanName = scrObj.beanName;");
        this.println("    bi_hideSVGTooltip(beanName);");
        this.println("    bi_showSVGTooltip(evt, lines, bAutoHide, beanName);");
        this.println("  }");
        this.println("}");
        this.println("function bi_vscr_createUThAPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_vscr_utha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_vscr_utha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_vscr_utha_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_vscr_createDThAPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_vscr_dtha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_vscr_dtha_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_vscr_dtha_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.println("function bi_vscr_createThPane(scrObj, node)");
        this.println("{");
        this.println("  var svgRoot = bi_findTopSVGRoot(node);");
        this.println("  var pane = document.createElementNS(bi_svgNS, \"rect\");");
        this.println("  pane.setAttributeNS(null, \"x\", 0);");
        this.println("  pane.setAttributeNS(null, \"y\", 0);");
        this.println("  pane.setAttributeNS(null, \"width\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"height\", \"100%\");");
        this.println("  pane.setAttributeNS(null, \"fill\", \"none\");");
        this.println("  pane.setAttributeNS(null, \"pointer-events\", \"visible\");");
        this.println("  pane.setAttributeNS(null, \"onmouseup\", \"bi_vscr_th_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmouseout\", \"bi_vscr_th_mUp(evt, \" + scrObj.objName + \")\");");
        this.println("  pane.setAttributeNS(null, \"onmousemove\", \"bi_vscr_th_mMove(evt, \" + scrObj.objName + \")\");");
        this.println("  svgRoot.appendChild(pane);");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
        this.m_bVScrollScriptWritten = true;
    }

    public void writeText(String s, Font f) throws IOException, Exception {
        if ((this.isFontEmbedding() || this.isFontTextMapped()) && s != null && f != null) {
            this.processTextForFontEmbedding(s, f);
        }
        super.writeText(s);
    }

    public void writeEmbeddedFonts(Graphics g) throws IOException, Exception {
        Iterator keys;
        Set keySet;
        if (this.m_fontTextMap != null && (keySet = this.m_fontTextMap.keySet()) != null && (keys = keySet.iterator()) != null && g instanceof Graphics2D) {
            FontRenderContext context = ((Graphics2D)g).getFontRenderContext();
            this.startElement(ELEM_DEFS);
            while (keys.hasNext()) {
                String key = (String)keys.next();
                FontTextEntry ftEntry = (FontTextEntry)this.m_fontTextMap.get(key);
                String textUsingFont = ftEntry.getText();
                Font font = ftEntry.getFont();
                Font normalizedFont = SVGWriter.createNormalizedFont(font);
                int missingGlyphCode = normalizedFont.getMissingGlyphCode();
                int[] missingGlyphCodeArray = new int[]{missingGlyphCode};
                GlyphVector glyphVector = normalizedFont.createGlyphVector(context, missingGlyphCodeArray);
                GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
                float advance = glyphMetrics.getAdvance();
                this.startElement(ELEM_FONT);
                this.writeAttribute(ATTR_HORIZ_ADV_X, advance);
                this.startElement(ELEM_MISSING_GLYPH);
                this.writeAttribute(ATTR_HORIZ_ADV_X, advance);
                Shape glyphShape = glyphVector.getGlyphOutline(0);
                AffineTransform transform = AffineTransform.getScaleInstance(1.0, -1.0);
                glyphShape = transform.createTransformedShape(glyphShape);
                String pathString = this.convertShapeToPath(glyphShape);
                if (pathString != null && pathString.length() > 0) {
                    this.writeAttribute(ATTR_D, pathString);
                }
                this.endElement();
                this.startElement(ELEM_FONT_FACE);
                this.writeFontFamilyAttribute(font.getName(), false);
                this.writeFontStyleAttribute(font.getStyle());
                this.writeFontWeightAttribute(font.getStyle());
                this.writeTextDecorationAttribute(font);
                this.writeAttribute(ATTR_UNITS_PER_EM, 100);
                FontMetrics fontMetrics = g.getFontMetrics(normalizedFont);
                this.writeAttribute(ATTR_ASCENT, fontMetrics.getAscent());
                this.writeAttribute(ATTR_DESCENT, fontMetrics.getDescent());
                this.endElement();
                for (int i = 0; i < textUsingFont.length(); ++i) {
                    char c = textUsingFont.charAt(i);
                    String stringC = String.valueOf(c);
                    this.startElement(ELEM_GLYPH);
                    glyphVector = normalizedFont.createGlyphVector(context, stringC);
                    glyphMetrics = glyphVector.getGlyphMetrics(0);
                    glyphShape = glyphVector.getGlyphOutline(0);
                    glyphShape = transform.createTransformedShape(glyphShape);
                    advance = glyphMetrics.getAdvance();
                    this.writeAttribute(ATTR_HORIZ_ADV_X, advance);
                    this.writeAttribute(ATTR_UNICODE, stringC);
                    pathString = this.convertShapeToPath(glyphShape);
                    if (pathString != null && pathString.length() > 0) {
                        this.writeAttribute(ATTR_D, pathString);
                    }
                    this.endElement();
                }
                this.endElement();
            }
            this.endElement();
        }
    }

    protected void processTextForFontEmbedding(String s, Font f) {
        if (s == null || s.length() < 1 || f == null) {
            return;
        }
        Font normalizedFont = SVGWriter.createNormalizedFont(f);
        String fontTextMapKey = this._createFontTextMapKey(normalizedFont);
        if (this.m_fontTextMap == null) {
            this.m_fontTextMap = new HashMap();
        }
        FontTextEntry ftEntry = (FontTextEntry)this.m_fontTextMap.get(fontTextMapKey);
        Object textUsingFont = null;
        if (ftEntry != null) {
            textUsingFont = ftEntry.getText();
        }
        if (textUsingFont == null) {
            textUsingFont = "";
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (((String)textUsingFont).indexOf(ch) != -1) continue;
            textUsingFont = (String)textUsingFont + ch;
        }
        if (((String)textUsingFont).length() > 0) {
            this.m_fontTextMap.put(fontTextMapKey, new FontTextEntry((String)textUsingFont, f));
        }
    }

    protected static Font createNormalizedFont(Font f) {
        HashMap attributes = new HashMap(f.getAttributes());
        attributes.put(TextAttribute.SIZE, Float.valueOf(100.0f));
        return new Font(attributes);
    }

    private String _createFontTextMapKey(Font f) {
        return f.getName() + f.getStyle();
    }

    public void setFontTextMap(Map fontTextMap) {
        Iterator keys;
        if (fontTextMap == null) {
            return;
        }
        if (this.m_fontTextMap == null) {
            this.m_fontTextMap = fontTextMap;
            return;
        }
        Set keySet = fontTextMap.keySet();
        if (keySet != null && (keys = keySet.iterator()) != null) {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                FontTextEntry ftEntry = (FontTextEntry)fontTextMap.get(key);
                FontTextEntry oldFtEntry = (FontTextEntry)this.m_fontTextMap.get(key);
                if (oldFtEntry == null) {
                    this.m_fontTextMap.put(key, ftEntry);
                    continue;
                }
                if (ftEntry == null) continue;
                oldFtEntry.merge(ftEntry);
                this.m_fontTextMap.put(key, oldFtEntry);
            }
        }
    }

    public Map getFontTextMap() {
        return this.m_fontTextMap;
    }

    public void setFontTextMapped(boolean fontTextMapped) {
        this.m_fontTextMapped = fontTextMapped;
    }

    public boolean isFontTextMapped() {
        return this.m_fontTextMapped;
    }

    public List getScriptIdList() {
        return this.m_scriptIds;
    }

    protected void addToScriptIdList(String id) {
        if (id == null || id.length() < 1) {
            return;
        }
        if (this.m_scriptIds == null) {
            this.m_scriptIds = new ArrayList();
        }
        this.m_scriptIds.add(id);
    }

    public String getBeanName() {
        if (this.m_id != null) {
            return this.m_id;
        }
        return "";
    }

    public void setBeanName(String id) {
        this.m_id = id;
    }

    public String getFilteredBeanName() {
        String name = this.getBeanName();
        if (name != null && name.length() > 0) {
            name = name.replace(':', '_');
        }
        return name;
    }

    public String getSimpleBeanName() {
        int i;
        String name = this.getBeanName();
        if (name != null && name.length() > 0 && (i = name.lastIndexOf(58)) > -1 && i < name.length() - 1) {
            name = name.substring(i + 1, name.length());
        }
        return name;
    }

    protected String constructId(String id) {
        return id;
    }
}

