/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared.marker;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.shared.marker.LegendMarker;
import oracle.dss.legend.shared.marker.MarkerShape;
import oracle.dss.legend.shared.util.LegendUtils;
import oracle.dss.util.containers.Marker;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillTexture;

public class BuiltInMarker
extends LegendMarker {
    protected Color m_markerFillColor;
    protected int m_markerPattern = -1;
    protected MarkerShape m_markerShape;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuiltInMarker)) {
            return false;
        }
        BuiltInMarker other = (BuiltInMarker)object;
        if (!(this.m_markerFillColor != null ? this.m_markerFillColor.equals(other.m_markerFillColor) : other.m_markerFillColor == null)) {
            return false;
        }
        if (this.m_markerPattern != other.m_markerPattern) {
            return false;
        }
        if (!(this.m_markerShape != null ? this.m_markerShape.equals((Object)other.m_markerShape) : other.m_markerShape == null)) {
            return false;
        }
        return Double.compare(this.m_opacity, other.m_opacity) == 0;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.m_markerFillColor == null ? 0 : this.m_markerFillColor.hashCode());
        result = 37 * result + this.m_markerPattern;
        result = 37 * result + (this.m_markerShape == null ? 0 : this.m_markerShape.hashCode());
        long temp = Double.doubleToLongBits(this.m_opacity);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public MarkerShape getMarkerShape() {
        return this.m_markerShape;
    }

    public int getPattern() {
        return this.m_markerPattern;
    }

    public Color getFillColor() {
        return this.m_markerFillColor;
    }

    public BuiltInMarker(MarkerShape shape, Color color, int pattern, double opacity) {
        this.m_markerShape = shape;
        this.m_markerFillColor = color;
        this.m_markerPattern = pattern;
        this.m_opacity = opacity;
    }

    @Override
    public void calc() {
    }

    @Override
    public void calcFinal() {
    }

    @Override
    public List<DrawableObject> render() {
        double scaleX;
        ArrayList<DrawableObject> item = new ArrayList<DrawableObject>();
        Marker marker = null;
        int markerWidth = this.m_width;
        int markerHeight = this.m_height;
        double scaleY = scaleX = Math.min(Double.valueOf(markerWidth) / Double.valueOf(8.0), Double.valueOf(markerHeight) / Double.valueOf(8.0));
        if (this.m_markerShape == MarkerShape.SHAPE_SQUARE || this.m_markerShape == null) {
            marker = LegendUtils.getBuiltInMarker("square", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_CIRCLE) {
            marker = LegendUtils.getBuiltInMarker("circle", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_DIAMOND) {
            marker = LegendUtils.getBuiltInMarker("diamond", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_PLUS) {
            marker = LegendUtils.getBuiltInMarker("plus", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_TRIANGLE_DOWN) {
            marker = LegendUtils.getBuiltInMarker("triangleDown", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_TRIANGLE_UP) {
            marker = LegendUtils.getBuiltInMarker("triangleUp", this.m_x, this.m_y, scaleX, scaleY);
        } else if (this.m_markerShape == MarkerShape.SHAPE_HUMAN) {
            marker = LegendUtils.getBuiltInMarker("human", this.m_x, this.m_y, scaleX, scaleY);
        }
        if (marker != null) {
            AffineTransform translate = AffineTransform.getTranslateInstance(markerWidth / 2, markerHeight / 2);
            LegendUtils.transformDrawables(marker.getDrawables(), translate);
            Color fillColor = LegendUtils.applyOpacity(this.m_markerFillColor, this.m_opacity);
            if (this.m_markerPattern != -1) {
                Color bc = Color.WHITE;
                bc = LegendUtils.applyOpacity(bc, this.m_opacity);
                marker.setFill(new FillTexture(fillColor, bc, this.m_markerPattern));
            } else {
                marker.setFill(new FillColor(fillColor));
            }
            marker.setStroke(this.getInstanceBorder());
            item.add(marker);
        }
        return item;
    }
}

