/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Scat
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;
    static final int HORZ_QUAD_LINE = 500;
    static final int VERT_QUAD_LINE = 600;
    private static final double BUBBLE_MAX_DIAMETER_PERCENT = 0.275;
    private static final double BUBBLE_MIN_AREA_PERCENT = 5.0E-5;
    private static final int FRAME_EDGE_BUFFER = 3;
    private static final double BUBBLE_MIN_DEST_DIAMETER = 5.0;
    private static final int T1_MIN = 15;
    private static final int T1_MAX = 45;
    private static final int T2_MIN = 30;
    private static final int T2_MAX = 180;
    private static final double FLOOR_PERCENT = 0.15;
    private static final int S1_MIN = 5;
    private static final int S1_MAX = 20;
    private static final int S2_MIN = 30;
    private static final int S2_MAX = 100;
    private static final double CEIL_PERCENT = 0.005;
    private int[][] m_bubbleSizes;
    private int[][] m_bubbleSizesX;
    private int[][] m_bubbleSizesY;
    private static final double LINE_CONNECTOR_OFFSET = 0.65;
    private static final double LINE_CONNECTOR_ARROW_HEIGHT = 3.0;
    private static final double LINE_CONNECTOR_NOTCH_SIZE = 0.15;

    @Override
    public void calc() {
        super.calc();
        if (this.m_Perspective.getRenderMode() == 1) {
            return;
        }
        if (this.m_gt.isLineSelectPoint()) {
            this.calcLineSelectPoint();
            return;
        }
        this.m_Perspective.calcReferenceObjects(1);
        this.m_Perspective.calcAnnotations(GraphConstants.AnnotationLocation.BACK);
        this.drawFitLines();
        this.drawQuadrantLines();
        GraphConstants.ScatterLineType lineType = this.m_Perspective.getScatterLineType();
        if (lineType == GraphConstants.ScatterLineType.LINE) {
            this.drawLines(false);
        } else if (lineType == GraphConstants.ScatterLineType.ARROW) {
            this.drawMarkerConnectors();
        }
        if (this.m_nDepthRadius > 0) {
            this.drawAllMarkersWithDepth(false);
        } else {
            this.drawMarkers();
        }
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        if (this.isSingleSeriesOnly() && this.m_nSeries > 1) {
            this.m_nSeries = 1;
            this.m_nTotalSeries = 1;
        }
    }

    public void calcLineSelectPoint() {
        this.drawLines(false);
        this.drawSelectPointMarker();
        this.drawLabels();
    }

    public void drawSelectPointMarker() {
        int markerSizeX;
        RelativeAxisObj axisObj = this.m_X1Axis;
        VC vc = this.m_Perspective.m_VC;
        double markerLocationX = this.m_Perspective.getDoubleProp(Attr.MarkerLocationX);
        double markerLocationVirt = axisObj.getValueCoord(markerLocationX);
        double markerLocationDest = vc.virtToDestX((int)markerLocationVirt);
        int nMarkerSeriesID = 1 % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = new IdentObj(-3, nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        int maxXCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
        int minXCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
        int minYCoord = (int)this.m_Y1Axis.getValueCoord(this.m_Y1Axis.getMinValue());
        if (markerLocationX > (double)maxXCoord || markerLocationX < (double)minXCoord) {
            this.m_Perspective.getErrorHandler().log("MarkerLocationX is beyond the axis range", this.getClass().getName(), "drawSelectPointMarker()");
            return;
        }
        int markerSizeY = markerSizeX = this.m_Perspective.getMarkerSizeDefault();
        if (this.m_bSquareMarkers) {
            double destY;
            double destX = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
            if (destX > (destY = (double)this.m_Perspective.m_VC.virtToDestHeight(markerSizeY))) {
                markerSizeX = (int)((double)markerSizeX * destY / destX);
            } else {
                markerSizeY = (int)((double)markerSizeY * destX / destY);
            }
        }
        this.m_smallMarker = this.m_autoGradient && this.m_Perspective.m_VC.virtToDestWidth(markerSizeX) <= 8;
        BlackBoxIF blackBox = this.assignSeriesColor(1, 0);
        Vector list = this.m_Detectiv.getVectorList();
        DetPolyline polyline = (DetPolyline)list.lastElement();
        Point[] allPoints = polyline.getAllPoints();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        boolean firstMarker = false;
        for (int i = 0; i < allPoints.length; ++i) {
            Point pointDest = vc.virtToDest(allPoints[i]);
            if (!(markerLocationDest < pointDest.getX())) continue;
            if (i == 0) break;
            Point prevPointDest = vc.virtToDest(allPoints[i - 1]);
            x1 = prevPointDest.getX();
            y1 = prevPointDest.getY();
            x2 = pointDest.getX();
            y2 = pointDest.getY();
            firstMarker = true;
            break;
        }
        if (!firstMarker) {
            this.m_Perspective.getErrorHandler().log("MarkerLocationX is beyond the line segment", this.getClass().getName(), "drawSelectPointMarker()");
            return;
        }
        double slope = (y1 - y2) / (x1 - x2);
        double y = slope * (markerLocationDest - x1) + y1;
        int virtY = vc.destToVirtY((int)y);
        Point center = new Point((int)markerLocationVirt, virtY);
        this.m_Perspective.m_lineFixedValueX = markerLocationX;
        this.m_Perspective.m_lineFixedValueY = this.m_Y1Axis.getValueFromCoord(virtY);
        Point yAttach = new Point(minXCoord, virtY);
        Point xAttach = new Point((int)markerLocationVirt, minYCoord);
        Vector<Point> points = new Vector<Point>(2);
        points.addElement(center);
        points.addElement(yAttach);
        int lineWidth = this.m_Perspective.getLineWidth(idMarkerSeries);
        BlackBoxIF bbobj = this.assignSeriesColor(1, 0);
        bbobj.setTransparentBorderColor(false);
        if (bbobj.getFillColor() != null) {
            bbobj.setBorderColor(blackBox.getFillColor());
        }
        new DetPolyline(this.m_Detectiv, new IdentObj(512, -3, -3), points, bbobj, null, lineWidth, 0, false);
        points = new Vector(2);
        points.addElement(center);
        points.addElement(xAttach);
        new DetPolyline(this.m_Detectiv, new IdentObj(512, -3, -3), points, bbobj, null, lineWidth, 0, false);
        MarkerObj.createMarker(this.m_Detectiv, new IdentObj(511, 0), markerTemplate, center, markerSizeX, markerSizeY, blackBox, null, true);
        Point p = (Point)this.m_Perspective.getObjProp(Attr.LineSelectedPoint);
        if (p == null) {
            return;
        }
        for (int i = 0; i < allPoints.length; ++i) {
            Point pointDest = vc.virtToDest(allPoints[i]);
            if (!((double)p.x < pointDest.getX())) continue;
            Point prevPointDest = vc.virtToDest(allPoints[i - 1]);
            x1 = prevPointDest.getX();
            y1 = prevPointDest.getY();
            x2 = pointDest.getX();
            y2 = pointDest.getY();
            break;
        }
        p = JChart_2D_Scat.myGetClosestPoint(new Point((int)x1, (int)y1), new Point((int)x2, (int)y2), p);
        int secondVirtX = vc.destToVirtX(p.x);
        int secondVirtY = vc.destToVirtY(p.y);
        this.m_Perspective.m_lineSelectValueX = this.m_X1Axis.getValueFromCoord(secondVirtX);
        this.m_Perspective.m_lineSelectValueY = this.m_Y1Axis.getValueFromCoord(secondVirtY);
        Point center2 = new Point(secondVirtX, secondVirtY);
        Point y2Attach = new Point(minXCoord, secondVirtY);
        Point x2Attach = new Point(secondVirtX, minYCoord);
        points = new Vector(2);
        points.addElement(center2);
        points.addElement(y2Attach);
        BlackBoxIF blackBox2 = this.assignSeriesColor(2, 0);
        int nMarkerSeriesID2 = 2 % this.m_nSeriesLooping;
        IdentObj idMarkerSeries2 = new IdentObj(-3, nMarkerSeriesID2);
        int lineWidth2 = this.m_Perspective.getLineWidth(idMarkerSeries2);
        BlackBoxIF bbobj2 = this.assignSeriesColor(2, 0);
        bbobj2.setTransparentBorderColor(false);
        if (bbobj2.getFillColor() != null) {
            bbobj2.setBorderColor(blackBox2.getFillColor());
        }
        new DetPolyline(this.m_Detectiv, new IdentObj(512, -3, -3), points, bbobj2, null, lineWidth2, 0, false);
        points = new Vector(2);
        points.addElement(center2);
        points.addElement(x2Attach);
        MarkerTemplate markerTemplate2 = this.getMarkerShape(idMarkerSeries2);
        new DetPolyline(this.m_Detectiv, new IdentObj(512, -3, -3), points, bbobj2, null, lineWidth2, 0, false);
        MarkerObj.createMarker(this.m_Detectiv, new IdentObj(511, 1), markerTemplate2, center2, markerSizeX, markerSizeY, blackBox2, null, true);
    }

    private static Point myGetClosestPoint(Point pt1, Point pt2, Point p) {
        double u = (double)((p.x - pt1.x) * (pt2.x - pt1.x) + (p.y - pt1.y) * (pt2.y - pt1.y)) / (JChart_2D_Scat.sqr(pt2.x - pt1.x) + JChart_2D_Scat.sqr(pt2.y - pt1.y));
        if (u > 1.0) {
            return (Point)pt2.clone();
        }
        if (u <= 0.0) {
            return (Point)pt1.clone();
        }
        return new Point((int)((double)pt2.x * u + (double)pt1.x * (1.0 - u) + 0.5), (int)((double)pt2.y * u + (double)pt1.y * (1.0 - u) + 0.5));
    }

    private static double sqr(double x) {
        return x * x;
    }

    @Override
    public boolean isSingleSeriesOnly() {
        return this.m_gt.isLineSelectPoint();
    }

    protected void calcBubbleSizes(double dataMin, double dataMax) {
        double maxBubbleVirtArea;
        double minBubbleDestDiameterLimit;
        int frameDestHeight;
        this.m_bubbleSizesX = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizesY = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizes = null;
        int bubbleCount = this.m_nTotalSeries * this.m_nTotalGroups;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int s = 0;
        int g = 0;
        VC vc = this.m_Perspective.getVC();
        Rectangle frameVirtRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        int frameDestWidth = vc.virtToDestWidth(frameVirtRect.width);
        if (frameDestWidth < 1) {
            frameDestWidth = 1;
        }
        if ((frameDestHeight = vc.virtToDestHeight(frameVirtRect.height)) < 1) {
            frameDestHeight = 1;
        }
        boolean bVerticallyDense = frameVirtRect.height / frameDestHeight > frameVirtRect.width / frameDestWidth;
        this.m_bubbleSizes = bVerticallyDense ? this.m_bubbleSizesY : this.m_bubbleSizesX;
        GraphConstants.BubbleMarkerSizing bubbleSizing = this.m_Perspective.getBubbleMarkerSizing();
        if (bubbleSizing != GraphConstants.BubbleMarkerSizing.RELATIVE) {
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    int virtHeight;
                    int virtWidth;
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (bubbleSizing == GraphConstants.BubbleMarkerSizing.PIXELS) {
                        destSize = (int)Math.max(0.0, this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XYZ_Z).m_fValue);
                        virtWidth = vc.destToVirtWidth(destSize);
                        virtHeight = vc.destToVirtHeight(destSize);
                    } else {
                        virtWidth = (int)Math.max(0.0, this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XYZ_Z).m_fValue);
                        destSize = vc.virtToDestWidth(virtWidth);
                        virtHeight = vc.destToVirtHeight(destSize);
                    }
                    this.m_bubbleSizesX[s][g] = virtWidth;
                    this.m_bubbleSizesY[s][g] = virtHeight;
                }
            }
            return;
        }
        double minDestAreaPercent = 5.0E-5;
        double minBubbleDestArea = minDestAreaPercent * (double)frameDestWidth * (double)frameDestHeight;
        double maxBubbleDestDiameter = 0.0;
        maxBubbleDestDiameter = frameDestWidth < frameDestHeight ? 0.275 * (double)frameDestWidth : 0.275 * (double)frameDestHeight;
        double maxBubbleDestArea = Math.PI * (maxBubbleDestDiameter / 2.0) * (maxBubbleDestDiameter / 2.0);
        double minBubbleDestDiameter = Math.ceil(2.0 * Math.sqrt(minBubbleDestArea / Math.PI));
        if (minBubbleDestDiameter < (minBubbleDestDiameterLimit = 5.0)) {
            minBubbleDestDiameter = minBubbleDestDiameterLimit;
            minBubbleDestArea = Math.PI * (minBubbleDestDiameter / 2.0) * (minBubbleDestDiameter / 2.0);
        }
        if (maxBubbleDestDiameter < minBubbleDestDiameter) {
            double tmpDiameter = maxBubbleDestDiameter;
            maxBubbleDestDiameter = minBubbleDestDiameter;
            minBubbleDestDiameter = tmpDiameter;
            double tmpArea = maxBubbleDestArea;
            maxBubbleDestArea = minBubbleDestArea;
            minBubbleDestArea = tmpArea;
        }
        double maxBubbleVirtDiameter = 0.0;
        double minBubbleVirtDiameter = 0.0;
        if (bVerticallyDense) {
            minBubbleVirtDiameter = vc.destToVirtHeight((int)Math.ceil(minBubbleDestDiameter));
            maxBubbleVirtDiameter = vc.destToVirtHeight((int)Math.ceil(maxBubbleDestDiameter));
        } else {
            minBubbleVirtDiameter = vc.destToVirtWidth((int)Math.ceil(minBubbleDestDiameter));
            maxBubbleVirtDiameter = vc.destToVirtWidth((int)Math.ceil(maxBubbleDestDiameter));
        }
        double minBubbleVirtArea = Math.PI * (minBubbleVirtDiameter / 2.0) * (minBubbleVirtDiameter / 2.0);
        double origMaxVirtArea = maxBubbleVirtArea = Math.PI * (maxBubbleVirtDiameter / 2.0) * (maxBubbleVirtDiameter / 2.0);
        double origMinVirtArea = minBubbleVirtArea;
        double[] newRange = null;
        newRange = this._adjustBubbleSizeRangeForCount(origMinVirtArea, origMaxVirtArea, minBubbleVirtArea, maxBubbleVirtArea, gEnum, sEnum);
        minBubbleVirtArea = newRange[0];
        maxBubbleVirtArea = newRange[1];
        newRange = this._adjustBubbleSizeRangeForDataRange(origMinVirtArea, origMaxVirtArea, minBubbleVirtArea, maxBubbleVirtArea, dataMin, dataMax);
        minBubbleVirtArea = newRange[0];
        maxBubbleVirtArea = newRange[1];
        double bubbleVirtAreaRange = maxBubbleVirtArea - minBubbleVirtArea;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int destSize;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fRelSize = this.getRelZVal(s, g, bubbleCount);
                double markerVirtArea = minBubbleVirtArea + fRelSize * bubbleVirtAreaRange;
                int markerVirtDiameter = (int)Math.ceil(2.0 * Math.sqrt(markerVirtArea / Math.PI));
                if (bVerticallyDense) {
                    this.m_bubbleSizesY[s][g] = markerVirtDiameter;
                    destSize = vc.virtToDestHeight(markerVirtDiameter);
                    this.m_bubbleSizesX[s][g] = vc.destToVirtWidth(destSize);
                    continue;
                }
                this.m_bubbleSizesX[s][g] = markerVirtDiameter;
                destSize = vc.virtToDestWidth(markerVirtDiameter);
                this.m_bubbleSizesY[s][g] = vc.destToVirtHeight(destSize);
            }
        }
    }

    private double[] _adjustBubbleSizeRangeForCount(double origMin, double origMax, double currMin, double currMax, GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        double newMin = currMin;
        double newMax = currMax;
        int bubbleCount = this.m_nTotalSeries * this.m_nTotalGroups;
        double avgRelVal = this._calcAverageZRelVal(gEnum, sEnum);
        int t1Min = 15;
        int t1Max = 45;
        int t2Min = 30;
        int t2Max = 180;
        double floor = 0.15;
        int t1 = t1Min + (int)((1.0 - avgRelVal) * (double)(t1Max - t1Min));
        int t2 = t2Min + (int)((1.0 - avgRelVal) * (double)(t2Max - t2Min));
        double p12 = (1.0 - floor) / (double)(t2 - t1);
        if (bubbleCount >= t2) {
            newMax = newMin + floor * (newMax - newMin);
        } else if (bubbleCount >= t1) {
            newMax -= p12 * (double)(bubbleCount - t1) * (newMax - newMin);
        }
        int s1Min = 5;
        int s1Max = 20;
        int s2Min = 30;
        int s2Max = 100;
        double ceil = 0.005;
        int s1 = s1Min + (int)((1.0 - avgRelVal) * (double)(s1Max - s1Min));
        int s2 = s2Min + (int)((1.0 - avgRelVal) * (double)(s2Max - s2Min));
        double q12 = ceil / (double)(s2 - s1);
        if (bubbleCount < s1) {
            newMin += ceil * (newMax - newMin);
        } else if (bubbleCount < s2) {
            newMin += (ceil - q12 * (double)(bubbleCount - s1)) * (newMax - newMin);
        }
        return new double[]{newMin, newMax};
    }

    private double[] _adjustBubbleSizeRangeForDataRange(double origMin, double origMax, double currMin, double currMax, double dataMin, double dataMax) {
        double newMin = currMin;
        double newMax = currMax;
        double dataRange = dataMax - dataMin;
        if (dataRange != 0.0) {
            double desiredBubbleRatio;
            double buffer;
            double bubbleRatio;
            double dataRatio = bubbleRatio = currMax / currMin;
            if (dataMax > 0.0 && dataMin > 0.0) {
                dataRatio = dataMax / dataMin;
            } else if (dataMax < 0.0 && dataMin < 0.0) {
                dataRatio = dataMin / dataMax;
            }
            if (dataRatio < bubbleRatio && (buffer = currMax / (desiredBubbleRatio = dataRatio) - currMin) > 0.0) {
                newMin += buffer;
            }
        } else {
            newMin = newMax;
        }
        return new double[]{newMin, newMax};
    }

    private double getRelZVal(int s, int g, int bubbleCount) {
        double fValueZ = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XYZ_Z).m_fValue;
        double fRelSize = this.m_Z1Axis.getValueRelCoord(fValueZ);
        return fRelSize;
    }

    private double _calcAverageZRelVal(GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        int g = 0;
        int s = 0;
        int bubbleCount = this.m_nTotalGroups * this.m_nTotalSeries;
        double totalRelSize = 0.0;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double fRelSize = this.getRelZVal(s, g, bubbleCount);
                totalRelSize += fRelSize;
            }
        }
        double avgRelSize = totalRelSize / (double)bubbleCount;
        return avgRelSize;
    }

    private int _getBubbleSize(int series, int group) {
        if (this.m_bubbleSizes != null) {
            return this.m_bubbleSizes[series][group];
        }
        return -1;
    }

    protected int getBubbleSizeX(int s, int g) {
        if (this.m_bubbleSizesX != null) {
            return this.m_bubbleSizesX[s][g];
        }
        return -1;
    }

    protected int getBubbleSizeY(int s, int g) {
        if (this.m_bubbleSizesY != null) {
            return this.m_bubbleSizesY[s][g];
        }
        return -1;
    }

    @Override
    protected void drawLabel(int s, int g) {
        IdentObj id = this.m_Perspective.getDataText();
        Rectangle rClip = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isScatterWithLabel() || this.m_bDataTextDisplay) {
            Dimension labelDim = null;
            labelDim = this.m_Perspective.isMixedFreqTimeAxis() ? new Dimension(10000, 5000) : new Dimension(8000, 1600);
            boolean bScatLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
            TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bScatLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
            Graphics gx = this.m_Perspective.getGraphicsContext();
            if (this.m_dataOK[s][g] && this.m_DataLabel[s][g] != null) {
                BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
                Rectangle rLabel = this.calcDataValuePosition(s, g, labelDim);
                if (rLabel != null) {
                    boolean right;
                    IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                    this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                    String fullText = this.m_DataLabel[s][g];
                    String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullText);
                    int textPosition = this.m_Perspective.getDataTextPosition();
                    int fAngle = this.m_Perspective.getDataTextAngle(s, g);
                    boolean custom = textPosition == 0;
                    boolean left = textPosition == 7;
                    boolean bl = right = textPosition == 8;
                    if (custom || left || right) {
                        if (right || custom && (fAngle == 0 || fAngle == 360)) {
                            textStyle.setHorizAlign(2);
                        } else if (left || custom && fAngle == 180) {
                            textStyle.setHorizAlign(4);
                        }
                    }
                    if (this.m_Perspective.isExportingToXML()) {
                        if (newLabel == null) {
                            newLabel = "";
                        }
                        this.m_Detectiv.addMarkerLabel(new DetLabel(this.m_Detectiv, newID, newLabel, fullText, rLabel, textStyle, blackBox, false, rClip));
                    } else if (newLabel != null) {
                        new DetLabel(this.m_Detectiv, newID, newLabel, fullText, rLabel, textStyle, blackBox, false, rClip);
                    }
                }
            }
        }
    }

    protected void drawLabels() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vectStrLabels = null;
        IdentObj id = this.m_Perspective.getDataText();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Rectangle rClip = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isScatterWithLabel() || this.m_bDataTextDisplay) {
            int g;
            int s;
            vectStrLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                    vectStrLabels.addElement(this.m_DataLabel[s][g]);
                }
            }
            Dimension labelDim = null;
            labelDim = this.m_Perspective.isMixedFreqTimeAxis() ? new Dimension(10000, 5000) : new Dimension(8000, 1600);
            boolean bScatLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
            TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bScatLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
            int nFontSizeVC = bScatLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
            Graphics gx = this.m_Perspective.getGraphicsContext();
            textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vectStrLabels, labelDim, this.m_Perspective.m_VC);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    boolean right;
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                    BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
                    Rectangle rLabel = this.calcDataValuePosition(s, g, labelDim);
                    if (rLabel == null) continue;
                    IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                    String fullLabel = this.m_DataLabel[s][g];
                    String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullLabel);
                    int textPosition = this.m_Perspective.getDataTextPosition();
                    int fAngle = this.m_Perspective.getDataTextAngle(s, g);
                    boolean custom = textPosition == 0;
                    boolean left = textPosition == 7;
                    boolean bl = right = textPosition == 8;
                    if (custom || left || right) {
                        if (right || custom && (fAngle == 0 || fAngle == 360)) {
                            textStyle.setHorizAlign(2);
                        } else if (left || custom && fAngle == 180) {
                            textStyle.setHorizAlign(4);
                        }
                    }
                    new DetLabel(this.m_Detectiv, newID, newLabel, fullLabel, rLabel, textStyle, blackBox, false, rClip);
                }
            }
        }
    }

    @Override
    protected Rectangle calcDataValuePosition(int s, int g, Dimension labelDim) {
        List underlayAttrib;
        VC vc = this.m_Perspective.getVC();
        if (this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML()) {
            vc = this.m_Perspective.getRangeSliderVC();
        }
        IdentObj id = this.m_Perspective.getDataText();
        double nFontSizeVC = vc.destToVirtHeight((double)this.m_Perspective.getFontSize(id));
        double nFontSizeVCHoriz = vc.destToVirtWidth((double)this.m_Perspective.getFontSize(id));
        double width = labelDim.getWidth();
        double height = labelDim.getHeight();
        Point ptCenter = this.getCoords(s, g);
        int nDataTextPosition = this.m_Perspective.getDataTextPosition();
        double markerSize = this.m_Perspective.getMarkerSize(s, g);
        double markerHeight = vc.destToVirtHeight(markerSize);
        double markerWidth = vc.destToVirtWidth(markerSize);
        IdentObj underlayID = new IdentObj(259, s, g);
        Rectangle2D underLayRect = null;
        if (this.m_gt.isBubble()) {
            if (this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML()) {
                markerHeight = vc.destToVirtHeight(this.m_Perspective.getVC().virtToDestHeight((double)this.m_bubbleSizesY[s][g]));
                markerWidth = vc.destToVirtWidth(this.m_Perspective.getVC().virtToDestWidth((double)this.m_bubbleSizesX[s][g]));
            } else {
                markerHeight = this.m_bubbleSizesY[s][g];
                markerWidth = this.m_bubbleSizesX[s][g];
            }
            if (this.m_Perspective.getMarkerShape(this.m_Perspective.getSeries(s)) == 7) {
                markerHeight = markerHeight * 1.4 + 4.0;
            }
        }
        if (this.m_Perspective.m_ScatterGraphDataStyle != null && (this.m_Perspective.m_ScatterGraphDataStyle.isUnderlayShapePresent() || this.m_Perspective.m_ScatterGraphDataStyle.isUnderlayColorPresent()) && (underlayAttrib = this.m_Perspective.m_ScatterGraphDataStyle.getUnderlayAttributesFromSeries(s, g)) != null) {
            underLayRect = this.m_Perspective.getUnderLayRectangle(underlayID);
        }
        double pX = ptCenter.getX() - width / 2.0;
        double pY = ptCenter.getY() - height / 2.0;
        if (nDataTextPosition == 1) {
            pY += markerHeight / 2.0;
            if (this.m_gt.isBubble()) {
                pY += nFontSizeVC;
            }
        } else if (nDataTextPosition == 6) {
            pY -= markerHeight / 2.0;
            if (this.m_gt.isBubble()) {
                pY -= nFontSizeVC;
            }
        } else if (nDataTextPosition == 7) {
            pX = ptCenter.getX() - width - markerWidth / 2.0;
            pX = this.m_gt.isBubble() ? (pX -= nFontSizeVCHoriz / 2.0) : (pX += nFontSizeVCHoriz / 2.0);
        } else if (nDataTextPosition == 8) {
            pX = ptCenter.getX() + markerWidth / 2.0;
            pX = this.m_gt.isBubble() ? (pX += nFontSizeVCHoriz / 2.0) : (pX -= nFontSizeVCHoriz / 2.0);
        } else if (underLayRect != null) {
            if (nDataTextPosition == 1) {
                pY = this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML() ? vc.destToVirtY(this.m_Perspective.getVC().virtToDestY(underLayRect.getMaxY())) : underLayRect.getMaxY();
                pY -= height / 2.0;
                pY += nFontSizeVC;
            } else if (nDataTextPosition == 6) {
                pY = this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML() ? vc.destToVirtY(this.m_Perspective.getVC().virtToDestY(underLayRect.getMinY())) : underLayRect.getMinY();
                pY -= height / 2.0;
                pY -= nFontSizeVC;
            }
        } else if (nDataTextPosition == 0) {
            double fAngle = this.m_Perspective.getDataTextAngle(s, g);
            double fDist = this.m_Perspective.getDataTextRadius(s, g);
            if (fAngle == 0.0 || fAngle == 360.0) {
                pX += markerWidth / 2.0 * fDist / 50.0;
            } else if (fAngle == 180.0) {
                pX -= markerWidth / 2.0 * fDist / 50.0;
            } else {
                double radius = this.m_gt.isBubble() ? vc.virtToDestHeight(markerHeight / 2.0) : 40.0;
                pX += Math.cos(fAngle * (Math.PI / 180)) * radius * fDist;
                pY += Math.sin(fAngle * (Math.PI / 180)) * radius * fDist;
            }
        }
        return new Rectangle((int)pX, (int)pY, (int)width, (int)height);
    }

    protected void drawQuadrantLines() {
        IdentObj newID;
        Double dObj;
        int i;
        IdentObj id = this.m_Perspective.getQuadrantLine();
        boolean bDoNotRecalcDefault = this.m_Perspective.isZoomScrollStarted();
        boolean bDisplay = this.m_gt.isBubble() ? this.m_Perspective.getDisplay(id) : this.m_Perspective.getDisplay(this.m_Perspective.getScatterQuadrantLine());
        if (!bDisplay) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        blackBox.setBorderColor(this.m_Perspective.getBorderColor(id));
        int nWidth = this.m_Perspective.getLineWidth(id);
        int nVert = this.m_Perspective.getQuadrantLineCountX();
        int nHorz = this.m_Perspective.getQuadrantLineCountY();
        Rectangle rFrame = this.m_Perspective.getFrameRect(true);
        int x0 = rFrame.x;
        int x1 = rFrame.x + rFrame.width;
        int y0 = rFrame.y;
        int y1 = rFrame.y + rFrame.height;
        this.m_Perspective.m_yQuad = new double[nHorz];
        this.m_Perspective.m_xQuad = new double[nVert];
        double y1Incr = (this.m_Y1Axis.getMaxValue() - this.m_Y1Axis.getMinValue()) / (double)(nHorz + 1);
        double x1Incr = (this.m_X1Axis.getMaxValue() - this.m_X1Axis.getMinValue()) / (double)(nVert + 1);
        for (i = 0; i < nHorz; ++i) {
            double yValue = this.m_Perspective.getQuadLineValueY(i);
            if (yValue == 1.234567E301) {
                id.setMiscID(i);
                dObj = (Double)this.m_Perspective.getFromLook2(id, Attr.DefaultQuadrantLineValueY);
                if (dObj != null && bDoNotRecalcDefault) {
                    yValue = dObj;
                } else {
                    yValue = this.m_Y1Axis.getMinValue() + (double)(i + 1) * y1Incr;
                    this.m_Perspective.putToLook2(id, Attr.DefaultQuadrantLineValueY, yValue);
                }
            }
            int yQuad = y0 + (int)(this.m_Y1Axis.getValueRelCoord(yValue) * (double)rFrame.height);
            this.m_Perspective.m_yQuad[i] = yValue;
            newID = new IdentObj(id);
            newID.setMiscID(i + 500);
            new DetLine(this.m_Detectiv, newID, x0, yQuad, x1, yQuad, (BlackBoxIF)blackBox, this.m_rClip, nWidth);
        }
        for (i = 0; i < nVert; ++i) {
            double xValue = this.m_Perspective.getQuadLineValueX(i);
            if (xValue == 1.234567E301) {
                id.setMiscID(i);
                dObj = (Double)this.m_Perspective.getFromLook2(id, Attr.DefaultQuadrantLineValueX);
                if (dObj != null && bDoNotRecalcDefault) {
                    xValue = dObj;
                } else {
                    xValue = this.m_X1Axis.getMinValue() + (double)(i + 1) * x1Incr;
                    this.m_Perspective.putToLook2(id, Attr.DefaultQuadrantLineValueX, xValue);
                }
            }
            int xQuad = x0 + (int)(this.m_X1Axis.getValueRelCoord(xValue) * (double)rFrame.width);
            this.m_Perspective.m_xQuad[i] = xValue;
            newID = new IdentObj(id);
            newID.setMiscID(i + 600);
            new DetLine(this.m_Detectiv, newID, xQuad, y0, xQuad, y1, (BlackBoxIF)blackBox, this.m_rClip, nWidth);
        }
    }

    @Override
    protected Point getCoords(int s, int g) {
        Point center = !this.m_bHorz ? new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]) : new Point(this.m_numYCoords[s][g], this.m_numXCoords[s][g]);
        return center;
    }

    @Override
    public Point2D getDataValuesXY(int s, int g) throws AssertionException {
        double x = this.getXValue(s, g);
        double y = this.getYValue(s, g);
        return new Point2D.Double(x, y);
    }

    public String getLabelValue(int s, int g) {
        DataItem item = this.m_gt.isBubble() ? DataItem.DI_XYZ_LBL_LBL : DataItem.DI_XY_LBL_LBL;
        String sValue = this.m_Access.getDataAsString(s, g, item);
        return sValue;
    }

    public double getLabelXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getLabelYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    @Override
    public int getMarkerSize(int s, int g) {
        if (this.m_gt.isBubble()) {
            return this._getBubbleSize(s, g);
        }
        return super.getMarkerSize(s, g);
    }

    @Override
    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        return this.getVCPositionsXY(s, x, y, true);
    }

    @Override
    protected Point getVCPositionsXY(int s, double x, double y, boolean bConstrainCoords) throws AssertionException {
        RelativeAxisObj xAxis = this.m_X1Axis;
        RelativeAxisObj yAxis = this.whichAxisForSeries(s, null);
        int xCoord = (int)xAxis.getValueCoord(x, bConstrainCoords);
        int yCoord = (int)yAxis.getValueCoord(y, bConstrainCoords);
        return new Point(xCoord, yCoord);
    }

    public double getXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_XValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_YValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_ZValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Z;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    @Override
    public boolean wantLegend() {
        return true;
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        boolean bBubble = this.m_gt.isBubble();
        String ResultString = dataTextTemplate;
        ResultString = this.ReplaceMacro(ResultString, "[X]", dataItems[0]);
        ResultString = this.ReplaceMacro(ResultString, "[Y]", dataItems[1]);
        if (bBubble) {
            ResultString = this.ReplaceMacro(ResultString, "[SIZE]", dataItems[2]);
        }
        return ResultString;
    }

    private void drawMarkerConnectors() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        RelativeAxisObj x1Axis = this.getX1Axis();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            gEnum.reset();
            if (s >= this.m_nTotalSeries) break;
            IdentObj idSeries = this.m_Perspective.getSeries(s);
            int lineStyle = this.m_Perspective.getLineStyle(idSeries);
            int lineWidth = this.m_Perspective.getLineWidth(idSeries);
            double arrowHeight = (double)lineWidth * 3.0;
            double arrowHalfWidth = arrowHeight / Math.sqrt(3.0);
            int markerShape = this.m_Perspective.getMarkerShape(idSeries);
            RelativeAxisObj yAxis = this.m_Perspective.getJGraphType().isDualY() && this.m_Perspective.getAxisAssignment(s) == 1 ? this.getY2Axis() : this.getY1Axis();
            BlackBoxIF blackBox = new BlackBoxObj(this.m_Perspective, idSeries);
            blackBox = blackBox.runRules(s, -3);
            blackBox.setTransparentBorderColor(false);
            Color fillColor = null;
            if (blackBox.getFillType() == 1) {
                fillColor = blackBox.getFillColor();
            }
            if (fillColor == null) {
                fillColor = this.m_Perspective.getFillColor(idSeries);
            }
            blackBox.setBorderColor(fillColor);
            int gSize = -1;
            int gNextSize = -1;
            while (gEnum.hasMoreElements()) {
                Point2D.Double left;
                Point2D.Double right;
                double endY;
                double startY;
                double endX;
                double startX;
                int y2Coord;
                int x2Coord;
                Point pt2;
                int y1Coord;
                double y2;
                double x2;
                double y1;
                double x1;
                int g = gEnum.nextGroup();
                int gNext = 0;
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                gNext = gEnum.peekAtNextGroup();
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                try {
                    x1 = this.getXValue(s, g);
                    y1 = this.getYValue(s, g);
                    x2 = this.getXValue(s, gNext);
                    y2 = this.getYValue(s, gNext);
                }
                catch (AssertionException e) {
                    continue;
                }
                int x1Coord = (int)x1Axis.getValueCoord(x1, false);
                Point pt1 = new Point(x1Coord, y1Coord = (int)yAxis.getValueCoord(y1, false));
                if (pt1.equals(pt2 = new Point(x2Coord = (int)x1Axis.getValueCoord(x2, false), y2Coord = (int)yAxis.getValueCoord(y2, false)))) continue;
                gSize = gNextSize > -1 ? gNextSize : this.getMarkerSize(s, g);
                gNextSize = this.getMarkerSize(s, gNext);
                VC posVC = this.m_Perspective.getZoomAndScroll() == 0 ? this.m_Perspective.getRangeSliderSeriesVC(s) : this.m_Perspective.getVC();
                Point destPt1 = posVC.virtToDest(pt1);
                Point destPt2 = posVC.virtToDest(pt2);
                int destGSize = Math.max(6, this.m_Perspective.getVC().virtToDestWidth(gSize));
                int destGNextSize = Math.max(6, this.m_Perspective.getVC().virtToDestWidth(gNextSize));
                if (this.m_Perspective.isChartBubble() && markerShape == 7) {
                    destGSize = (int)((double)destGSize * MarkerObj.SHAPE_HUMAN_WIDTH_HEIGHT_RATIO);
                    destGNextSize = (int)((double)destGNextSize * MarkerObj.SHAPE_HUMAN_WIDTH_HEIGHT_RATIO);
                }
                double deltaX = destPt2.getX() - destPt1.getX();
                double deltaY = destPt2.getY() - destPt1.getY();
                if (deltaX == 0.0) {
                    endX = startX = destPt1.getX();
                    double maxOffset = (double)Math.max(destGSize, destGNextSize) * 0.65;
                    if (Math.abs(deltaY) > maxOffset * 2.0) {
                        if (deltaY > 0.0) {
                            startY = destPt1.getY() + 0.65 * (double)destGSize;
                            endY = destPt2.getY() - 0.65 * (double)destGNextSize;
                        } else {
                            startY = destPt1.getY() - 0.65 * (double)destGSize;
                            endY = destPt2.getY() + 0.65 * (double)destGNextSize;
                        }
                    } else {
                        startY = destPt1.getY();
                        endY = destPt2.getY();
                    }
                } else {
                    double slope = deltaY / deltaX;
                    double xOffset = 0.65 / Math.sqrt(1.0 + slope * slope);
                    double maxOffset = (double)Math.max(destGSize, destGNextSize) * xOffset;
                    if (Math.abs(deltaX) > maxOffset * 2.0) {
                        if (deltaX > 0.0) {
                            startX = destPt1.getX() + xOffset * (double)destGSize;
                            endX = destPt2.getX() - xOffset * (double)destGNextSize;
                        } else {
                            startX = destPt1.getX() - xOffset * (double)destGSize;
                            endX = destPt2.getX() + xOffset * (double)destGNextSize;
                        }
                    } else {
                        startX = destPt1.getX();
                        endX = destPt2.getX();
                    }
                    startY = this.calcyPosition(destPt1, destPt2, startX);
                    endY = this.calcyPosition(destPt1, destPt2, endX);
                }
                destPt1 = new Point((int)startX, (int)startY);
                destPt2 = new Point((int)endX, (int)endY);
                deltaX = destPt2.getX() - destPt1.getX();
                deltaY = destPt2.getY() - destPt1.getY();
                double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                double arrowX = (1.0 - arrowHeight / length) * deltaX + destPt1.getX();
                double arrowY = (1.0 - arrowHeight / length) * deltaY + destPt1.getY();
                double notchX = 0.15 * (arrowHeight / length) * deltaX + arrowX;
                double notchY = 0.15 * (arrowHeight / length) * deltaY + arrowY;
                pt1 = posVC.destToVirt(destPt1);
                pt2 = posVC.destToVirt(new Point((int)notchX, (int)notchY));
                IdentObj idLineRiser = new IdentObj(258, s, g);
                new DetLine(this.m_Detectiv, idLineRiser, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, this.m_rClip, lineWidth, lineStyle);
                if (length <= 0.0) continue;
                double xDiff = Math.abs(arrowHalfWidth * deltaY / length);
                double yDiff = Math.abs(arrowHalfWidth * deltaX / length);
                if (deltaX > 0.0) {
                    if (deltaY > 0.0) {
                        right = new Point2D.Double(arrowX - xDiff, arrowY + yDiff);
                        left = new Point2D.Double(arrowX + xDiff, arrowY - yDiff);
                    } else {
                        right = new Point2D.Double(arrowX + xDiff, arrowY + yDiff);
                        left = new Point2D.Double(arrowX - xDiff, arrowY - yDiff);
                    }
                } else if (deltaY > 0.0) {
                    right = new Point2D.Double(arrowX - xDiff, arrowY - yDiff);
                    left = new Point2D.Double(arrowX + xDiff, arrowY + yDiff);
                } else {
                    right = new Point2D.Double(arrowX + xDiff, arrowY - yDiff);
                    left = new Point2D.Double(arrowX - xDiff, arrowY + yDiff);
                }
                Path2D.Double arrow = new Path2D.Double();
                ((Path2D)arrow).moveTo(((Point2D)left).getX(), ((Point2D)left).getY());
                ((Path2D)arrow).lineTo(destPt2.getX(), destPt2.getY());
                ((Path2D)arrow).lineTo(((Point2D)right).getX(), ((Point2D)right).getY());
                ((Path2D)arrow).lineTo(notchX, notchY);
                arrow.closePath();
                new DetShape(this.m_Detectiv, idLineRiser, blackBox, new Area(arrow)).clipRect(this.m_rClip);
            }
        }
    }

    public String getDataLabel(int s, int g) {
        return this.m_DataLabel[s][g];
    }
}

