/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class PieLabel
extends BaseText {
    @Concealed
    protected String m_text = "";
    @Concealed
    protected String text = "";

    @Concealed
    public PieLabel(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getPieLabel();
    }

    @Override
    public boolean selectObject(int series, int group) {
        if (group >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            identObj.setGroupID(group);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String str) {
        if (str == null) {
            this.m_commonGraph.getErrorHandler().log("invalid text", this.getClass().toString(), "setText");
            return;
        }
        this.m_text = str;
        this.m_pfj.setPieBarLabelString(str);
        this.m_pfj.setDisplay(this.m_identObj, true);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "PieLabel";
    }

    @Override
    @Concealed
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        String val = this.m_pfj.getPieBarLabelString();
        if (val != null) {
            node.addProperty("text", val);
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        PropertyNode pNode = node.getProperty("text");
        if (pNode != null) {
            this.setText(pNode.getValueAsString());
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            this.setVisible(pNode.getValueAsBoolean());
        }
    }

    @Override
    @Concealed
    protected void resetStyle() {
        this.m_pfj.setDisplay(this.m_identObj, true);
        super.resetStyle();
    }
}

