/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.presutil.GradientSupport;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@CodeSharingSafe(value="StaticInitializer")
public class SFX
extends BaseComponentXML
implements GradientSupport {
    @Concealed
    protected CommonGauge m_commonGauge;
    @Concealed
    private String m_compKey;
    @Concealed
    private boolean m_depDirection = false;
    public static final HashMap DEFAULT_MAP = new HashMap(7);
    private int m_index = -1;

    @Concealed
    public SFX(CommonGauge gauge, int compID) {
        this.m_commonGauge = gauge;
        if (compID == 23) {
            this.m_compKey = "GaugeSetBackgroundSFX";
        } else if (compID == 10) {
            this.m_compKey = "BackgroundSFX";
        } else if (compID == 24) {
            this.m_compKey = "GaugeFrameSFX";
        } else if (compID == 11) {
            this.m_compKey = "PlotAreaSFX";
        } else if (compID == 25) {
            this.m_compKey = "UpLblFrameSFX";
        } else if (compID == 26) {
            this.m_compKey = "LowLblFrameSFX";
        } else if (compID == 14) {
            this.m_compKey = "IndicatorSFX";
        } else if (compID == 15) {
            this.m_compKey = "ThresholdSFX";
        } else if (compID == 27) {
            this.m_compKey = "LegendAreaSFX";
        } else if (compID == 19) {
            this.m_compKey = "ElementASFX";
        } else if (compID == 20) {
            this.m_compKey = "ElementBSFX";
        } else if (compID == 21) {
            this.m_compKey = "IntersectionABSFX";
        } else if (compID == 30) {
            this.m_compKey = "IndicatorBaseSFX";
        } else if (compID == 31) {
            this.m_compKey = "IndicatorBarSFX";
        }
    }

    @Concealed
    public SFX(CommonGauge gauge, int compID, int index) {
        this(gauge, compID);
        this.m_index = index;
    }

    @Override
    public int getFillType() {
        Integer fillType;
        int type = GaugeDefaultValues.getFillType();
        HashMap map = this.getAttributeMap();
        if (map != null && (fillType = (Integer)map.get("SFX_FILL_TYPE")) != null) {
            type = fillType;
        }
        return type;
    }

    @Override
    public void setFillType(int type) {
        if (type < 1 || type > 2) {
            this.m_commonGauge.getErrorHandler().log("invalid fill type", this.getClass().getName(), "setFillType(int type)");
        } else {
            this._setNewValue("SFX_FILL_TYPE", type);
        }
    }

    @Override
    public int getGradientDirection() {
        Integer gradDir;
        int direction = GaugeDefaultValues.getGradientDirection();
        HashMap map = this.getAttributeMap();
        if (map != null && (gradDir = (Integer)map.get("SFX_GRADIENT_DIRECTION")) != null) {
            direction = gradDir;
        }
        return direction;
    }

    @Override
    public void setGradientDirection(int dir) {
        if (dir != 3 && dir != 1 && dir != 5 && dir != 7 && dir != 9 && dir != 10 && dir != 11 && dir != 12 && dir != 13 && dir != 14) {
            this.m_commonGauge.getErrorHandler().log("invalid gradient direction", this.getClass().getName(), "setGradientDirection(int dir)");
            return;
        }
        switch (dir) {
            case 12: 
            case 13: {
                this.m_depDirection = true;
                break;
            }
            default: {
                this.m_depDirection = false;
            }
        }
        this._setNewValue("SFX_GRADIENT_DIRECTION", dir);
    }

    public int getVisualEffects() {
        Integer vfx;
        int visualEffects = 1;
        HashMap map = this.getAttributeMap();
        if (map != null && (vfx = (Integer)map.get("SFX_VISUAL_EFFECTS")) != null) {
            visualEffects = vfx;
        }
        return visualEffects;
    }

    public void setVisualEffects(int vfx) {
        if (vfx > 15 || vfx < 0) {
            this.m_commonGauge.getErrorHandler().log("invalid visual effects", this.getClass().getName(), "setVisualEffects(int vfx)");
            return;
        }
        this._setNewValue("SFX_VISUAL_EFFECTS", vfx);
    }

    @Override
    public Color getGradientStopColor(int index) {
        ArrayList clrList;
        if (index < 0) {
            this.m_commonGauge.getErrorHandler().log("invalid stop index", this.getClass().getName(), "getGradientStopColor(int index)");
            return null;
        }
        Color clr = null;
        HashMap map = this.getAttributeMap();
        if (map != null && ((clrList = (ArrayList)map.get("SFX_STOP_COLORS")) != null || index < clrList.size())) {
            clr = (Color)clrList.get(index);
        }
        if (clr == null) {
            clr = new Color(PresUtils.hexStringWithAlphaToInt(GaugeDefaultValues.getGradientStopColor()));
        }
        return clr;
    }

    @Override
    public void setGradientStopColor(Color newColor, int index) {
        if (newColor == null) {
            this.m_commonGauge.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGradientStopColor(Color newColor, int index)");
            return;
        }
        if (index < 0) {
            this.m_commonGauge.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopColor(Color newColor, int index)");
            return;
        }
        HashMap map = this.getAttributeMap();
        Object oldValue = null;
        ArrayList clrList = (ArrayList)map.get("SFX_STOP_COLORS");
        if (index >= clrList.size()) {
            for (int i = clrList.size(); i < index; ++i) {
                clrList.add(GaugeDefaultValues.getGradientStopColor());
            }
            clrList.add(newColor);
        } else {
            oldValue = clrList.get(index);
            clrList.set(index, newColor);
        }
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, "SFX_STOP_COLORS", oldValue, newColor);
    }

    @Override
    public double getGradientStopPosition(int index) {
        if (index < 0) {
            this.m_commonGauge.getErrorHandler().log("invalid stop index", this.getClass().getName(), "getGradientStopPosition(int index)");
            return 0.0;
        }
        double pos = GaugeDefaultValues.getGradientStopPosition();
        HashMap map = this.getAttributeMap();
        if (map == null) {
            return pos;
        }
        ArrayList posList = (ArrayList)map.get("SFX_STOP_POSITIONS");
        if (posList != null || index < posList.size()) {
            pos = (Double)posList.get(index);
        }
        return 100.0 * pos;
    }

    @Override
    public void setGradientStopPosition(double newPos, int index) {
        if (index < 0) {
            this.m_commonGauge.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        if (newPos < 0.0 || newPos > 100.0) {
            this.m_commonGauge.getErrorHandler().log("invalid stop Position", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        Double value = newPos / 100.0;
        HashMap map = this.getAttributeMap();
        Object oldValue = null;
        ArrayList posList = (ArrayList)map.get("SFX_STOP_POSITIONS");
        if (index >= posList.size()) {
            for (int i = posList.size(); i < index; ++i) {
                posList.add(GaugeDefaultValues.getGradientStopPosition());
            }
            posList.add(value);
        } else {
            oldValue = posList.get(index);
            posList.set(index, value);
        }
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, "SFX_STOP_POSITIONS", oldValue, value);
    }

    @Override
    public int getGradientNumStops() {
        Integer numStopObj;
        int numStops = GaugeDefaultValues.getGradientNumStops();
        HashMap map = this.getAttributeMap();
        if (map != null && (numStopObj = (Integer)map.get("SFX_NUM_STOPS")) != null) {
            numStops = numStopObj;
        }
        return numStops;
    }

    @Override
    public void setGradientNumStops(int numStops) {
        if (numStops < 2) {
            this.m_commonGauge.getErrorHandler().log("invalid number of stops", this.getClass().getName(), "setGradientNumStops(int numStops)");
            return;
        }
        HashMap map = this.getAttributeMap();
        int oldNumStops = (Integer)map.get("SFX_NUM_STOPS");
        this._setNewValue("SFX_NUM_STOPS", numStops);
        if (numStops == oldNumStops) {
            return;
        }
        ArrayList clrList = (ArrayList)map.get("SFX_STOP_COLORS");
        ArrayList posList = (ArrayList)map.get("SFX_STOP_POSITIONS");
        if (numStops > oldNumStops) {
            for (int i = oldNumStops; i < numStops; ++i) {
                clrList.add(new Color(PresUtils.hexStringWithAlphaToInt(GaugeDefaultValues.getGradientStopColor())));
                posList.add(GaugeDefaultValues.getGradientStopPosition());
            }
        } else {
            for (int i = oldNumStops - 1; i == numStops; --i) {
                clrList.remove(i);
                posList.remove(i);
            }
        }
    }

    public boolean isGradientReversed() {
        Boolean revObj;
        boolean reversed = GaugeDefaultValues.getGradientReversed();
        HashMap map = this.getAttributeMap();
        if (map != null && (revObj = (Boolean)map.get("SFX_GRADIENT_REVERSED")) != null) {
            reversed = revObj;
        }
        return reversed;
    }

    @Override
    public void setGradientReversed(boolean reverse) {
        this._setNewValue("SFX_GRADIENT_REVERSED", reverse);
    }

    @Concealed
    public static int convertGradientFillTypeToInt(String type) {
        int iType = GaugeDefaultValues.getFillType();
        if (type.equals("FT_COLOR")) {
            iType = 1;
        } else if (type.equals("FT_GRADIENT")) {
            iType = 2;
        } else if (type.equals("FT_TEXTURE")) {
            iType = 3;
        }
        return iType;
    }

    @Concealed
    public static String convertGradientFillTypeToString(int fillType) {
        switch (fillType) {
            case 1: {
                return "FT_COLOR";
            }
            case 2: {
                return "FT_GRADIENT";
            }
            case 3: {
                return "FT_TEXTURE";
            }
        }
        return null;
    }

    @Concealed
    public static int convertGradientDirectionToInt(String dir) {
        int iDir = GaugeDefaultValues.getGradientDirection();
        if (dir.equals("GD_DOWN")) {
            iDir = 3;
        } else if (dir.equals("GD_RIGHT")) {
            iDir = 1;
        } else if (dir.equals("GD_DIAGONAL_45")) {
            iDir = 5;
        } else if (dir.equals("GD_DIAGONAL_135")) {
            iDir = 7;
        } else if (dir.equals("GD_RADIAL")) {
            iDir = 9;
        } else if (dir.equals("GD_RADIAL_TOP_LEFT")) {
            iDir = 10;
        } else if (dir.equals("GD_RADIAL_TOP_RIGHT")) {
            iDir = 11;
        } else if (dir.equals("GD_RADIAL_BOTTOM_LEFT")) {
            iDir = 12;
        } else if (dir.equals("GD_RADIAL_BOTTOM_RIGHT")) {
            iDir = 13;
        } else if (dir.equals("GD_RADIAL_OFF_CENTER")) {
            iDir = 14;
        }
        return iDir;
    }

    @Concealed
    public static String convertGradientDirectionToString(int direction) {
        switch (direction) {
            case 1: {
                return "GD_RIGHT";
            }
            case 3: {
                return "GD_DOWN";
            }
            case 5: {
                return "GD_DIAGONAL_45";
            }
            case 7: {
                return "GD_DIAGONAL_135";
            }
            case 9: {
                return "GD_RADIAL";
            }
            case 10: {
                return "GD_RADIAL_TOP_LEFT";
            }
            case 11: {
                return "GD_RADIAL_TOP_RIGHT";
            }
            case 12: {
                return "GD_RADIAL_BOTTOM_LEFT";
            }
            case 13: {
                return "GD_RADIAL_BOTTOM_RIGHT";
            }
            case 14: {
                return "GD_RADIAL_OFF_CENTER";
            }
        }
        return null;
    }

    @Concealed
    public static int convertVisualEffectsToInt(String vfxString) {
        if (vfxString == null) {
            return 1;
        }
        int vfx = 0;
        if (vfxString.contains("AUTO")) {
            ++vfx;
        }
        if (vfxString.contains("SHADOW")) {
            vfx += 2;
        }
        if (vfxString.contains("BEVEL")) {
            vfx += 4;
        }
        if (vfxString.contains("GLOW")) {
            vfx += 8;
        }
        return vfx;
    }

    @Concealed
    public static String convertVisualEffectsToString(int vfx) {
        StringBuilder sb = new StringBuilder();
        if (vfx == 0) {
            return "NONE";
        }
        if ((vfx | 1) > 0) {
            sb.append("AUTO ");
        }
        if ((vfx | 2) > 0) {
            sb.append("SHADOW ");
        }
        if ((vfx | 4) > 0) {
            sb.append("BEVEL ");
        }
        if ((vfx | 8) > 0) {
            sb.append("GLOW ");
        }
        return sb.toString();
    }

    private void _setNewValue(String name, Object value) {
        HashMap map = this.getAttributeMap();
        Object oldValue = map.get(name);
        map.put(name, value);
        this.m_commonGauge.setRecalcState(1);
        this.m_commonGauge.firePropertyChange(this, name, oldValue, value);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "SFX";
    }

    @Concealed
    protected ObjectNode getGradientStopStyleXML(boolean allProperties, int stopIndex) {
        Color col;
        Double val;
        ObjectNode node = new ObjectNode("GradientStopStyle");
        boolean nodeExists = false;
        node.addProperty("stopIndex", stopIndex);
        HashMap map = this.getAttributeMapNoDefault();
        if (map == null) {
            return null;
        }
        ArrayList posList = (ArrayList)map.get("SFX_STOP_POSITIONS");
        ArrayList defPosList = (ArrayList)DEFAULT_MAP.get("SFX_STOP_POSITIONS");
        if (posList != null && !defPosList.equals(posList) && stopIndex < posList.size() && (val = (Double)posList.get(stopIndex)) != null) {
            node.addProperty("gradientStopPosition", 100.0 * val);
            nodeExists = true;
        }
        ArrayList clrList = (ArrayList)map.get("SFX_STOP_COLORS");
        ArrayList defClrList = (ArrayList)DEFAULT_MAP.get("SFX_STOP_COLORS");
        if (clrList != null && !defClrList.equals(clrList) && stopIndex < clrList.size() && (col = (Color)clrList.get(stopIndex)) != null) {
            node.addProperty("gradientStopColor", PresUtils.toHexStringWithAlpha(col.getRGB()));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Concealed
    protected ContainerNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        String dir;
        int tmp;
        String fillType;
        ContainerNode node = new ContainerNode(this.getComponentName());
        boolean nodeExists = false;
        HashMap map = this.getAttributeMapNoDefault();
        if (map == null) {
            return null;
        }
        Object val = map.get("SFX_FILL_TYPE");
        if (val != null && (Integer)val != GaugeDefaultValues.getFillType() && (fillType = SFX.convertGradientFillTypeToString(tmp = ((Integer)val).intValue())) != null) {
            node.addProperty("fillType", fillType);
            nodeExists = true;
        }
        if ((val = map.get("SFX_GRADIENT_DIRECTION")) != null && (Integer)val != GaugeDefaultValues.getGradientDirection() && (dir = SFX.convertGradientDirectionToString(tmp = ((Integer)val).intValue())) != null) {
            node.addProperty("gradientDirection", dir);
            nodeExists = true;
        }
        if ((val = map.get("SFX_VISUAL_EFFECTS")) != null && (Integer)val != 1 && (dir = SFX.convertVisualEffectsToString(tmp = ((Integer)val).intValue())) != null) {
            node.addProperty("visualEffects", dir);
            nodeExists = true;
        }
        if ((val = map.get("SFX_NUM_STOPS")) != null && (Integer)val != GaugeDefaultValues.getGradientNumStops()) {
            node.addProperty("gradientNumStops", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = map.get("SFX_GRADIENT_REVERSED")) != null && (Boolean)val != GaugeDefaultValues.getGradientReversed()) {
            node.addProperty("gradientReversed", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        for (int i = 0; i < this.getGradientNumStops(); ++i) {
            ObjectNode subNode = this.getGradientStopStyleXML(allProperties, i);
            if (subNode == null) continue;
            node.addContainedObject((BaseNode)subNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Concealed
    protected void setXML(ContainerNode node, boolean allProperties) {
        String tmp;
        PropertyNode pNode = node.getProperty("fillType");
        if (pNode != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("FT_COLOR")) {
                this.setFillType(1);
            } else if (tmp.equals("FT_GRADIENT")) {
                this.setFillType(2);
            } else if (tmp.equals("FT_TEXTURE")) {
                this.setFillType(3);
            }
        }
        if ((pNode = node.getProperty("gradientDirection")) != null) {
            tmp = pNode.getValueAsString();
            if (tmp.equals("GD_RIGHT")) {
                this.setGradientDirection(1);
            } else if (tmp.equals("GD_DOWN")) {
                this.setGradientDirection(3);
            } else if (tmp.equals("GD_RADIAL_TOP_LEFT")) {
                this.setGradientDirection(10);
            } else if (tmp.equals("GD_RADIAL_BOTTOM_LEFT")) {
                this.setGradientDirection(12);
            } else if (tmp.equals("GD_RADIAL_BOTTOM_RIGHT")) {
                this.setGradientDirection(13);
            } else if (tmp.equals("GD_RADIAL_TOP_RIGHT")) {
                this.setGradientDirection(11);
            } else if (tmp.equals("GD_RADIAL")) {
                this.setGradientDirection(9);
            } else if (tmp.equals("GD_DIAGONAL_45")) {
                this.setGradientDirection(5);
            } else if (tmp.equals("GD_DIAGONAL_135")) {
                this.setGradientDirection(7);
            } else if (tmp.equals("GD_RADIAL_OFF_CENTER")) {
                this.setGradientDirection(14);
            }
        }
        if ((pNode = node.getProperty("visualEffects")) != null) {
            tmp = pNode.getValueAsString();
            int vfx = SFX.convertVisualEffectsToInt(tmp);
            this.setVisualEffects(vfx);
        }
        if ((pNode = node.getProperty("gradientNumStops")) != null) {
            this.setGradientNumStops(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("gradientReversed")) != null) {
            this.setGradientReversed(pNode.getValueAsBoolean());
        }
        Enumeration ssNodes = node.getContainerNodes("GradientStopStyle");
        while (ssNodes.hasMoreElements()) {
            ContainerNode ssNode = (ContainerNode)ssNodes.nextElement();
            PropertyNode sNode = ssNode.getProperty("stopIndex");
            if (sNode == null) continue;
            int stopIndex = sNode.getValueAsInteger();
            pNode = ssNode.getProperty("gradientStopPosition");
            if (pNode != null) {
                this.setGradientStopPosition(pNode.getValueAsDouble(), stopIndex);
            }
            if ((pNode = ssNode.getProperty("gradientStopColor")) == null) continue;
            this.setGradientStopColor(DataviewUtils.hexStringToColor(pNode.getValueAsString()), stopIndex);
        }
    }

    @Concealed
    protected Point2D getGradientCenter() {
        Point2D center = null;
        HashMap map = this.getAttributeMap();
        if (map != null) {
            center = (Point2D)map.get("SFX_GRADIENT_CENTER");
        }
        return center;
    }

    @Concealed
    protected void setGradientCenter(Point2D point) {
        this._setNewValue("SFX_GRADIENT_CENTER", point);
    }

    protected HashMap getAttributeMapNoDefault() {
        HashMap map = null;
        if (this.m_compKey.equals("GaugeSetBackgroundSFX") || this.m_compKey.equals("LegendAreaSFX")) {
            map = (HashMap)this.m_commonGauge.getGaugeSetAttribute(this.m_compKey);
        } else if (this.m_index == -1) {
            map = (HashMap)this.m_commonGauge.getAttribute(this.m_compKey);
        } else {
            ArrayList list = (ArrayList)this.m_commonGauge.getAttribute(this.m_compKey);
            if (list != null && list.size() > this.m_index) {
                map = (HashMap)list.get(this.m_index);
            }
        }
        return map;
    }

    protected HashMap getAttributeMap() {
        HashMap map = this.getAttributeMapNoDefault();
        if (map == null) {
            map = SFX.cloneDefaultMap();
            if (this.m_compKey.equals("GaugeSetBackgroundSFX") || this.m_compKey.equals("LegendAreaSFX")) {
                this.m_commonGauge.setGaugeSetAttribute(this.m_compKey, map);
            } else if (this.m_index == -1) {
                this.m_commonGauge.setAttribute(this.m_compKey, map);
            } else {
                ArrayList<HashMap> list = (ArrayList<HashMap>)this.m_commonGauge.getAttribute(this.m_compKey);
                if (list == null) {
                    list = new ArrayList<HashMap>();
                    this.m_commonGauge.setAttribute(this.m_compKey, list);
                }
                if (list.size() <= this.m_index) {
                    for (int i = list.size(); i <= this.m_index; ++i) {
                        list.add(null);
                    }
                }
                list.set(this.m_index, map);
            }
        }
        return map;
    }

    public static HashMap cloneDefaultMap() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(DEFAULT_MAP);
            byte[] buf = baos.toByteArray();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            HashMap newMap = (HashMap)ois.readObject();
            ois.close();
            return newMap;
        }
        catch (Exception e) {
            return (HashMap)DEFAULT_MAP.clone();
        }
    }

    static {
        DEFAULT_MAP.put("SFX_FILL_TYPE", GaugeDefaultValues.getFillType());
        DEFAULT_MAP.put("SFX_GRADIENT_DIRECTION", GaugeDefaultValues.getGradientDirection());
        DEFAULT_MAP.put("SFX_GRADIENT_REVERSED", GaugeDefaultValues.getGradientReversed());
        DEFAULT_MAP.put("SFX_NUM_STOPS", GaugeDefaultValues.getGradientNumStops());
        ArrayList<Serializable> stopArray = new ArrayList<Serializable>(GaugeDefaultValues.getGradientNumStops());
        stopArray.add(Double.valueOf(0.0));
        stopArray.add(Double.valueOf(1.0));
        DEFAULT_MAP.put("SFX_STOP_POSITIONS", stopArray);
        stopArray = new ArrayList(GaugeDefaultValues.getGradientNumStops());
        stopArray.add(new Color(PresUtils.hexStringWithAlphaToInt(GaugeDefaultValues.getGradientStopColor())));
        stopArray.add(new Color(PresUtils.hexStringWithAlphaToInt(GaugeDefaultValues.getGradientStopColor())));
        DEFAULT_MAP.put("SFX_STOP_COLORS", stopArray);
    }
}

