/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import oracle.security.crypto.cms.CMSCompressedDataContentInfo;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.smime.BodyPartUpdater;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.SmimeObject;
import oracle.security.crypto.smime.SmimeUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class SmimeCompressed
implements SmimeObject {
    private CMSCompressedDataContentInfo ed;

    SmimeCompressed(CMSCompressedDataContentInfo ed) {
        this.ed = ed;
    }

    public SmimeCompressed(MimeBodyPart content) throws MessagingException, IOException {
        this(content, Smime.id_alg_zlibCompress);
    }

    public SmimeCompressed(MimeBodyPart content, AlgorithmIdentifier contentCompressionAlgID) throws MessagingException, IOException {
        if (content == null) {
            throw new InvalidInputException("message content is empty");
        }
        if (!contentCompressionAlgID.equals((Object)Smime.id_alg_zlibCompress)) {
            throw new InvalidInputException("unsupported compression algorithm: " + contentCompressionAlgID);
        }
        new BodyPartUpdater(content);
        byte[] dc = SmimeUtils.toBytes(content);
        if (dc == null || dc.length < 1) {
            throw new InvalidInputException("message content is empty");
        }
        try {
            this.ed = new CMSCompressedDataContentInfo((CMSContentInfo)new CMSDataContentInfo(dc), contentCompressionAlgID);
        }
        catch (AlgorithmIdentifierException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public SmimeCompressed(InputStream is) throws IOException {
        this.ed = new CMSCompressedDataContentInfo(is);
    }

    CMSCompressedDataContentInfo getCD() {
        return this.ed;
    }

    public MimeBodyPart getEnclosedBodyPart() throws AlgorithmIdentifierException, InvalidInputException, MessagingException {
        CMSDataContentInfo data;
        try {
            data = (CMSDataContentInfo)this.ed.getEnclosed();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException("Content-type 'data' expected");
        }
        return new MimeBodyPart((InputStream)new UnsyncByteArrayInputStream(data.getData()));
    }

    public AlgorithmIdentifier getContentCompressionAlgID() {
        return this.ed.getCompressionAlgID();
    }

    @Override
    public String generateContentType(boolean useStandardContentTypes) {
        if (useStandardContentTypes) {
            return "application/pkcs7-mime; smime-type=compressed-data; name=\"smime.p7m\"";
        }
        return "application/x-pkcs7-mime; smime-type=compressed-data; name=\"smime.p7m\"";
    }

    @Override
    public String generateContentType() {
        return this.generateContentType(true);
    }

    @Override
    public void writeTo(OutputStream os, String mimeType) throws IOException, MessagingException {
        this.ed.output(os);
    }
}

