/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.net;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.dba.navigator.Messages;
import oracle.dbtools.raptor.dba.navigator.net.DBAURLStreamHandlerFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

public class DBAURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String DBA_PROTOCOL = "sqldev.dbanav";

    public Icon getDefaultIcon(URL uRL) {
        return super.getDefaultIcon(uRL);
    }

    public Icon getSystemIcon(URL uRL) {
        return super.getSystemIcon(uRL);
    }

    public boolean isReadOnly(URL uRL) {
        return !this.canWrite(uRL);
    }

    public boolean canRead(URL uRL) {
        return true;
    }

    public boolean canWrite(URL uRL) {
        boolean bl;
        String string = DBURLFormatHelper.getBaseType((URL)uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string)) {
            bl = false;
            Database database = DBAURLFileSystemHelper.getDatabase(uRL);
            if (database != null) {
                try {
                    String string2 = DBURLFormatHelper.getSchema((URL)uRL);
                    Schema schema = database.getSchema(string2);
                    bl = database.hasPriviledge("PROCEDURE", schema, "MODIFY");
                }
                catch (DBException dBException) {}
            }
        } else {
            bl = "XML SCHEMA".equals(string) ? true : true;
        }
        return bl;
    }

    private static Database getDatabase(URL uRL) {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName((URL)uRL), false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    public boolean exists(URL uRL) {
        String string = DBURLFormatHelper.getBaseType((URL)uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = DBURLFormatHelper.getConnectionName((URL)uRL);
            try {
                Connection connection = Connections.getInstance().getConnection(string2, false);
                return connection != null;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    public Reader createReader(URL uRL, String string) throws IOException {
        char[] cArray;
        Reader reader = null;
        if ((DBAURLStreamHandlerFactory.isOracleSource(uRL) || DBAURLStreamHandlerFactory.isOracleTimesTenSource(uRL)) && (cArray = DBAURLStreamHandlerFactory.fetchSource(uRL)) != null) {
            reader = new CharBufferReader(cArray);
        }
        return reader != null ? reader : super.createReader(uRL, string);
    }

    public String getPlatformPathName(URL uRL) {
        return ObjectNode.getDefaultLongDisplay((URL)uRL, null);
    }

    public long lastModified(URL uRL) {
        String string = DBURLFormatHelper.getBaseType((URL)uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = DBURLFormatHelper.getSchema((URL)uRL);
            String string3 = DBURLFormatHelper.getName((URL)uRL);
            Database database = DBAURLFileSystemHelper.getDatabase(uRL);
            if (database != null) {
                try {
                    Long l = database.getTimestamp(string, database.getSchema(string2), string3);
                    if (l != null) {
                        return l;
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return -1L;
    }

    public String toDisplayString(URL uRL) {
        return super.toDisplayString(uRL);
    }

    private static class CharBufferReader
    extends Reader {
        private int m_pos;
        private char[] m_buf;

        private CharBufferReader(char[] cArray) {
            assert (cArray != null);
            this.m_buf = cArray;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.m_pos == -1) {
                throw new IOException(Messages.getString("DBAURLFileSystemHelper.1"));
            }
            int n3 = Math.min(n2, this.m_buf.length - this.m_pos);
            if (n3 == 0) {
                return -1;
            }
            System.arraycopy(this.m_buf, this.m_pos, cArray, n, n3);
            this.m_pos += n3;
            return n3;
        }

        @Override
        public void close() {
            this.m_pos = -1;
        }
    }
}

