/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.javafx.ui.JFXPanelFactory;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public abstract class PerformanceReport {
    public static boolean USE_FX_WEBVIEW = Boolean.getBoolean("use.fx.webview");
    protected Connection conn;
    private Toolbar toolbar;
    private JPanel panel;
    private boolean generateEnabled;
    private boolean saveToFileEnabled;
    private boolean openInBrowserEnabled;
    private ReportPane reportPane;
    private File tempReportFile;
    private JPanel configurationPanel;
    private HyperlinkListener hyperlinkListener;
    private boolean canToggleInputs;
    private boolean openInBrowserSupported;
    private JScrollPane contentScrollPane;
    private boolean multiInstance;
    private String defaultInstance;
    private boolean multiDbId;
    private String defaultDbId;
    private boolean dbSupportsGlobal;

    public PerformanceReport(Connection connection, Toolbar toolbar) {
        this.conn = connection;
        this.toolbar = toolbar;
        this.querySupportsGlobal(connection);
        this.queryIdInfo(connection);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PerformanceReport.this.hyperlinkListener = new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            PerformanceReport.this.reportPane.scrollToReference(hyperlinkEvent.getURL().getRef());
                        }
                    }
                };
                PerformanceReport.this.openInBrowserSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryIdInfo(Connection connection) {
        block8: {
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap hashMap = new HashMap();
                    resultSet = dBUtil.executeOracleQuery(Utils.getQuery(this.getClass(), (Connection)connection, (String)"getIDInfo"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.multiDbId = resultSet.getInt(1) > 1;
                            this.defaultDbId = resultSet.getString(2);
                            this.multiInstance = resultSet.getInt(3) > 1;
                            this.defaultInstance = resultSet.getString(4);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void querySupportsGlobal(Connection connection) {
        try {
            int n = connection.getMetaData().getDatabaseMajorVersion();
            int n2 = connection.getMetaData().getDatabaseMinorVersion();
            this.dbSupportsGlobal = n > 11 || n == 11 && n2 >= 2;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public void initUI(JPanel jPanel) {
        this.panel = jPanel;
        this.setupAccelerators(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.configurationPanel = this.createConfigurePanel();
        jPanel2.add((Component)this.configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JComponent jComponent = this.createContentComponent();
        jComponent.setBorder(new LineBorder(Color.LIGHT_GRAY));
        jPanel2.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.contentScrollPane = new JScrollPane();
        this.contentScrollPane.setViewportView(jPanel2);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.contentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean canToggleInputs() {
        return this.canToggleInputs;
    }

    public boolean canGenerateReport() {
        return this.generateEnabled;
    }

    public boolean canSaveToFile() {
        return this.saveToFileEnabled;
    }

    public boolean canOpenInBrowser() {
        return this.openInBrowserEnabled;
    }

    public void toggleInputs() {
        if (this.canToggleInputs) {
            boolean bl = this.configurationPanel.isVisible();
            if (bl) {
                this.configurationPanel.setVisible(false);
            } else {
                this.configurationPanel.setVisible(true);
                this.contentScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        }
    }

    public void generateReport() {
        this.saveToFileEnabled = false;
        this.openInBrowserEnabled = false;
        this.refreshToolbar();
        this.reportPane.removeHyperlinkListener(this.hyperlinkListener);
        this.reportPane.setText("<tt>" + DisplayArb.getString("PERF_GENERATING") + "</tt>");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DisplayArb.getString("PERF_GENERATING_REPORT"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                try {
                    PerformanceReport.this.tempReportFile = File.createTempFile("SQLDEV_PERF_REPORT", ".html");
                    boolean bl = false;
                    try (FileWriter fileWriter = new FileWriter(PerformanceReport.this.tempReportFile);){
                        bl = PerformanceReport.this.writeReport(fileWriter);
                    }
                    final boolean bl2 = bl;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (bl2) {
                                    PerformanceReport.this.reportPane.setPage(PerformanceReport.this.tempReportFile.toURI().toURL());
                                    PerformanceReport.this.reportPane.addHyperlinkListener(PerformanceReport.this.hyperlinkListener);
                                    PerformanceReport.this.canToggleInputs = true;
                                    PerformanceReport.this.saveToFileEnabled = true;
                                    if (PerformanceReport.this.openInBrowserSupported) {
                                        PerformanceReport.this.openInBrowserEnabled = true;
                                    }
                                    PerformanceReport.this.refreshToolbar();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            PerformanceReport.this.setInputsVisible(false);
                                        }
                                    });
                                } else {
                                    PerformanceReport.this.reportPane.setText("");
                                }
                            }
                            catch (IOException iOException) {
                                oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)iOException);
                            }
                        }
                    });
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        oracle.dbtools.util.Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                    }
                }
                catch (IOException iOException) {
                    throw new TaskException((Throwable)iOException);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(DisplayArb.getString("PERF_HTML_FILES"), ".html"));
        uRLFileChooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(DisplayArb.getString("PERF_ALL_FILES")));
        uRLFileChooser.setFileSelectionMode(0);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), DisplayArb.getString("PERF_SAVE_REPORT_TO_FILE"));
        String string = null;
        if (n == 0) {
            string = uRLFileChooser.getSelectedFile().toString();
            try (FileWriter fileWriter = new FileWriter(string);
                 BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tempReportFile));){
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    fileWriter.write(string2 + "\n");
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)iOException);
                MessageDialog.error((Component)this.panel, (Object)DisplayArb.getString("PERF_UNABLE_TO_SAVE_FILE"), (String)DisplayArb.getString("PERF_ERROR"), null);
            }
        }
    }

    public void openInBrowser() {
        try {
            Desktop.getDesktop().browse(this.tempReportFile.toURI());
        }
        catch (Exception exception) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)exception);
            MessageDialog.error((Component)this.panel, (Object)DisplayArb.getString("PERF_UNABLE_TO_OPEN_IN_BROWER"), (String)DisplayArb.getString("PERF_ERROR"), null);
        }
    }

    protected boolean dbSupportsGlobal() {
        return this.dbSupportsGlobal;
    }

    protected boolean isMultiInstance() {
        return this.multiInstance;
    }

    protected String defaultInstance() {
        return this.defaultInstance;
    }

    protected boolean isMultiDbId() {
        return this.multiDbId;
    }

    protected String defaultDbId() {
        return this.defaultDbId;
    }

    protected void enableGenerate(boolean bl) {
        this.generateEnabled = bl;
        this.refreshToolbar();
    }

    protected abstract JPanel createConfigurePanel();

    protected abstract boolean writeReport(Writer var1);

    private void setInputsVisible(boolean bl) {
        this.configurationPanel.setVisible(bl);
    }

    private JComponent createContentComponent() {
        this.reportPane = new ReportPane();
        return this.reportPane;
    }

    private void refreshToolbar() {
        View.updateToolbarActions((Toolbar)this.toolbar);
    }

    private void setupAccelerators(JPanel jPanel) {
        try {
            InputMap inputMap = jPanel.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 192, false);
            Object object = inputMap.get(keyStroke);
            InputMap inputMap2 = new InputMap();
            inputMap2.put(keyStroke, object);
            UIUtils.addIdeKeyBindings((JComponent)jPanel, (int)1, (String)"oracle/dbtools/raptor/dba/navigator/accelerators.xml", (InputMap)inputMap2);
            UIUtils.setupAccelerators((Toolbar)this.toolbar, (String)"oracle/dbtools/raptor/dba/navigator/accelerators.xml");
        }
        catch (Exception exception) {
            oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private class ReportPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        Browser browser;
        JEditorPane reportPane;

        public ReportPane() {
            this.setLayout(new BorderLayout());
            if (USE_FX_WEBVIEW) {
                JFXPanel jFXPanel = JFXPanelFactory.createJFXPanel();
                Platform.runLater(() -> {
                    this.browser = new Browser();
                    jFXPanel.setScene(SceneFactory.createScene((Parent)this.browser));
                    SwingUtilities.invokeLater(() -> this.add((Component)jFXPanel, "Center"));
                });
            } else {
                this.reportPane = new JEditorPane("text/html", "");
                this.reportPane.setEditable(false);
                this.reportPane.addHyperlinkListener(PerformanceReport.this.hyperlinkListener);
                this.reportPane.putClientProperty("JEditorPane.w3cLengthUnits", true);
                this.add((Component)this.reportPane, "Center");
            }
        }

        public void scrollToReference(String string) {
            if (!USE_FX_WEBVIEW) {
                this.reportPane.scrollToReference(string);
            }
        }

        public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
            if (!USE_FX_WEBVIEW) {
                this.reportPane.removeHyperlinkListener(hyperlinkListener);
            }
        }

        public void setText(String string) {
            if (USE_FX_WEBVIEW) {
                Platform.runLater(() -> this.browser.loadContent(string));
            } else {
                this.reportPane.setText(string);
            }
        }

        public void setPage(URL uRL) throws IOException {
            if (USE_FX_WEBVIEW) {
                Platform.runLater(() -> this.browser.load(uRL.toExternalForm()));
            } else {
                this.reportPane.setPage(uRL);
            }
        }

        public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
            if (!USE_FX_WEBVIEW) {
                this.reportPane.addHyperlinkListener(hyperlinkListener);
            }
        }

        class Browser
        extends Region {
            final WebView browser = new WebView();
            final WebEngine webEngine = this.browser.getEngine();

            public Browser() {
                this.getStyleClass().add((Object)"browser");
                this.getChildren().add((Object)this.browser);
            }

            public void load(String string) {
                this.webEngine.load(string);
            }

            public void loadContent(String string) {
                this.webEngine.loadContent(string);
            }

            protected void layoutChildren() {
                double d = this.getWidth();
                double d2 = this.getHeight();
                this.layoutInArea((Node)this.browser, 0.0, 0.0, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
            }

            protected double computePrefWidth(double d) {
                return 750.0;
            }

            protected double computePrefHeight(double d) {
                return 500.0;
            }
        }
    }
}

