/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBoxLoader;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class RunADDMAction
extends ActionDialog {
    private static final String TASK_NAME = "TaskName";
    private static final String USE_CURRENT = "UseCurrent";
    private static final String START_SNAPSHOT = "StartSnapshot";
    private static final String END_SNAPSHOT = "EndSnapshot";

    protected String getTitle() {
        return DbaNavigatorResources.getString("RUN_ADDM_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(USE_CURRENT, DbaNavigatorResources.getString("USE_CURRENT_LABEL"), true);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TASK_NAME, DbaNavigatorResources.getString("TASK_NAME_LABEL"), "");
        DelayedLoadingComboBoxActionControl delayedLoadingComboBoxActionControl = new DelayedLoadingComboBoxActionControl(START_SNAPSHOT, DbaNavigatorResources.getString("START_SNAPSHOT_LABEL"), (Object)"", new DelayedLoadingComboBoxLoader(){

            public List<Object> getComboContents() throws TaskException {
                return RunADDMAction.this.getSnapshotIds(connection);
            }
        }, true);
        DelayedLoadingComboBoxActionControl delayedLoadingComboBoxActionControl2 = new DelayedLoadingComboBoxActionControl(END_SNAPSHOT, DbaNavigatorResources.getString("END_SNAPSHOT_LABEL"), (Object)"", new DelayedLoadingComboBoxLoader(){

            public List<Object> getComboContents() throws TaskException {
                return RunADDMAction.this.getSnapshotIds(connection);
            }
        }, true);
        textBoxActionControl.enableUI(false);
        delayedLoadingComboBoxActionControl.enableUI(false);
        delayedLoadingComboBoxActionControl2.enableUI(false);
        booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$useCurrentCtl;
            final /* synthetic */ ActionControl val$taskNameCtl;
            final /* synthetic */ ActionControl val$startSnapshotCtl;
            final /* synthetic */ ActionControl val$endSnapshotCtl;
            {
                this.val$useCurrentCtl = actionControl;
                this.val$taskNameCtl = actionControl2;
                this.val$startSnapshotCtl = actionControl3;
                this.val$endSnapshotCtl = actionControl4;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = !Boolean.parseBoolean(this.val$useCurrentCtl.getValue().get());
                this.val$taskNameCtl.enableUI(bl);
                this.val$startSnapshotCtl.enableUI(bl);
                this.val$endSnapshotCtl.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)delayedLoadingComboBoxActionControl);
        arrayList.add((ActionControl)delayedLoadingComboBoxActionControl2);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        boolean bl = Boolean.parseBoolean(values.get(USE_CURRENT));
        String string = values.get(TASK_NAME);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("   DBMS_WORKLOAD_REPOSITORY.CREATE_SNAPSHOT();\n");
            stringBuffer.append("END;\n");
        } else {
            stringBuffer.append("DECLARE\n");
            stringBuffer.append("   START_SNAP_ID NUMBER := ");
            stringBuffer.append(values.get(START_SNAPSHOT));
            stringBuffer.append(";\n");
            stringBuffer.append("   END_SNAP_ID NUMBER := ");
            stringBuffer.append(values.get(END_SNAPSHOT));
            stringBuffer.append(";\n");
            stringBuffer.append("   TID NUMBER;\n");
            if (string == null || string.equals("")) {
                stringBuffer.append("   TNAME VARCHAR2(30);\n");
            } else {
                stringBuffer.append("   TNAME VARCHAR2(30) := '");
                stringBuffer.append(values.get(TASK_NAME));
                stringBuffer.append("';\n");
            }
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("   DBMS_ADVISOR.CREATE_TASK('ADDM', TID, TNAME);\n");
            stringBuffer.append("   DBMS_ADVISOR.SET_TASK_PARAMETER(TNAME, 'START_SNAPSHOT', START_SNAP_ID);\n");
            stringBuffer.append("   DBMS_ADVISOR.SET_TASK_PARAMETER(TNAME, 'END_SNAPSHOT', END_SNAP_ID);\n");
            stringBuffer.append("   DBMS_ADVISOR.EXECUTE_TASK(TNAME);\n");
            stringBuffer.append("END;\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getSnapshotIds(Connection connection) {
        ArrayList<Object> arrayList;
        block8: {
            arrayList = new ArrayList<Object>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap hashMap = new HashMap();
                    resultSet = dBUtil.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getSnapshotIds"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString(1));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }
}

