/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupwizards;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.DiskEncryptionActionGroup;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.AbstractModelObject;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.DiskProperties;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.TapeProperties;
import oracle.dbtools.raptor.dba.navigator.actions.backupwizards.TaskResult;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class BasicBackupModel
extends AbstractModelObject {
    public static final String BACKUPOP = "BACKUPOP";
    private CardLayoutActionControl _backupOp;
    private RMANScriptProcessorActionControl _RMANScriptProcessor;
    private DiskProperties _diskProperties;
    private TapeProperties _tapeProperties;
    private TapeProperties _diskAndTapeProperties;
    private boolean _archiveLogMode;
    private boolean _processScriptCancelled;

    public void initBasicBackupModel(Connection connection) {
        this._archiveLogMode = DbaUtil.isArchiveLogMode(connection);
        this._RMANScriptProcessor = new RMANScriptProcessorActionControl(connection, "backup.rman", this._archiveLogMode, true);
        this._diskProperties = new DiskProperties(connection, this._RMANScriptProcessor);
        this._tapeProperties = new TapeProperties(connection);
        this._diskAndTapeProperties = new TapeProperties(connection);
        EnumMap<Op, ActionControl> enumMap = new EnumMap<Op, ActionControl>(Op.class);
        enumMap.put(Op.DISK, this.createDiskPropertiesCard(this.getDiskProperties()));
        enumMap.put(Op.TAPE, this.createTapePropertiesCard(this.getTapeProperties()));
        enumMap.put(Op.BOTH, this.createTapePropertiesCard(this.getDiskAndTapeProperties()));
        this._backupOp = new CardLayoutActionControl("", DbaNavigatorResources.getString("BACKUP_TYPE_LABEL"), CardLayoutPanel.Type.PLAIN, enumMap);
    }

    public boolean isArchiveLogMode() {
        return this._archiveLogMode;
    }

    public CardLayoutActionControl getBackupOp() {
        return this._backupOp;
    }

    public RMANScriptProcessorActionControl getRMANScriptProcessor() {
        return this._RMANScriptProcessor;
    }

    public DiskProperties getDiskProperties() {
        return this._diskProperties;
    }

    public TapeProperties getTapeProperties() {
        return this._tapeProperties;
    }

    public TapeProperties getDiskAndTapeProperties() {
        return this._diskAndTapeProperties;
    }

    public String getBackupSummary() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._backupOp.getValue().get();
        if (Op.DISK.toString().equals(string)) {
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_DISK_BACKUP_SUMMARY"));
            if (Boolean.parseBoolean(this.getDiskProperties().getDiskEncryptionActionGroup().getUseEncryptionCtl().getValue().get())) {
                stringBuffer.append("\n\n");
                stringBuffer.append(" o ");
                stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_DISK_ENCRYPTION_SUMMARY"));
                stringBuffer.append(' ');
                stringBuffer.append(this.getDiskProperties().getDiskEncryptionActionGroup().getAlgorithmCtl().getValue().get());
            }
        } else {
            object = null;
            if (Op.TAPE.toString().equals(string)) {
                object = this.getTapeProperties();
                stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_TAPE_BACKUP_SUMMARY"));
            } else {
                object = this.getDiskAndTapeProperties();
                stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_DISK_AND_TAPE_BACKUP_SUMMARY"));
            }
            stringBuffer.append("\n\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_RECOVERY_WINDOW_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(((TapeProperties)object).getRecoveryWindow().getValue().get());
            stringBuffer.append("\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_TAPE_PARALLELISM_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(((TapeProperties)object).getTapeParallelism().getValue().get());
            stringBuffer.append("\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_TAPE_LIB_PARAMS_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(((TapeProperties)object).getLibraryParams().getValue().get());
        }
        stringBuffer.append("\n\n");
        object = this._RMANScriptProcessor.getProcessingTypeCtl().getValue().get();
        if (RMANScriptProcessorActionControl.RUN_SCHEDULER_JOB.equals(object)) {
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_RUN_SCHEDULER_JOB_SUMMARY"));
            stringBuffer.append("\n\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_RUN_JOB_CREDENTIAL_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(this._RMANScriptProcessor.getCredentialCtl().getValue().get());
            stringBuffer.append("\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_RUN_JOB_NAME_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(this._RMANScriptProcessor.getJobNameCtl().getValue().get());
            if (!this.isArchiveLogMode()) {
                stringBuffer.append("\n\n");
                stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_RESTART_WARNING"));
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_FILE_SAVE_SUMMARY"));
            stringBuffer.append("\n\n");
            stringBuffer.append(" o ");
            stringBuffer.append(DbaNavigatorResources.getString("BACKUP_WIZ_FILE_NAME_SUMMARY"));
            stringBuffer.append(' ');
            stringBuffer.append(this._RMANScriptProcessor.getFilePathCtl().getValue().get());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRMANScript() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._backupOp.getValue().get();
        if (Op.DISK.toString().equals(string)) {
            this.appendDiskScript(stringBuffer);
        } else if (Op.TAPE.toString().equals(string)) {
            this.appendTapeScript(stringBuffer);
        } else {
            this.appendDiskAndTapeScript(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void cancelProcessScript() {
        this._processScriptCancelled = true;
    }

    public void processScript(Connection connection, String string, TaskResult taskResult) {
        this._processScriptCancelled = false;
        String string2 = this.getRMANScriptProcessor().getProcessingTypeCtl().getValue().get();
        if (RMANScriptProcessorActionControl.RUN_SCHEDULER_JOB.equals(string2)) {
            if (this.isArchiveLogMode() || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("RESTART_DATABASE_MESSAGE"), (String)DbaNavigatorResources.getString("RESTART_DATABASE_TITLE"), null)) {
                this.runSchedulerJob(connection, string, this.getRMANScript(), this.getRMANScriptProcessor().getJobNameCtl().getValue().get(), this.getRMANScriptProcessor().getCredentialCtl().getValue().get(), taskResult);
            }
        } else {
            this.saveToFile(this.getRMANScript(), this.getRMANScriptProcessor().getFilePathCtl().getValue().get(), taskResult);
        }
    }

    private void runSchedulerJob(Connection connection, String string, String string2, String string3, String string4, TaskResult taskResult) {
        boolean bl = false;
        String string5 = null;
        if (!this.runJob(connection, string, string2, string3, string4)) {
            string5 = DbaNavigatorResources.getString("SCHEDULER_JOB_FAILURE");
        } else if (!this.waitForJobCompletion(connection, string3)) {
            string5 = DbaNavigatorResources.getString("RMAN_SCRIPT_FAILURE");
        } else {
            string5 = DbaNavigatorResources.getString("RMAN_SCRIPT_SUCCESS");
            bl = true;
        }
        taskResult.setMessage(string5);
        taskResult.setStatus(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runJob(Connection connection, String string, String string2, String string3, String string4) {
        boolean bl = true;
        Object object = DbaUtil.getServerHome(connection);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        string5 = "/";
        if (((String)object).contains("\\")) {
            string5 = "\\";
        }
        if (!((String)object).endsWith(string5)) {
            object = (String)object + string5;
        }
        String string9 = (String)object + "sqldeveloper" + string5 + "dbascripts" + string5;
        string8 = string9 + "latest.properties";
        String string10 = string9 + string3.replace('$', '_');
        string6 = string10 + ".rman";
        string7 = string10 + ".log";
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                Serializable serializable = new StringBuffer();
                ((StringBuffer)serializable).append("job=");
                ((StringBuffer)serializable).append(string3);
                ((StringBuffer)serializable).append('\n');
                ((StringBuffer)serializable).append("action=");
                ((StringBuffer)serializable).append(string);
                ((StringBuffer)serializable).append('\n');
                Object object2 = new HashMap<String, Object>();
                ((HashMap)object2).put("PATH", string8);
                ((HashMap)object2).put("CREDENTIAL", string4);
                ((HashMap)object2).put("CONTENTS", ((StringBuffer)serializable).toString());
                bl = dBUtil.execute(this.getQuery(connection, "putFile"), object2);
                connection.commit();
                if (bl) {
                    serializable = new HashMap();
                    ((HashMap)serializable).put("PATH", string6);
                    ((HashMap)serializable).put("CREDENTIAL", string4);
                    ((HashMap)serializable).put("CONTENTS", string2);
                    bl = dBUtil.execute(this.getQuery(connection, "putFile"), (Map)((Object)serializable));
                    connection.commit();
                }
                if (bl) {
                    serializable = new HashMap();
                    ((HashMap)serializable).put("JOB_NAME", string3);
                    ((HashMap)serializable).put("COMMENTS", string);
                    ((HashMap)serializable).put("SCRIPT_PATH", string6);
                    ((HashMap)serializable).put("LOG_PATH", string7);
                    ((HashMap)serializable).put("CREDENTIAL", string4);
                    object2 = this.getQuery(connection, "runChildJob");
                    dBUtil.execute((String)object2, (Map)((Object)serializable));
                    connection.commit();
                    RMANScriptProcessorActionControl.updateDefaultCredential(string4);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForJobCompletion(Connection connection, String string) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                boolean bl2 = false;
                while (!bl2 && !this._processScriptCancelled) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("JOB_NAME", string);
                    ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "queryJob"), hashMap);
                    if (resultSet != null) {
                        try {
                            while (resultSet.next()) {
                                String string2 = resultSet.getString("STATUS");
                                if (string2 == null) continue;
                                bl2 = true;
                                bl = string2.equals("SUCCEEDED");
                            }
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                    }
                    connection.commit();
                    if (bl2) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this._processScriptCancelled = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(String string, String string2, TaskResult taskResult) {
        boolean bl = false;
        String string3 = null;
        IOException iOException = null;
        try {
            if (string2 == null || string2.equals("")) {
                throw new FileNotFoundException(DbaNavigatorResources.getString("FILE_NOT_SPECIFIED"));
            }
            File file = new File(string2);
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(string);
            }
            string3 = DbaNavigatorResources.format("FILE_SAVE_SUCCESS", string2);
            bl = true;
        }
        catch (IOException iOException2) {
            string3 = DbaNavigatorResources.getString("FILE_SAVE_FAILURE");
            iOException = iOException2;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException2.getStackTrace()[0].toString(), iOException2);
        }
        taskResult.setStatus(bl);
        taskResult.setMessage(string3);
        taskResult.setException(iOException);
        RMANScriptProcessorActionControl.updateDefaultSaveDir(string2);
    }

    private ActionControl createDiskPropertiesCard(DiskProperties diskProperties) {
        ArrayList<DiskEncryptionActionGroup> arrayList = new ArrayList<DiskEncryptionActionGroup>();
        arrayList.add(diskProperties.getDiskEncryptionActionGroup());
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl(arrayList);
        return propertyPanelActionControl;
    }

    private ActionControl createTapePropertiesCard(TapeProperties tapeProperties) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(tapeProperties.getTapeParallelism());
        arrayList.add(tapeProperties.getRecoveryWindow());
        arrayList.add(tapeProperties.getLibraryParams());
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl(arrayList);
        return propertyPanelActionControl;
    }

    private void appendDiskScript(StringBuffer stringBuffer) {
        boolean bl;
        DiskEncryptionActionGroup diskEncryptionActionGroup = this._diskProperties.getDiskEncryptionActionGroup();
        boolean bl2 = Boolean.parseBoolean(diskEncryptionActionGroup.getUseEncryptionCtl().getValue().get());
        boolean bl3 = bl = !this._archiveLogMode;
        if (bl) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        if (bl2) {
            String string = diskEncryptionActionGroup.getAlgorithmCtl().getValue().get();
            if (Boolean.parseBoolean(diskEncryptionActionGroup.getUsePasswordsCtl().getValue().get())) {
                stringBuffer.append("SET ENCRYPTION ON FOR ALL TABLESPACES ALGORITHM '");
                stringBuffer.append(string);
                stringBuffer.append("' IDENTIFIED BY '%PASSWORD' ONLY;\n");
                stringBuffer.append("SET DECRYPTION IDENTIFIED BY '%PASSWORD';\n");
            } else {
                stringBuffer.append("SET ENCRYPTION ON FOR ALL TABLESPACES ALGORITHM '");
                stringBuffer.append(string);
                stringBuffer.append("';\n");
            }
        }
        stringBuffer.append("RUN {\n");
        stringBuffer.append("ALLOCATE CHANNEL SQLDEV_DISK_BACKUP DEVICE TYPE DISK;\n");
        stringBuffer.append("RECOVER COPY OF DATABASE WITH TAG 'ORA_SQLDEV_LEVEL_0';\n");
        stringBuffer.append("BACKUP INCREMENTAL LEVEL 1 CUMULATIVE COPIES=1 FOR RECOVER OF COPY WITH TAG 'ORA_SQLDEV_LEVEL_0' DATABASE;\n");
        stringBuffer.append("}\n");
        if (bl) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
    }

    private void appendTapeScript(StringBuffer stringBuffer) {
        boolean bl;
        TapeProperties tapeProperties = this._tapeProperties;
        int n = Integer.parseInt(tapeProperties.getTapeParallelism().getValue().get());
        int n2 = Integer.parseInt(tapeProperties.getRecoveryWindow().getValue().get());
        String string = tapeProperties.getLibraryParams().getValue().get();
        boolean bl2 = bl = !this._archiveLogMode;
        if (bl) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        stringBuffer.append("RUN {\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("ALLOCATE CHANNEL SQLDEV_SBT_BACKUP");
            stringBuffer.append(i + 1);
            stringBuffer.append(" TYPE 'SBT_TAPE' FORMAT '%U' PARMS '");
            stringBuffer.append(string);
            stringBuffer.append("';\n");
        }
        stringBuffer.append("BACKUP INCREMENTAL LEVEL 1 CUMULATIVE DATABASE;\n");
        stringBuffer.append("BACKUP ARCHIVELOG ALL NOT BACKED UP;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("ALLOCATE CHANNEL FOR MAINTENANCE DEVICE TYPE 'SBT_TAPE' PARMS '");
        stringBuffer.append(string);
        stringBuffer.append("';\n");
        stringBuffer.append("DELETE NOPROMPT OBSOLETE RECOVERY WINDOW OF ");
        stringBuffer.append(n2);
        stringBuffer.append(" DAYS DEVICE TYPE 'SBT_TAPE';\n");
        if (bl) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
    }

    private void appendDiskAndTapeScript(StringBuffer stringBuffer) {
        boolean bl;
        TapeProperties tapeProperties = this._diskAndTapeProperties;
        int n = Integer.parseInt(tapeProperties.getTapeParallelism().getValue().get());
        int n2 = Integer.parseInt(tapeProperties.getRecoveryWindow().getValue().get());
        String string = tapeProperties.getLibraryParams().getValue().get();
        boolean bl2 = bl = !this._archiveLogMode;
        if (bl) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        stringBuffer.append("RUN {\n");
        stringBuffer.append("ALLOCATE CHANNEL SQLDEV_DISK_BACKUP DEVICE TYPE DISK;\n");
        stringBuffer.append("RECOVER COPY OF DATABASE WITH TAG 'ORA_SQLDEV_LEVEL_0';\n");
        stringBuffer.append("BACKUP INCREMENTAL LEVEL 1 CUMULATIVE  COPIES=1 FOR RECOVER OF COPY WITH TAG 'ORA_SQLDEV_LEVEL_0' DATABASE;\n");
        stringBuffer.append("RELEASE CHANNEL SQLDEV_DISK_BACKUP;\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("ALLOCATE CHANNEL SQLDEV_SBT_BACKUP");
            stringBuffer.append(i + 1);
            stringBuffer.append(" TYPE 'SBT_TAPE' FORMAT '%U' PARMS '");
            stringBuffer.append(string);
            stringBuffer.append("';\n");
        }
        stringBuffer.append("BACKUP ARCHIVELOG ALL NOT BACKED UP;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("ALLOCATE CHANNEL FOR MAINTENANCE DEVICE TYPE 'SBT_TAPE' PARMS '");
        stringBuffer.append(string);
        stringBuffer.append("';\n");
        stringBuffer.append("DELETE NOPROMPT OBSOLETE RECOVERY WINDOW OF ");
        stringBuffer.append(n2);
        stringBuffer.append(" DAYS DEVICE TYPE 'SBT_TAPE';\n");
        if (bl) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
    }

    public static enum Op {
        DISK(DbaNavigatorResources.getString("DISK_BACKUP")),
        TAPE(DbaNavigatorResources.getString("TAPE_BACKUP")),
        BOTH(DbaNavigatorResources.getString("DISK_AND_TAPE_BACKUP"));

        private String _display;

        private Op(String string2) {
            this._display = string2;
        }

        public String toString() {
            return this._display;
        }
    }
}

