<?xml version="1.0"?>
<!-- 
NAME
    kuprofil.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_profile_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    htseng      05/03/07 - bug 5567364: default profile
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     12/22/04 - bug 4082548: spacing when pretty=0
    htseng      11/18/04 - bug 4004874:fix password_verify_function with
                           NULL/DEFAULT
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	05/21/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PROFILE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">PROFILE</xsl:with-param>
   <xsl:with-param name="NameNode" select="PROFILE_NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="PROFILE_NAME='DEFAULT'">
    <xsl:text> ALTER PROFILE </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> CREATE PROFILE </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="PROFILE_NAME"/>
  </xsl:call-template>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> LIMIT </xsl:text>
  <xsl:apply-templates select="PROFILE_LIST"/>
 </xsl:template>
 <xsl:template match="PROFILE_LIST">
  <xsl:for-each select="PROFILE_LIST_ITEM">
   <xsl:if test="TYPE_NUM=0">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;         </xsl:text>
    </xsl:if>
    <xsl:value-of select="RESNAME"/>
    <xsl:call-template name="LIMIT_INFO"/>
   </xsl:if>
   <xsl:if test="TYPE_NUM=1">
    <xsl:choose>
     <xsl:when test="RESOURCE_NUM !=4">
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;         </xsl:text>
      </xsl:if>
      <xsl:value-of select="RESNAME"/>
      <xsl:call-template name="LIMIT_INFO"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;         </xsl:text>
      </xsl:if>
      <xsl:value-of select="RESNAME"/>
      <xsl:choose>
       <xsl:when test="string-length(../../PASS_FUNC_NAME) != 0">
        <xsl:text> </xsl:text>
        <xsl:call-template name="QuoteObject">
         <xsl:with-param name="Object" select="../../PASS_FUNC_NAME"/>
        </xsl:call-template>
        <xsl:text> </xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:choose>
         <xsl:when test="LIMIT_NUM=0">
          <xsl:text> DEFAULT </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text> NULL </xsl:text>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="LIMIT_INFO">
  <xsl:choose>
   <xsl:when test="LIMIT_NUM=2147483647">
    <xsl:text> UNLIMITED </xsl:text>
   </xsl:when>
   <xsl:when test="LIMIT_NUM=0">
    <xsl:text> DEFAULT </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> </xsl:text>
    <xsl:value-of select="LIMIT_NUM"/>
    <xsl:if test="TYPE_NUM=1">
     <xsl:if test="RESOURCE_NUM =1 or RESOURCE_NUM =2 or RESOURCE_NUM =5 
		 or RESOURCE_NUM =6">
      <xsl:text>/86400</xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:text> </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
