/* iod-telemetry Tablespaces.sql version 2019.06.17.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_group as (
            select /*+ INLINE */
                con_id, tablespace_name, sum(bytes) as freebytes
            from cdb_free_space group by con_id, tablespace_name
            union
            select /*+ INLINE */
                con_id, tablespace_name, sum(free_space) as freebytes
            from cdb_temp_free_space group by con_id, tablespace_name
    ),
    v$metric_history as (
            select /*+ INLINE OPT_PARAM('_px_cdb_view_enabled' 'FALSE') */
                 con.name
                ,cts.tablespace_name
                ,cts.block_size
                ,cts.status
                ,cts.contents
                ,cts.logging
                ,cts.force_logging
                ,cts.extent_management
                ,cts.allocation_type
                ,cts.segment_space_management
                ,cts.def_tab_compression
                ,cts.bigfile
                ,cts.encrypted
                ,cts.compress_for
                ,cdf.datafiles
                ,cdf.maxbytes
                ,cdf.bytes
                ,nvl(cfs.freebytes,0)                                               freebytes
                ,bytes - nvl(cfs.freebytes,0)                                       usedbytes
                ,greatest(cdf.maxbytes,cdf.bytes)                                   effective_bytes
                ,greatest(cdf.maxbytes,cdf.bytes) - (bytes - nvl(cfs.freebytes,0))  effective_freebytes
            from
            	 v$containers      con
            	,cdb_tablespaces   cts
                ,(
                    select con_id, tablespace_name, count(*) as datafiles, sum(bytes) as bytes, sum(maxbytes) as maxbytes from cdb_data_files group by con_id, tablespace_name
                    union
                    select con_id, tablespace_name, count(*) as datafiles, sum(bytes) as bytes, sum(maxbytes) as maxbytes from cdb_temp_files group by con_id, tablespace_name
                ) cdf
            	,v$metric_group cfs
            where
                    cts.con_id = cdf.con_id
                and con.con_id = cts.con_id
                and cts.con_id = cfs.con_id (+)
                and cts.tablespace_name = cdf.tablespace_name
                and cts.tablespace_name = cfs.tablespace_name (+)
    ),
    v$metric as (
        select
             'Tablespaces.'|| metric_name as metric_name
            ,',"con_name":"'                    || nvl(to_char(name                     ),'null') || '"' ||
             ',"tablespace_name":"'             || nvl(to_char(tablespace_name          ),'null') || '"' ||
             ',"block_size":"'                  || nvl(to_char(block_size               ),'null') || '"' ||
             ',"status":"'                      || nvl(to_char(status                   ),'null') || '"' ||
             ',"contents":"'                    || nvl(to_char(contents                 ),'null') || '"' ||
             ',"logging":"'                     || nvl(to_char(logging                  ),'null') || '"' ||
             ',"force_logging":"'               || nvl(to_char(force_logging            ),'null') || '"' ||
             ',"extent_management":"'           || nvl(to_char(extent_management        ),'null') || '"' ||
             ',"segment_space_management":"'    || nvl(to_char(segment_space_management ),'null') || '"' ||
            -- ',"def_tab_compression":"'         || nvl(to_char(def_tab_compression      ),'null') || '"' ||
             ',"bigfile":"'                     || nvl(to_char(bigfile                  ),'null') || '"' ||
            -- ',"encrypted":"'                   || nvl(to_char(encrypted                ),'null') || '"' ||
             ',"compress_for":"'                || nvl(to_char(compress_for             ),'null') || '"' as metric_dimensions
            ,metric_value as metric_value
        from  (
            select
                 name
                ,tablespace_name
                ,block_size
                ,status
                ,contents
                ,logging
                ,force_logging
                ,extent_management
                ,allocation_type
                ,segment_space_management
                ,def_tab_compression
                ,bigfile
                ,encrypted
                ,compress_for
                ,datafiles                                         as "Datafiles"
                ,maxbytes                                          as "Maxbytes"
                ,bytes                                             as "Bytes"
                ,freebytes                                         as "BytesFree"
                ,usedbytes                                         as "BytesUsed"
                ,round((usedbytes/bytes)*100,2)                    as "PercentUsed"
                ,100-round((usedbytes/bytes)*100,2)                as "PercentFree"
                ,effective_bytes                                   as "EffectiveBytes"
                ,effective_freebytes                               as "EffectiveBytesFree"
                ,round((usedbytes/effective_bytes)*100,2)          as "EffectivePercentUsed"
                ,100-round((usedbytes/effective_bytes)*100,2)      as "EffectivePercentFree"
            from
                v$metric_history
        ) unpivot (
            metric_value for metric_name in (
                 "Datafiles"
                ,"Maxbytes"
                ,"Bytes"
                ,"BytesFree"
                ,"BytesUsed"
                ,"PercentUsed"
                ,"PercentFree"
                ,"EffectiveBytes"
                ,"EffectiveBytesFree"
                ,"EffectivePercentUsed"
                ,"EffectivePercentFree"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
