/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.BundleHandler;
import oracle.ideimpl.webupdate.parser.InputStreamLocator;
import oracle.ideimpl.webupdate.parser.ParserResult;
import oracle.ideimpl.webupdate.parser.Problems;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.MessageReporter;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.SAXException;

public final class LocalBundleParser
extends ExtensibleSAXParser {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/updatebundle";
    private ElementHandler _legacyBundleHandler = new LegacyUpdateBundleHandler();
    private ElementHandler _updateHandler = new UpdateHandler(){

        @Override
        protected void handleUpdate(ElementContext context, UpdateInfo update) {
            UpdateBundle bundle = BundleHandler.getBundle(context);
            if (bundle == null) {
                bundle = LocalBundleParser.this._bundle;
            }
            if (LocalBundleParser.this._isLegacy) {
                bundle.setName(update.getName());
                bundle.setDownloadUrl(update.getURL());
                bundle.setInstallLocation(update.getPreferredInstallLocation());
            }
            bundle.add(update);
        }
    };
    private BundleHandler _newBundleHandler = new BundleHandler(){

        @Override
        protected ElementHandler createUpdateHandler() {
            return LocalBundleParser.this._updateHandler;
        }

        @Override
        protected void handleBundle(ElementContext context, UpdateBundle bundle) {
            LocalBundleParser.this._bundle = bundle;
        }
    };
    private UpdateBundle _bundle;
    private boolean _isLegacy = false;

    public ParserResult parse(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        InputStreamLocator locator = new InputStreamLocator(inputStream);
        this._bundle = new UpdateBundle();
        ProblemsReporter reporter = new ProblemsReporter();
        this.getContext().setMessageReporter((MessageReporter)reporter);
        this.getContext().registerChildHandler(NS, "update-bundle", this._legacyBundleHandler);
        this.getContext().registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "bundle", (ElementHandler)this._newBundleHandler);
        this.parse(locator);
        return new ParserResult(this._bundle, reporter.problems());
    }

    private class LegacyUpdateBundleHandler
    extends ElementHandler {
        private LegacyUpdateBundleHandler() {
        }

        public void handleStart(ElementStartContext context) {
            LocalBundleParser.this._isLegacy = true;
            context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "update", LocalBundleParser.this._updateHandler);
        }
    }

    private static class ProblemsReporter
    implements MessageReporter {
        private final Problems _problems = new Problems();

        private ProblemsReporter() {
        }

        Problems problems() {
            return this._problems;
        }

        public void severe(XMLLocator locator, String message, Throwable exception) {
            this._problems.addDescription(message);
        }

        public void error(XMLLocator locator, String message, Throwable exception) {
            this._problems.addDescription(message);
        }

        public void warning(XMLLocator locator, String message) {
        }

        public void information(XMLLocator locator, String message) {
        }
    }
}

