/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.NumberProperty;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.util.ModelUtil;

public abstract class PropertyInfo
implements Comparable {
    public static final String ID = "ID";
    public static final String NAME = "name";

    public abstract String getPropertyName();

    @Deprecated
    public String getPropertyPath() {
        return this.getPropertyName();
    }

    public abstract Class<?> getPropertyClass();

    public Object getPropertyValue(Object object) {
        Object object2 = null;
        if (object instanceof DBObject) {
            object2 = ((DBObject)object).getProperty(this.getPropertyName());
        }
        return object2;
    }

    public void setPropertyValue(Object object, Object object2) throws Exception {
        if (Boolean.FALSE.equals(object2) && this.getNullBehaviour() == Nullable.NullBehaviour.NULL_MEANS_FALSE) {
            object2 = null;
        } else if (object2 instanceof DBObject[] && ((DBObject[])object2).length == 0) {
            object2 = null;
        }
        if (object instanceof DBObject) {
            ((DBObject)object).setProperty(this.getPropertyName(), object2);
        }
    }

    public Class<? extends DBObject> getReferencedClass() {
        Class<?> clazz;
        References references = this.getAnnotation(References.class);
        Class clazz2 = references == null ? (DBObjectID.class.isAssignableFrom(clazz = DBUtil.decodeArrayClass(this.getPropertyClass())) ? DBObject.class : null) : references.value();
        return clazz2;
    }

    public String[] getReferencedTypes() {
        References references = this.getAnnotation(References.class);
        return references == null ? null : PropertyInfo.getAllowedTypes(references);
    }

    public boolean isInternalReference() {
        References references = this.getAnnotation(References.class);
        return references == null ? false : references.internal();
    }

    public boolean isGetTransient() {
        return false;
    }

    public boolean isSetTransient() {
        return false;
    }

    @Deprecated
    public boolean isTransient() {
        return this.isGetTransient() || this.isSetTransient();
    }

    public boolean isInternal() {
        return this.getAnnotation(Internal.class) != null;
    }

    public boolean isDerived() {
        return this.getAnnotation(Derived.class) != null;
    }

    public String getDerivedSourceProperty() {
        Derived derived = this.getAnnotation(Derived.class);
        return derived == null ? null : derived.value();
    }

    public boolean isDeprecated() {
        Deprecated deprecated = this.getAnnotation(Deprecated.class);
        return deprecated != null;
    }

    public boolean isSupported(Class<? extends DBObjectProvider> clazz, Class<? extends DBObject> clazz2) {
        Class<? extends DBObjectProvider> clazz3 = this.getProviderClass();
        Collection<Class<? extends DBObject>> collection = this.getObjectClasses();
        boolean bl = true;
        if (clazz != null && clazz3 != null && !clazz3.isAssignableFrom(clazz)) {
            bl = false;
        } else if (collection != null && clazz2 != null) {
            boolean bl2 = this.containsSuperclass(collection, clazz2);
            if (!bl2) {
                for (Class<? extends DBObject> clazz4 : Metadata.getInstance().getDefaultImplClasses(clazz2)) {
                    if (!this.containsSuperclass(collection, clazz4)) continue;
                    bl2 = true;
                    break;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    private boolean containsSuperclass(Iterable<Class<? extends DBObject>> iterable, Class<? extends DBObject> clazz) {
        boolean bl = false;
        for (Class<? extends DBObject> clazz2 : iterable) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected Collection<Class<? extends DBObject>> getObjectClasses() {
        return null;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        return null;
    }

    public DynamicPropertyProvider getDynamicPropertyProvider() {
        return null;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        PropertyInfo propertyInfo = (PropertyInfo)object;
        if (this.equalsImpl(propertyInfo)) {
            return 0;
        }
        String string = this.getPropertyName();
        String string2 = propertyInfo.getPropertyName();
        if (string.equals(ID) && !string2.equals(ID)) {
            return -100;
        }
        if (string2.equals(ID)) {
            return 100;
        }
        if (string.equals(NAME) && !string2.equals(NAME)) {
            return -50;
        }
        if (string2.equals(NAME)) {
            return 50;
        }
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)object);
    }

    protected abstract boolean equalsImpl(PropertyInfo var1);

    public boolean isStaticReference() {
        return false;
    }

    public boolean isTextMultiLine() {
        TextProperty textProperty = this.getAnnotation(TextProperty.class);
        return textProperty != null && textProperty.multiLine();
    }

    public boolean isTextPassword() {
        TextProperty textProperty = this.getAnnotation(TextProperty.class);
        return textProperty != null && textProperty.password();
    }

    public boolean isTextInternalName() {
        TextProperty textProperty = this.getAnnotation(TextProperty.class);
        return textProperty != null && textProperty.internalName();
    }

    public boolean isNumberUnlimited() {
        return this.getNumberUnlimitedValue() != null;
    }

    public Integer getNumberUnlimitedValue() {
        NumberProperty numberProperty = this.getAnnotation(NumberProperty.class);
        return numberProperty == null || !numberProperty.unlimited() ? null : Integer.valueOf(numberProperty.unlimitedValue());
    }

    public boolean isNumberPhysicalSize() {
        NumberProperty numberProperty = this.getAnnotation(NumberProperty.class);
        return numberProperty != null && numberProperty.physicalSize();
    }

    public CascadeAction getCascadeAction() {
        References references = this.getAnnotation(References.class);
        return references == null ? CascadeAction.UPDATE : references.cascade();
    }

    protected <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return null;
    }

    public Nullable.NullBehaviour getNullBehaviour() {
        Class<?> clazz;
        Nullable nullable = this.getAnnotation(Nullable.class);
        Nullable.NullBehaviour nullBehaviour = nullable == null ? ((clazz = this.getPropertyClass()).isPrimitive() || clazz.isArray() ? Nullable.NullBehaviour.NOT_NULLABLE : Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) : nullable.value();
        return nullBehaviour;
    }

    public Collection getAllowedValues() {
        ArrayList<Object> arrayList = null;
        Class<?> clazz = this.getPropertyClass();
        if (clazz != null) {
            if (Enum.class.isAssignableFrom(clazz)) {
                arrayList = new ArrayList<Object>();
                try {
                    Method method = clazz.getMethod("values", new Class[0]);
                    Object[] objectArray = (Object[])method.invoke(null, new Object[0]);
                    if (this.getNullBehaviour() != Nullable.NullBehaviour.NOT_NULLABLE) {
                        arrayList.add(null);
                    }
                    for (Object object : objectArray) {
                        if (DBUtil.isDeprecated((Enum)object)) continue;
                        arrayList.add(object);
                    }
                }
                catch (Exception exception) {
                    DBLog.getLogger(this).log(Level.WARNING, "Couldn't get enum values", exception);
                }
            } else if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
                arrayList = new ArrayList();
                Nullable.NullBehaviour nullBehaviour = this.getNullBehaviour();
                if (Boolean.class.equals(clazz) && nullBehaviour != Nullable.NullBehaviour.NOT_NULLABLE && nullBehaviour != Nullable.NullBehaviour.NULL_MEANS_FALSE) {
                    arrayList.add(null);
                }
                arrayList.add(true);
                arrayList.add(false);
            }
        }
        return arrayList;
    }

    public Collection<String> getAllowedReferenceTypes() {
        TreeSet<String> treeSet = null;
        if (DBObjectID.class.isAssignableFrom(DBUtil.decodeArrayClass(this.getPropertyClass()))) {
            boolean bl;
            Collection<String> collection;
            treeSet = new TreeSet<String>();
            Class<? extends DBObject> clazz = this.getReferencedClass();
            String[] stringArray = this.getReferencedTypes();
            if (clazz != null && DBObject.class.isAssignableFrom(clazz) && (stringArray == null || stringArray.length == 0)) {
                collection = Metadata.getInstance().getAllTypes(clazz);
                bl = DBObject.class.equals(clazz) || SystemObject.class.equals(clazz);
            } else {
                collection = Arrays.asList(stringArray);
                bl = false;
            }
            for (String string : collection) {
                if (bl && "SCHEMA".equals(string)) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    static boolean hasAnnotation(Method method, Class<? extends Annotation> clazz) {
        return method != null && clazz != null && method.getAnnotation(clazz) != null;
    }

    static <T extends Annotation> T findAnnotation(Method method, Class<T> clazz) {
        T t = null;
        Method method2 = PropertyInfo.findAnnotatedMethod(method, clazz);
        if (method2 != null) {
            t = method2.getAnnotation(clazz);
        }
        return t;
    }

    static Method findAnnotatedMethod(Method method, Class<? extends Annotation> clazz) {
        Method method2;
        block6: {
            method2 = null;
            try {
                if (method.isAnnotationPresent(clazz)) {
                    method2 = method;
                    break block6;
                }
                if (!clazz.isAnnotationPresent(Inherited.class)) break block6;
                Class<?> clazz2 = method.getDeclaringClass();
                while (clazz2 != null) {
                    for (Class<?> clazz3 : clazz2.getInterfaces()) {
                        method2 = PropertyInfo.getMatchingAnnotatedMethod(method, clazz3, clazz);
                        if (method2 == null) {
                            continue;
                        }
                        break block6;
                    }
                    method2 = PropertyInfo.getMatchingAnnotatedMethod(method, clazz2 = clazz2.getSuperclass(), clazz);
                    if (method2 == null) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                DBLog.logStackTrace("Reflection error", throwable);
            }
        }
        return method2;
    }

    private static Method getMatchingAnnotatedMethod(Method method, Class<?> clazz, Class<? extends Annotation> clazz2) {
        Method method2 = null;
        Method method3 = PropertyInfo.getMatchingMethod(method, clazz);
        if (method3 != null && method3.isAnnotationPresent(clazz2)) {
            method2 = method3;
        }
        return method2;
    }

    private static Method getMatchingMethod(Method method, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String[] getAllowedTypes(References references) {
        return references == null ? null : references.types();
    }

    static PropertyInfo createPropertyInfo(PropertyDescriptor propertyDescriptor) {
        return new DescriptorInfo(propertyDescriptor);
    }

    static PropertyInfo createPropertyInfo(String string, Field field) {
        return new FieldInfo(string, field);
    }

    private static class DescriptorInfo
    extends PropertyInfo {
        private Map<Class<? extends Annotation>, Annotation> m_annotations;
        private final PropertyDescriptor m_desc;
        private Boolean m_isGetTransient;
        private Boolean m_isSetTransient;
        private Boolean m_deprecated;

        DescriptorInfo(PropertyDescriptor propertyDescriptor) {
            this.m_desc = propertyDescriptor;
        }

        @Override
        public String getPropertyName() {
            return this.m_desc.getName();
        }

        @Override
        public Class<?> getPropertyClass() {
            return this.m_desc.getPropertyType();
        }

        @Override
        public boolean isGetTransient() {
            if (this.m_isGetTransient == null) {
                Method method = this.m_desc.getReadMethod();
                this.m_isGetTransient = method == null ? false : method.isAnnotationPresent(Transient.class);
            }
            return this.m_isGetTransient;
        }

        @Override
        public boolean isSetTransient() {
            if (this.m_isSetTransient == null) {
                Method method = this.m_desc.getWriteMethod();
                this.m_isSetTransient = method == null ? false : method.isAnnotationPresent(Transient.class);
            }
            return this.m_isSetTransient;
        }

        @Override
        public boolean isDeprecated() {
            if (this.m_deprecated == null) {
                this.m_deprecated = DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), Deprecated.class) || DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), Deprecated.class);
            }
            return this.m_deprecated;
        }

        @Override
        public Object getPropertyValue(Object object) {
            try {
                return this.m_desc.getReadMethod().invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException) {
                    throwable = exception.getCause();
                }
                DBLog.logStackTrace(throwable);
                return super.getPropertyValue(object);
            }
        }

        @Override
        public void setPropertyValue(Object object, Object object2) throws Exception {
            Object[] objectArray = new Object[]{object2};
            this.m_desc.getWriteMethod().invoke(object, objectArray);
        }

        @Override
        protected boolean equalsImpl(PropertyInfo propertyInfo) {
            return propertyInfo instanceof DescriptorInfo && ModelUtil.areEqual((Object)this.m_desc, (Object)((DescriptorInfo)propertyInfo).m_desc);
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> clazz) {
            Object object;
            if (this.m_annotations != null && this.m_annotations.containsKey(clazz)) {
                object = this.m_annotations.get(clazz);
            } else {
                object = DescriptorInfo.findAnnotation(this.m_desc.getReadMethod(), clazz);
                if (this.m_annotations == null) {
                    this.m_annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                }
                this.m_annotations.put((Class<? extends Annotation>)clazz, (Annotation)object);
            }
            return object;
        }

        @Override
        protected Collection<Class<? extends DBObject>> getObjectClasses() {
            Set<Class<? extends DBObject>> set = Collections.singleton(this.m_desc.getReadMethod().getDeclaringClass());
            return set;
        }

        @Override
        public DynamicPropertyProvider getDynamicPropertyProvider() {
            if ("attributeValues".equals(this.getPropertyName()) && DataTypeUsage.class.equals(this.m_desc.getReadMethod().getDeclaringClass())) {
                return new DynamicPropertyProvider(){

                    @Override
                    public PropertyInfo getPropertyInfo(Class<? extends DBObject> clazz, String string, DBObjectProvider dBObjectProvider) {
                        DataTypeAttributeInfo dataTypeAttributeInfo = null;
                        if (DataTypeRegistry.getInstance().isRegisteredAttribute(string)) {
                            dataTypeAttributeInfo = new DataTypeAttributeInfo(string);
                        }
                        return dataTypeAttributeInfo;
                    }
                };
            }
            return super.getDynamicPropertyProvider();
        }
    }

    private static class FieldInfo
    extends PropertyInfo {
        private final Field m_field;
        private final String m_name;

        FieldInfo(String string, Field field) {
            this.m_field = field;
            this.m_name = string;
            if (this.getAnnotation(PropertyKey.class) == null) {
                throw new IllegalArgumentException(this.m_name + " is invalid because its Field doesn't have a @PropertyKey");
            }
        }

        @Override
        protected boolean equalsImpl(PropertyInfo propertyInfo) {
            return propertyInfo instanceof FieldInfo && ModelUtil.areEqual((Object)this.m_name, (Object)((FieldInfo)propertyInfo).m_name) && ModelUtil.areEqual((Object)this.m_field, (Object)((FieldInfo)propertyInfo).m_field);
        }

        @Override
        public String getPropertyName() {
            return this.m_name;
        }

        @Override
        public Class<?> getPropertyClass() {
            PropertyKey propertyKey = this.getAnnotation(PropertyKey.class);
            return propertyKey.value();
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.m_field.getAnnotation(clazz);
        }

        @Override
        public Class<? extends DBObjectProvider> getProviderClass() {
            PropertyKey propertyKey = this.getAnnotation(PropertyKey.class);
            return propertyKey.provider();
        }

        @Override
        public Collection<Class<? extends DBObject>> getObjectClasses() {
            PropertyKey propertyKey = this.getAnnotation(PropertyKey.class);
            return Arrays.asList(propertyKey.childOf());
        }
    }

    private static class DataTypeAttributeInfo
    extends PropertyInfo {
        private final String m_attributeName;

        DataTypeAttributeInfo(String string) {
            this.m_attributeName = string;
        }

        @Override
        protected boolean equalsImpl(PropertyInfo propertyInfo) {
            return propertyInfo instanceof DataTypeAttributeInfo && ModelUtil.areEqual((Object)this.m_attributeName, (Object)((DataTypeAttributeInfo)propertyInfo).m_attributeName);
        }

        @Override
        public Class<?> getPropertyClass() {
            return Object.class;
        }

        @Override
        public String getPropertyName() {
            return this.m_attributeName;
        }

        @Override
        public void setPropertyValue(Object object, Object object2) throws Exception {
            if (object instanceof DataTypeUsage) {
                ((DataTypeUsage)object).putAttributeValue(this.m_attributeName, object2);
            }
        }

        @Override
        public Object getPropertyValue(Object object) {
            Object object2 = null;
            if (object instanceof DataTypeUsage) {
                object2 = ((DataTypeUsage)object).getAttributeValue(this.m_attributeName);
            }
            return object2;
        }
    }
}

