/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.util.ModelUtil;

public class NameBasedID
extends BaseObjectID {
    public NameBasedID() {
    }

    public NameBasedID(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public NameBasedID(String string, String string2, String string3, AbstractDBObjectProvider abstractDBObjectProvider) {
        super(string, abstractDBObjectProvider);
        this.setSchemaName(string2);
        this.setName(string3);
    }

    public NameBasedID(String string, String string2, DBObjectID dBObjectID) {
        super(string, dBObjectID);
        this.setName(string2);
    }

    public NameBasedID(DBObject dBObject, AbstractDBObjectProvider abstractDBObjectProvider) {
        super(dBObject, abstractDBObjectProvider);
    }

    public NameBasedID(DBObject dBObject, DBObjectID dBObjectID) {
        super(dBObject, dBObjectID);
    }

    @Override
    public void construct(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length >= 1) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            this.setType(string2);
            this.setName(string3);
            if (stringArray.length > 2) {
                if (stringArray[2].equals("SCHEMA") && stringArray.length == 4) {
                    this.setSchemaName(stringArray[3]);
                } else {
                    int n = string2.length() + ":".length() + string3.length() + ":".length();
                    this.setParent(BaseObjectID.createFromString(string.substring(n)));
                }
            }
        }
    }

    @Override
    protected boolean equalsImpl(DBObjectID dBObjectID, boolean bl) {
        if (bl) {
            return dBObjectID instanceof NameBasedID && this.equalsImpl((NameBasedID)dBObjectID);
        }
        if ((this.getType() == null || "UNSPECIFIED_TYPE".equals(this.getType())) && dBObjectID instanceof BaseObjectID) {
            return ModelUtil.areEqual((Object)this.getName(), (Object)((BaseObjectID)dBObjectID).getName()) && ModelUtil.areEqual((Object)this.getDatabaseName(), (Object)((BaseObjectID)dBObjectID).getDatabaseName());
        }
        return dBObjectID instanceof BaseObjectID && this.equalsImpl((BaseObjectID)dBObjectID);
    }

    public Object copyTo(Object object) {
        if (object instanceof BaseObjectID && !(object instanceof NameBasedID)) {
            this.copyToImpl((BaseObjectID)object);
            return object;
        }
        NameBasedID nameBasedID = object == null ? new NameBasedID() : (NameBasedID)object;
        this.copyToImpl(nameBasedID);
        return nameBasedID;
    }

    @Override
    protected String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getType());
        stringBuilder.append(":");
        String string = this.getName();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (this.getParent() == null) {
            String string2 = this.getSchemaName();
            if (ModelUtil.hasLength((String)string2)) {
                stringBuilder.append(":").append("SCHEMA");
                stringBuilder.append(":").append(string2);
            }
        } else if (this.getParent() instanceof BaseObjectID) {
            stringBuilder.append(":").append(this.getParent().toString());
        } else {
            this.getLogger().warning("Non-BaseObjectID as a parent for NameBasedID");
        }
        return stringBuilder.toString();
    }
}

