/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.graphics.ImageUtils;

public class LineWidth
extends JComboBox {
    private ResourceBundle rBundle = null;
    private Filter _filter = new Filter();
    protected Color m_cellColor;
    protected Color m_background;
    private KeyListener m_keyListener;

    public LineWidth() {
        this.updateResourceBundle(null);
        this.m_background = this.m_cellColor = this.getBackground();
        for (int i = 1; i < 7; ++i) {
            this.addItem(Integer.toString(i));
        }
        this.setMaximumRowCount(6);
        CellRenderer renderer = new CellRenderer();
        this.setRenderer(renderer);
        this.setPreferredSize(new Dimension(110, 25));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.m_keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LineWidth.this.hidePopup();
                }
            }
        };
        this.addKeyListener(this.m_keyListener);
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    private Icon _getColorIcon(Image image) {
        this._filter.setColor();
        Image newImage = LineWidth._createFilteredImage(image, this._filter);
        return new ImageIcon(newImage);
    }

    private static Image _createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public int getLineWidth() {
        return this.getSelectedIndex() + 1;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth > 0) {
            this.setSelectedIndex(lineWidth - 1);
        } else if (lineWidth == 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setCellColor(Color color) {
        this.m_cellColor = color;
        if (this.getBackground() != null && this.getBackground().getRGB() == this.m_cellColor.getRGB()) {
            this.m_cellColor = this.getBackground().getRGB() != -16777216 ? Color.black : Color.white;
        }
        this.repaint();
    }

    public void cleanUp() {
        this.removeKeyListener(this.m_keyListener);
        this.m_keyListener = null;
        this.setRenderer(null);
        this._filter = null;
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor() {
            Color c = LineWidth.this.m_cellColor;
            this._color = c == null ? 0 : c.getRGB();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(Color.white);
            }
            Object gifFileName = "";
            int line = Integer.parseInt((String)value);
            this.setText("");
            gifFileName = "images/Line" + line + ".gif";
            this.setIcon(LineWidth.this._getColorIcon(ImageUtils.getImageResource(LineWidth.class, (String)gifFileName)));
            this.setMinimumSize(new Dimension(100, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
            this.setMaximumSize(new Dimension(100, this.getMaximumSize().height));
            return this;
        }
    }
}

