/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.dimensionList;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DefaultListDataItem;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimListDataModel;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.SliceOutOfRangeException;

public class DataAccessDimensionModel
implements DimListDataModel,
Serializable {
    private transient DataAccess m_dataAccess = null;
    private transient MemberListAccess m_memberAccess = null;
    private boolean m_isDragable = true;
    private boolean m_isDropTarget = true;
    private transient Vector m_listeners = null;
    private transient Object m_selItem = null;
    private String m_labelType = "label";
    private transient boolean m_initOK = false;
    private String m_dimensionName = "";
    private boolean m_verbose = false;
    private transient int m_dimEdge = 0;
    private transient int m_dimDepth = -1;
    private boolean m_first = false;
    private boolean m_isHierarchical = true;
    private Vector slices;
    private boolean m_isTable = false;
    private Vector m_values;
    private Vector m_names;
    private boolean _memberListExist = false;
    private List m_list = null;

    public DataAccessDimensionModel() {
    }

    public DataAccessDimensionModel(DataAccess dataAccess, String dimension) {
        this(dataAccess, null, dimension, false);
    }

    public DataAccessDimensionModel(DataAccess dataAccess, MemberListAccess memberAccess, String dimension, boolean isTable) {
        this.setDimensionName(dimension);
        this.setDataAccess(dataAccess);
        this.m_memberAccess = memberAccess;
        this.m_isTable = isTable;
    }

    @Override
    public void addElement(Object o) {
    }

    @Override
    public boolean collapseAll() {
        return true;
    }

    @Override
    public boolean expandAll() {
        return true;
    }

    @Override
    public boolean drill(int index, int drillType) {
        return true;
    }

    @Override
    public boolean isHierarchical() {
        return this.m_isHierarchical;
    }

    @Override
    public void insertElementAt(Object o, int index) {
    }

    @Override
    public void setElementAt(Object o, int index) {
    }

    @Override
    public void refresh() {
        long nowCount = this.size();
        this.notifyListDataListeners(new ListDataEvent(this, 0, 0, (int)nowCount));
    }

    @Override
    public void removeAllElements() {
    }

    @Override
    public void removeElementAt(int index) {
    }

    @Override
    public void moveElement(int indexFrom, int indexTo) {
    }

    @Override
    public int find(String search, int flags, int startPos) {
        boolean bInStatus = true;
        int result = -1;
        if (startPos > 0) {
            // empty if block
        }
        int[] hpos = new int[]{++startPos};
        if (this.m_initOK) {
            try {
                if (this.m_dataAccess instanceof DataAccess) {
                    result = this.m_dataAccess.findMember(0, hpos, 0, search, this.m_labelType, flags);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Object getSelectedItem() {
        return this.m_selItem;
    }

    @Override
    public void setSelectedItem(Object item) {
        this.m_selItem = item;
    }

    @Override
    public Object elementAt(int index) {
        return this.getElementAt(index);
    }

    @Override
    public int getSize() {
        long ret = 0L;
        if (this.m_initOK) {
            try {
                if (!this.m_isTable || this.m_dimEdge == 2) {
                    if (this.m_memberAccess != null) {
                        ret = this.m_memberAccess.getAllMembers(this.m_dimEdge, this.m_dimDepth, "value").length;
                    } else {
                        if (!this._memberListExist) {
                            this.m_list = this.m_dataAccess.getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "indent", "drillState"}, 0, -1);
                            this._memberListExist = true;
                        }
                        if (this.m_list != null) {
                            ret = this.m_list.size();
                        }
                        if (this.m_list == null) {
                            int[] hPos = new int[this.m_dimDepth];
                            int count = this.m_dataAccess.getMemberSiblingCount(this.m_dimEdge, hPos, this.m_dimDepth);
                            if ((long)count == ret) {
                                return (int)ret;
                            }
                            Vector<Object> members = new Vector<Object>();
                            this.slices = new Vector();
                            for (int startslice = 0; startslice < this.m_dataAccess.getEdgeExtent(this.m_dimEdge); startslice += this.m_dataAccess.getMemberExtent(this.m_dimEdge, this.m_dimDepth, startslice)) {
                                Object member;
                                if (this.m_dataAccess.getMemberStartLayer(this.m_dimEdge, this.m_dimDepth, startslice) != this.m_dimDepth || members.indexOf(member = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, startslice, "value")) != -1) continue;
                                members.addElement(member);
                                this.slices.addElement(startslice);
                            }
                            ret = members.size();
                        }
                    }
                } else if (this.m_dimEdge == 0) {
                    this.m_values = new Vector();
                    this.m_names = new Vector();
                    Object[] values = null;
                    if (this.m_list == null) {
                        if (this.m_memberAccess != null) {
                            values = this.m_memberAccess.getAllMembers(0, this.m_dimDepth, "dataValue");
                        }
                        for (int i = 0; i < this.m_dataAccess.getEdgeExtent(1); ++i) {
                            Object val = null;
                            Object name = values != null ? values[i] : this.m_dataAccess.getValue(i, this.m_dimDepth, "dataValue");
                            val = this.m_dataAccess.getValue(i, this.m_dimDepth, "value");
                            if (val == null) {
                                val = this.m_dataAccess.getValue(i, this.m_dimDepth, "dataValue");
                            }
                            if (this.m_names.indexOf(name) != -1) continue;
                            this.m_names.addElement(name);
                            this.m_values.addElement(new ValueData(val, name));
                        }
                        ret = this.m_values.size();
                    }
                }
            }
            catch (SliceOutOfRangeException e1) {
                e1.printStackTrace();
            }
            catch (LayerOutOfRangeException e2) {
                e2.printStackTrace();
            }
            catch (EdgeOutOfRangeException e3) {
                e3.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)ret;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListDataListeners(ListDataEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v = null;
            DataAccessDimensionModel dataAccessDimensionModel = this;
            synchronized (dataAccessDimensionModel) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            for (int i = 0; i < count; ++i) {
                ListDataListener client = (ListDataListener)v.elementAt(i);
                if (client == null) continue;
                if (e.getType() == 1) {
                    client.intervalAdded(e);
                    continue;
                }
                if (e.getType() == 2) {
                    client.intervalRemoved(e);
                    continue;
                }
                client.contentsChanged(e);
            }
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
            long nowCount = this.size();
            ListDataEvent e = new ListDataEvent(this, 0, 0, (int)nowCount);
            l.contentsChanged(e);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.m_listeners != null && this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    @Override
    public boolean isDragable(long index) {
        return this.m_isDragable;
    }

    public void setIsDragable(boolean draggable) {
        this.m_isDragable = draggable;
    }

    @Override
    public boolean isDropTarget(long index, Object o) {
        return this.m_isDropTarget;
    }

    public void setIsDropTarget(boolean dropTarget) {
        this.m_isDropTarget = dropTarget;
    }

    @Override
    public Object getElementAt(int index) {
        DefaultListDataItem di = null;
        Object name = null;
        Object value = null;
        String hierLevel = "";
        int indentLevel = -1;
        int drillState = 0;
        if (this.m_initOK && index != -1) {
            if (this.m_isTable && this.m_dimEdge != 2) {
                try {
                    hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "relHierInfo");
                    if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                        hierLevel = "";
                    }
                    try {
                        indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "indent");
                        drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, 0, "drillState");
                    }
                    catch (Exception ex2) {
                        indentLevel = 0;
                        drillState = 0;
                    }
                    if (this.m_list == null) {
                        name = this.m_names.elementAt(index);
                        value = ((ValueData)this.m_values.elementAt((int)index)).value;
                    }
                    di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                }
                catch (Exception ePlus) {
                    ePlus.printStackTrace();
                }
            } else {
                try {
                    if (!this._memberListExist) {
                        this.m_list = this.m_dataAccess.getUniqueMemberMetadata(this.m_dimEdge, this.m_dimDepth, new String[]{"value", this.m_labelType, "relHierInfo", "indent", "drillState"}, 0, -1);
                        this._memberListExist = true;
                    }
                    if (this.m_list != null) {
                        Object[] item = (Object[])this.m_list.get(index);
                        value = item[0];
                        name = item[1];
                        hierLevel = (String)item[2];
                        indentLevel = item[3] != null ? (Integer)item[3] : 0;
                        drillState = item[4] != null ? (Integer)item[4] : 0;
                        di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                    }
                }
                catch (EdgeOutOfRangeException item) {
                }
                catch (LayerOutOfRangeException item) {
                }
                catch (SliceOutOfRangeException item) {
                    // empty catch block
                }
                if (this.m_list == null) {
                    Object s = null;
                    int[] depthIndex = new int[this.m_dimDepth];
                    try {
                        if (this.slices != null) {
                            int slice = (Integer)this.slices.elementAt(index);
                            name = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, this.m_labelType);
                            value = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "value");
                            if (name == null) {
                                name = value;
                            }
                            try {
                                hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "relHierInfo");
                                if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                                    hierLevel = "";
                                }
                                try {
                                    indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "indent");
                                    drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, this.m_dimDepth, slice, "drillState");
                                }
                                catch (Exception ex2) {
                                    indentLevel = 0;
                                    drillState = 0;
                                }
                            }
                            catch (Exception ePlus) {
                                ePlus.printStackTrace();
                            }
                        } else {
                            name = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, this.m_labelType);
                            value = this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "value");
                            if (name == null) {
                                name = value;
                            }
                            try {
                                hierLevel = (String)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "relHierInfo");
                                if (hierLevel == null || hierLevel.equals(value) || hierLevel.equals(name)) {
                                    hierLevel = "";
                                }
                                try {
                                    indentLevel = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "indent");
                                    drillState = (Integer)this.m_dataAccess.getMemberMetadata(this.m_dimEdge, depthIndex, this.m_dimDepth, index, "drillState");
                                }
                                catch (Exception ex2) {
                                    indentLevel = 0;
                                    drillState = 0;
                                }
                            }
                            catch (Exception ePlus) {
                                ePlus.printStackTrace();
                            }
                        }
                        di = new DefaultListDataItem(name.toString(), indentLevel, drillState, name.toString(), value.toString(), hierLevel);
                    }
                    catch (SliceOutOfRangeException e1) {
                        e1.printStackTrace();
                    }
                    catch (LayerOutOfRangeException e2) {
                        e2.printStackTrace();
                    }
                    catch (EdgeOutOfRangeException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return di;
    }

    public void setLabelType(String value) {
        this.m_labelType = value;
    }

    public String getLabelType() {
        return this.m_labelType;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public void setDimensionName(String dimensionName) {
        this.m_dimensionName = dimensionName;
    }

    public String getDimensionName() {
        return this.m_dimensionName;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.m_dataAccess = dataAccess;
        this.initDataAccess();
    }

    public void setHierarchical(boolean hier) {
        this.m_isHierarchical = hier;
    }

    private void initDataAccess() {
        if (this.m_dataAccess != null && this.m_dimensionName != null) {
            try {
                block2: for (int e = 0; e < this.m_dataAccess.getEdgeCount(); ++e) {
                    for (int d = 0; d < this.m_dataAccess.getLayerCount(e); ++d) {
                        String layerName = (String)this.m_dataAccess.getLayerMetadata(e, d, "layerName");
                        if (layerName == null || !this.m_dimensionName.equals(layerName)) continue;
                        this.m_dimEdge = e;
                        this.m_dimDepth = d;
                        if (!this.m_first) {
                            this.m_first = true;
                        }
                        this.m_initOK = true;
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ValueData {
        Object value;
        Object name;

        public ValueData(Object val, Object n) {
            this.value = val;
            this.name = n;
        }
    }
}

