/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.BasePropertiesDialog;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLJoinKindFull;
import com.adbs.ast.SQLJoinKindInner;
import com.adbs.ast.SQLJoinKindLeft;
import com.adbs.ast.SQLJoinKindRight;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkChangedEvent;
import com.adbs.querybuilder.LinkChangingEvent;
import com.adbs.querybuilder.LinkManipulations;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LinkPropertiesDialog
extends BasePropertiesDialog {
    private static final long serialVersionUID = 1L;
    private Link link;
    private boolean reverseDatasources;
    private DataSourceBase left;
    private DataSourceBase right;
    private SQLExpressionItem expr;
    private SQLExpressionItem newExpr = null;
    private SQLExpressionOperatorBinary ec;
    private boolean showSimplePanel = false;
    private JButton bCancel;
    private JButton bOk;
    private JCheckBox cbAllFromLeft;
    private JCheckBox cbAllFromRight;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField textExpression;
    private JTextField textLeftObj;
    private JTextField textRightObj;

    public LinkPropertiesDialog(Window parent) {
        super(parent);
        this.initComponents();
        Helpers.localizer.localizeDialog(this);
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private void initComponents() {
        this.bOk = new JButton();
        this.bCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.textExpression = new JTextField();
        this.jPanel2 = new JPanel();
        this.cbAllFromLeft = new JCheckBox();
        this.textLeftObj = new JTextField();
        this.jPanel3 = new JPanel();
        this.textRightObj = new JTextField();
        this.cbAllFromRight = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Link Properties");
        this.setName("LinkPropertiesDialog");
        this.setResizable(false);
        this.bOk.setText("OK");
        this.bOk.setName("bOk");
        this.bOk.setPreferredSize(new Dimension(73, 23));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkPropertiesDialog.this.bOkActionPerformed(evt);
            }
        });
        this.bCancel.setText("Cancel");
        this.bCancel.setName("bCancel");
        this.bCancel.setPreferredSize(new Dimension(73, 23));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkPropertiesDialog.this.bCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Join Expression"));
        this.jPanel1.setName("label5");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.textExpression, -1, 408, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.textExpression, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Left Object"));
        this.jPanel2.setName("label1");
        this.cbAllFromLeft.setText("Select All From Left");
        this.cbAllFromLeft.setName("cbAllFromLeft");
        this.cbAllFromLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkPropertiesDialog.this.cbAllFromLeftActionPerformed(evt);
            }
        });
        this.textLeftObj.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbAllFromLeft, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.textLeftObj, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.textLeftObj, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAllFromLeft).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Right Object"));
        this.jPanel3.setName("label2");
        this.textRightObj.setEditable(false);
        this.cbAllFromRight.setText("Select All From Right");
        this.cbAllFromRight.setName("cbAllFromRight");
        this.cbAllFromRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinkPropertiesDialog.this.cbAllFromRightActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbAllFromRight, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.textRightObj, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE)).addGap(10, 10, 10)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.textRightObj, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAllFromRight).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.bOk, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCancel, -2, 90, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bCancel, -2, -1, -2).addComponent(this.bOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.dialogResult = true;
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = false;
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void cbAllFromLeftActionPerformed(ActionEvent evt) {
        if (this.cbAllFromLeft.isSelected() && (this.link.getPlace() == LinkPlace.Where || !this.link.getSQLContext().getSyntaxProvider().isSupportFullANSIJoin())) {
            this.cbAllFromRight.setSelected(false);
        }
    }

    private void cbAllFromRightActionPerformed(ActionEvent evt) {
        if (this.cbAllFromRight.isSelected() && (this.link.getPlace() == LinkPlace.Where || !this.link.getSQLContext().getSyntaxProvider().isSupportFullANSIJoin())) {
            this.cbAllFromLeft.setSelected(false);
        }
    }

    private void loadObjects(boolean reverse) {
        this.reverseDatasources = reverse;
        if (!reverse) {
            this.left = this.link.getLeftDatasource();
            this.right = this.link.getRightDatasource();
            this.cbAllFromLeft.setSelected(this.link.getLeftType() == LinkSideType.Outer);
            this.cbAllFromRight.setSelected(this.link.getRightType() == LinkSideType.Outer);
        } else {
            this.left = this.link.getRightDatasource();
            this.right = this.link.getLeftDatasource();
            this.cbAllFromLeft.setSelected(this.link.getRightType() == LinkSideType.Outer);
            this.cbAllFromRight.setSelected(this.link.getLeftType() == LinkSideType.Outer);
        }
        this.textLeftObj.setText(this.left.getDataSourceName());
        this.textRightObj.setText(this.right.getDataSourceName());
        if (this.link.getPlace() == LinkPlace.Where) {
            if (this.isSupportOuterJoinsInWhereClause()) {
                this.cbAllFromLeft.setEnabled(true);
                this.cbAllFromRight.setEnabled(true);
            } else {
                this.cbAllFromLeft.setEnabled(false);
                this.cbAllFromRight.setEnabled(false);
            }
        } else {
            this.cbAllFromLeft.setEnabled(true);
            this.cbAllFromRight.setEnabled(true);
        }
    }

    @Override
    protected void loadProps() {
        super.loadProps();
        this.link = (Link)this.obj;
        this.expr = this.link.getLinkExpression();
        this.loadObjects(false);
        if (this.expr != null) {
            this.textExpression.setText(this.expr.getSimpleSQL(this.sqlContext.getSQLBuilderExpression()));
        }
        this.textExpression.setEnabled(this.link.getQueryBuilder().getLinkOptions().getLinkManipulations() == LinkManipulations.Allow);
        this.textExpression.requestFocus();
    }

    @Override
    protected void saveProps() {
        super.saveProps();
        LinkChangingEvent linkChangingEvent = new LinkChangingEvent(this.link.getQueryBuilder(), this.link);
        this.link.getQueryBuilder().fireLinkChangingEvent(linkChangingEvent);
        if (linkChangingEvent.abort) {
            return;
        }
        if (this.newExpr != null) {
            ArrayList lCTE = new ArrayList();
            ArrayList lFromObj = new ArrayList();
            this.link.gatherPrepareAndFixupContext(lCTE, lFromObj, true);
            this.newExpr.prepareAndFixupRecursive(lCTE, lFromObj);
        }
        this.link.setLinkExpression(this.newExpr);
        Class newType = !this.reverseDatasources ? (this.cbAllFromLeft.isSelected() ? (this.cbAllFromRight.isSelected() ? SQLJoinKindFull.class : SQLJoinKindLeft.class) : (this.cbAllFromRight.isSelected() ? SQLJoinKindRight.class : SQLJoinKindInner.class)) : (this.cbAllFromLeft.isSelected() ? (this.cbAllFromRight.isSelected() ? SQLJoinKindFull.class : SQLJoinKindRight.class) : (this.cbAllFromRight.isSelected() ? SQLJoinKindLeft.class : SQLJoinKindInner.class));
        this.link.setJoinKindClass(newType);
        if (this.link.datasourceOwner != null) {
            this.link.datasourceOwner.notifySQLUpdated();
        }
        LinkChangedEvent linkChangedEvent = new LinkChangedEvent(this.link.getQueryBuilder(), this.link);
        this.link.getQueryBuilder().fireLinkChangedEvent(linkChangedEvent);
    }

    @Override
    protected void checkCanClose() throws Exception {
        super.checkCanClose();
        if (this.dialogResult && !this.showSimplePanel) {
            this.newExpr = this.link.getSQLContext().parseLogicalExpression(this.textExpression.getText(), true);
            if (this.newExpr == null) {
                throw new QueryBuilderException(String.format(Helpers.localizer.getString("strBadExpression", "\"%1$s\" is invalid expression."), this.textExpression.getText()));
            }
        }
    }

    private boolean isSupportOuterJoinsInWhereClause() {
        if (this.link.getQueryBuilder().getSyntaxProvider().isSupportOracleJoins()) {
            return true;
        }
        if (this.link.getQueryBuilder().getSyntaxProvider().isSupportTransactSQLJoins()) {
            SQLExpressionItem ei = Helpers.expressionRemoveBrackets(this.expr);
            if (ei != null && ei instanceof SQLExpressionOperatorBinary) {
                SQLExpressionOperatorBinary eob = (SQLExpressionOperatorBinary)ei;
                return eob.operatorObj != null && (eob.operatorObj.operatorName.equals("=") || eob.operatorObj.operatorName.equals("*=") || eob.operatorObj.operatorName.equals("=*"));
            }
            return false;
        }
        return false;
    }
}

