/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterAccess;
import com.adbs.querybuilder.LinkPainterFriendlyName;
import com.adbs.querybuilder.QueryBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinkPainters
extends ArrayList<Class> {
    public static String getPainterFriendlyName(Class painterClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = painterClass.getAnnotations()) {
            if (!(annotation instanceof LinkPainterFriendlyName)) continue;
            return ((LinkPainterFriendlyName)annotation).value();
        }
        return "Unnamed Link Painter";
    }

    public String getPainterFriendlyName(int i) {
        if (i >= 0 && i < this.size()) {
            return LinkPainters.getPainterFriendlyName((Class)this.get(i));
        }
        return "Non-registered Link Painter";
    }

    public void registerPainter(Class painterClass) {
        this.add(painterClass);
    }

    public LinkPainter createByType(Class type, QueryBuilder queryBuilder) {
        for (int i = 0; i < this.size(); ++i) {
            if (type != this.get(i)) continue;
            try {
                Constructor c = ((Class)this.get(i)).getConstructor(QueryBuilder.class);
                return (LinkPainter)c.newInstance(queryBuilder);
            }
            catch (Exception ex) {
                Logger.getLogger(LinkPainters.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public LinkPainter createByName(String name, QueryBuilder queryBuilder) {
        for (int i = 0; i < this.size(); ++i) {
            if (!name.equals(((Class)this.get(i)).getName())) continue;
            try {
                Constructor c = ((Class)this.get(i)).getConstructor(QueryBuilder.class);
                return (LinkPainter)c.newInstance(queryBuilder);
            }
            catch (Exception ex) {
                Logger.getLogger(LinkPainters.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new LinkPainterAccess(queryBuilder);
    }

    public LinkPainter createByFriendlyName(String name, QueryBuilder queryBuilder) {
        for (int i = 0; i < this.size(); ++i) {
            if (!name.equals(LinkPainters.getPainterFriendlyName((Class)this.get(i)))) continue;
            try {
                Constructor c = ((Class)this.get(i)).getConstructor(QueryBuilder.class);
                return (LinkPainter)c.newInstance(queryBuilder);
            }
            catch (Exception ex) {
                Logger.getLogger(LinkPainters.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new LinkPainterAccess(queryBuilder);
    }

    public String[] getPaintersFriendlyNames() {
        String[] s = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            s[i] = this.getPainterFriendlyName(i);
        }
        return s;
    }
}

