/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.BaseSQLBuilder;
import com.adbs.utils.Constants;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class GeneralPage
extends BasePropertyPanel {
    private static final long serialVersionUID = 1L;
    private BaseSQLBuilder builder = null;
    private JCheckBox cbWordWrap;
    private JComboBox comboKeywordsCasing;
    private JLabel label12;
    private JLabel lblCasing;
    private JSpinner updownRightMargin;

    public GeneralPage(BaseSQLBuilder builder) {
        this.builder = builder;
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        this.cbWordWrap.setSelected(builder.getRightMargin() != 0);
        this.updownRightMargin.setEnabled(this.cbWordWrap.isSelected());
        if (builder.getRightMargin() == 0) {
            this.updownRightMargin.setValue(80);
        } else {
            this.updownRightMargin.setValue(builder.getRightMargin());
        }
        this.comboKeywordsCasing.removeAllItems();
        this.comboKeywordsCasing.addItem(Helpers.localizer.getString("strCapitalized", Constants.strCapitalized));
        this.comboKeywordsCasing.addItem(Helpers.localizer.getString("strUppercase", Constants.strUppercase));
        this.comboKeywordsCasing.addItem(Helpers.localizer.getString("strLowercase", Constants.strLowercase));
        this.comboKeywordsCasing.setSelectedIndex(builder.getKeywordFormat().ordinal());
        this.cbWordWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPage.this.updownRightMargin.setEnabled(GeneralPage.this.cbWordWrap.isSelected());
                GeneralPage.this.setModified(true);
            }
        });
        this.updownRightMargin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneralPage.this.setModified(true);
            }
        });
        this.comboKeywordsCasing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPage.this.setModified(true);
            }
        });
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            if (this.cbWordWrap.isSelected()) {
                this.builder.setRightMargin((Integer)this.updownRightMargin.getValue());
            } else {
                this.builder.setRightMargin(0);
            }
            this.builder.setKeywordFormat(KeywordFormat.values()[this.comboKeywordsCasing.getSelectedIndex()]);
        }
    }

    private void initComponents() {
        this.cbWordWrap = new JCheckBox();
        this.label12 = new JLabel();
        this.updownRightMargin = new JSpinner();
        this.lblCasing = new JLabel();
        this.comboKeywordsCasing = new JComboBox();
        this.setBackground(new Color(255, 255, 255));
        this.setName("GeneralPage");
        this.cbWordWrap.setText("Enable word wrap");
        this.cbWordWrap.setHorizontalTextPosition(2);
        this.cbWordWrap.setIconTextGap(58);
        this.cbWordWrap.setMargin(new Insets(2, 0, 2, 2));
        this.cbWordWrap.setName("cbWordWrap");
        this.cbWordWrap.setOpaque(false);
        this.label12.setText("Maximum characters in line");
        this.label12.setName("label12");
        this.updownRightMargin.setModel(new SpinnerNumberModel(80, 1, 1000, 1));
        this.lblCasing.setText("Keywords casing");
        this.lblCasing.setName("lblCasing");
        this.comboKeywordsCasing.setModel(new DefaultComboBoxModel<String>(new String[]{" ", " ", " ", " "}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbWordWrap, -1, 386, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label12).addComponent(this.lblCasing)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.updownRightMargin, -2, 42, -2).addComponent(this.comboKeywordsCasing, -2, 155, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbWordWrap).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label12).addComponent(this.updownRightMargin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCasing).addComponent(this.comboKeywordsCasing, -2, -1, -2)).addContainerGap(212, Short.MAX_VALUE)));
    }
}

