/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BasePropertiesDialog;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DataSourcePropertiesDialog
extends BasePropertiesDialog {
    private static final long serialVersionUID = 1L;
    private DataSource ds;
    private DataSourceObject dso;
    private String oldName;
    private String oldAlias;
    private JButton bCancel;
    private JButton bOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField textAlias;
    private JTextField textObj;

    public DataSourcePropertiesDialog(Window parent) {
        super(parent);
        this.initComponents();
        Helpers.localizer.localizeDialog(this);
        this.setLocationRelativeTo(parent);
        this.textAlias.requestFocus();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textObj = new JTextField();
        this.jLabel2 = new JLabel();
        this.textAlias = new JTextField();
        this.bOk = new JButton();
        this.bCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Source Properties");
        this.setName("DataSourcePropertiesDialog");
        this.jLabel1.setText("Object:");
        this.jLabel1.setName("lObject");
        this.textObj.setEditable(false);
        this.jLabel2.setText("Alias:");
        this.jLabel2.setName("lAlias");
        this.bOk.setText("OK");
        this.bOk.setName("bOk");
        this.bOk.setPreferredSize(new Dimension(73, 23));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourcePropertiesDialog.this.bOkActionPerformed(evt);
            }
        });
        this.bCancel.setText("Cancel");
        this.bCancel.setName("bCancel");
        this.bCancel.setPreferredSize(new Dimension(73, 23));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourcePropertiesDialog.this.bCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textObj, -1, 330, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.textAlias, -1, 286, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.bOk, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bCancel, -2, 90, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textObj, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.textAlias, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bCancel, -2, -1, -2).addComponent(this.bOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.dialogResult = true;
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = false;
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    @Override
    protected void loadProps() {
        super.loadProps();
        this.ds = (DataSource)this.obj;
        this.dso = this.ds instanceof DataSourceObject ? (DataSourceObject)this.ds : null;
        this.textObj.setText(this.ds.astFromSource.getSimpleExpression(this.sqlContext.getSQLBuilderExpression()));
        this.textAlias.setText(this.ds.getAlias());
        this.oldAlias = this.ds.getAlias();
        if (this.dso != null && this.dso.getSubQueryCTE() != null) {
            this.textObj.setEditable(true);
            this.oldName = this.textObj.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveProps() {
        super.saveProps();
        String newAlias = this.textAlias.getText();
        if (!newAlias.equals(this.oldAlias)) {
            if (Str.IsNullOrEmpty(newAlias) && this.ds instanceof DataSourceQuery) {
                this.ds.setAlias(this.ds.getQueryBuilder().createUniqueQueryNameStr());
            } else {
                this.ds.setAlias(newAlias);
            }
        }
        String newName = this.textObj.getText();
        if (this.textObj.isEditable() && !newName.equals(this.oldName)) {
            AstTokenIdentifier id = this.sqlContext.parseIdentifierQuoteIfNeed(newName);
            assert (this.dso != null);
            assert (this.dso.getSubQueryCTE() != null);
            try {
                this.dso.getSubQueryCTE().renameCTE(id);
            }
            finally {
                id.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkCanClose() throws Exception {
        super.checkCanClose();
        if (this.dialogResult) {
            String newAlias = this.textAlias.getText();
            if (!newAlias.equals(this.oldAlias)) {
                AstTokenIdentifier id = this.sqlContext.parseIdentifierQuoteIfNeed(newAlias);
                try {
                    if (!this.ds.getQuery().isUniqueAlias(id)) {
                        throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorDuplicatedAlias", "Alias \"%1$s\" already exists."), newAlias));
                    }
                }
                finally {
                    id.dispose();
                }
            }
            String newName = this.textObj.getText();
            if (this.textObj.isEditable() && !newName.equals(this.oldName)) {
                assert (this.dso != null);
                assert (this.dso.getSubQueryCTE() != null);
                AstTokenIdentifier id = this.sqlContext.parseIdentifierQuoteIfNeed(newName);
                try {
                    if (!this.dso.getSubQueryCTE().canRenameCTETo(id)) {
                        throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorDuplicatedName", "Name \"%1$s\" already exists."), newName));
                    }
                }
                finally {
                    id.dispose();
                }
            }
        }
    }
}

