/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstNodeNewLine;
import com.adbs.ast.AstNodeSpace;
import com.adbs.ast.AstTokenBuiltin;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.AstTokenKeyword;
import com.adbs.ast.AstTokenNumber;
import com.adbs.ast.AstTokenString;
import com.adbs.ast.AstTokenSymbol;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderItemListFormat;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.utils.Helpers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AstNodeWithList
extends AstNode {
    private final ArrayList<AstNode> items = new ArrayList();
    protected Class minNodeClass = null;

    public AstNodeWithList(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public int getCount() {
        return this.items.size();
    }

    public void setCount(int value) {
        Helpers.listSetSize(this.items, value, true);
    }

    public AstNode get(int index) {
        return this.items.get(index);
    }

    public void set(int index, AstNode value) {
        this.items.set(index, value);
    }

    public int indexOf(AstNode value) {
        return this.items.indexOf(value);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof AstNodeWithList) {
            this.clear();
            for (int i = 0; i < ((AstNodeWithList)source).getCount(); ++i) {
                this.add(((AstNodeWithList)source).get(i).clone(this.sqlContext));
            }
        }
    }

    @Override
    public void getMyChildren(List list) {
        super.getMyChildren(list);
        int index = this.findFirstChildIndexForClass(AstNodeWithList.class);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            list.add(index, this.get(i));
        }
    }

    @Override
    public void moveSubQueryInProxy(Object parameter, Class cls) {
        super.moveSubQueryInProxy(parameter, cls);
        for (int i = 0; i < this.getCount(); ++i) {
            AstNode o = this.get(i);
            if (o == null || !(o instanceof SQLSubSelectStatement)) continue;
            this.extract(i);
            try {
                Constructor c = cls.getConstructor(BaseSQLContext.class, Object.class, AstNodeBase.class, SQLSubSelectStatement.class);
                this.insert(i, (AstNode)c.newInstance(this.sqlContext, parameter, this, o));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(AstNodeWithList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public int add(AstNode item) {
        assert (item != null);
        assert (this.minNodeClass == null || item.getClass() == this.minNodeClass || this.minNodeClass.isAssignableFrom(item.getClass()));
        assert (item.getSQLContext() == this.sqlContext);
        this.items.add(item);
        return this.items.size() - 1;
    }

    public int remove(AstNode item) {
        int x = this.items.indexOf(item);
        if (x != -1) {
            this.items.remove(x);
        }
        item.dispose();
        return x;
    }

    public void delete(int index) {
        AstNode item = this.get(index);
        ((AstNodeBase)item).dispose();
        this.items.remove(index);
    }

    public AstNode extract(AstNode item) {
        this.items.remove(item);
        return item;
    }

    public AstNode extract(int i) {
        AstNode item = this.items.get(i);
        this.items.remove(i);
        return item;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
    }

    public void insert(int index, AstNode obj) {
        assert (obj != null);
        assert (this.minNodeClass == null || obj.getClass() == this.minNodeClass || this.minNodeClass.isAssignableFrom(obj.getClass()));
        assert (obj.getSQLContext() == this.sqlContext);
        this.items.add(index, obj);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).buildSQL(builder, format);
        }
    }

    public void buildSQLList(SQLBuilder builder, SQLBuilderSelectFormat format, SQLBuilderItemListFormat listFormat, AstNode separator) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).buildSQL(builder, format);
            if (i >= this.getCount() - 1) continue;
            if (listFormat.getNewLineBeforeComma()) {
                builder.newLine();
            }
            if (separator != null) {
                separator.buildSQL(builder, format);
            }
            builder.newLineOrSpace(listFormat.getNewLineAfterItem());
        }
    }

    public void buildList(SQLBuilder builder, SQLBuilderSelectFormat format, AstNode separator) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).buildSQL(builder, format);
            if (separator == null || i >= this.getCount() - 1) continue;
            separator.buildSQL(builder, format);
        }
    }

    public void addSpace(int newLineIndex) {
        this.add(new AstNodeSpace(this.sqlContext, newLineIndex));
    }

    public void addSpace() {
        this.add(new AstNodeSpace(this.sqlContext, 2));
    }

    public void aSp(int newLineIndex) {
        this.addSpace(newLineIndex);
    }

    public void aSp() {
        this.addSpace(2);
    }

    public void addNode(AstNode node, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(node);
    }

    public void addNode(AstNode node, boolean spaceBefore) {
        this.addNode(node, spaceBefore, 2);
    }

    public void addNode(AstNode node) {
        this.addNode(node, false, 2);
    }

    public void addKeyword(String keyword, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenKeyword(this.sqlContext, keyword));
    }

    public void addKeyword(String keyword, boolean spaceBefore) {
        this.addKeyword(keyword, spaceBefore, 2);
    }

    public void addKeyword(String keyword) {
        this.addKeyword(keyword, false, 2);
    }

    public void aK(String keyword, boolean spaceBefore, int newLineIndex) {
        this.addKeyword(keyword, spaceBefore, newLineIndex);
    }

    public void aK(String keyword, boolean spaceBefore) {
        this.addKeyword(keyword, spaceBefore, 2);
    }

    public void aK(String keyword) {
        this.addKeyword(keyword, false, 2);
    }

    public void addBuiltin(String builtin, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenBuiltin(this.sqlContext, builtin));
    }

    public void addBuiltin(String builtin, boolean spaceBefore) {
        this.addBuiltin(builtin, spaceBefore, 2);
    }

    public void addBuiltin(String builtin) {
        this.addBuiltin(builtin, false, 2);
    }

    public void aB(String builtin, boolean spaceBefore, int newLineIndex) {
        this.addBuiltin(builtin, spaceBefore, newLineIndex);
    }

    public void aB(String builtin, boolean spaceBefore) {
        this.addBuiltin(builtin, spaceBefore, 2);
    }

    public void aB(String builtin) {
        this.addBuiltin(builtin, false, 2);
    }

    public void addIdentifier(String identifier, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenIdentifier(this.sqlContext, identifier));
    }

    public void addIdentifier(String identifier, boolean spaceBefore) {
        this.addIdentifier(identifier, spaceBefore, 2);
    }

    public void addIdentifier(String identifier) {
        this.addIdentifier(identifier, false, 2);
    }

    public void aI(String identifier, boolean spaceBefore, int newLineIndex) {
        this.addIdentifier(identifier, spaceBefore, newLineIndex);
    }

    public void aI(String identifier, boolean spaceBefore) {
        this.addIdentifier(identifier, spaceBefore, 2);
    }

    public void aI(String identifier) {
        this.addIdentifier(identifier, false, 2);
    }

    public void addSymbol(String symbol, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenSymbol(this.sqlContext, symbol));
    }

    public void addSymbol(String symbol, boolean spaceBefore) {
        this.addSymbol(symbol, spaceBefore, 2);
    }

    public void addSymbol(String symbol) {
        this.addSymbol(symbol, false, 2);
    }

    public AstNodeWithList Symbol(String symbol) {
        this.addSymbol(symbol);
        return this;
    }

    public void aSy(String symbol, boolean spaceBefore, int newLineIndex) {
        this.addSymbol(symbol, spaceBefore, newLineIndex);
    }

    public void aSy(String symbol, boolean spaceBefore) {
        this.addSymbol(symbol, spaceBefore, 2);
    }

    public void aSy(String symbol) {
        this.addSymbol(symbol, false, 2);
    }

    public void addNumber(String number, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenNumber(this.sqlContext, number));
    }

    public void addNumber(String number, boolean spaceBefore) {
        this.addNumber(number, spaceBefore, 2);
    }

    public void addNumber(String number) {
        this.addNumber(number, false, 2);
    }

    public void aN(String number, boolean spaceBefore, int newLineIndex) {
        this.addNumber(number, spaceBefore, newLineIndex);
    }

    public void aN(String number, boolean spaceBefore) {
        this.addNumber(number, spaceBefore, 2);
    }

    public void aN(String number) {
        this.addNumber(number, false, 2);
    }

    public void addString(String str, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenString(this.sqlContext, str));
    }

    public void addString(String str, boolean spaceBefore) {
        this.addString(str, spaceBefore, 2);
    }

    public void addString(String str) {
        this.addString(str, false, 2);
    }

    public void aSt(String str, boolean spaceBefore, int newLineIndex) {
        this.addString(str, spaceBefore, newLineIndex);
    }

    public void aSt(String str, boolean spaceBefore) {
        this.addString(str, spaceBefore, 2);
    }

    public void aSt(String str) {
        this.addString(str, false, 2);
    }

    public void insertSpace(int index, int newLineIndex) {
        this.insert(index, new AstNodeSpace(this.sqlContext, newLineIndex));
    }

    public void insertNewLine(int index) {
        this.insert(index, new AstNodeNewLine(this.sqlContext));
    }

    public void insertNode(int index, AstNode node, boolean spaceBefore, int newLineIndex) {
        this.insert(index, node);
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertNode(int index, AstNode node, boolean spaceBefore) {
        this.insertNode(index, node, spaceBefore, 2);
    }

    public void insertNode(int index, AstNode node) {
        this.insertNode(index, node, false, 2);
    }

    public void insertKeyword(int index, String keyword, boolean spaceBefore, int newLineIndex) {
        this.insert(index, new AstTokenKeyword(this.sqlContext, keyword));
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertKeyword(int index, String keyword, boolean spaceBefore) {
        this.insertKeyword(index, keyword, spaceBefore, 2);
    }

    public void insertKeyword(int index, String keyword) {
        this.insertKeyword(index, keyword, false, 2);
    }

    public void insertIdentifier(int index, String identifier, boolean spaceBefore, int newLineIndex) {
        this.insert(index, new AstTokenIdentifier(this.sqlContext, identifier));
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertIdentifier(int index, String identifier, boolean spaceBefore) {
        this.insertIdentifier(index, identifier, spaceBefore, 2);
    }

    public void insertIdentifier(int index, String identifier) {
        this.insertIdentifier(index, identifier, false, 2);
    }

    public void insertSymbol(int index, String symbol, boolean spaceBefore, int newLineIndex) {
        this.insert(index, new AstTokenSymbol(this.sqlContext, symbol));
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertSymbol(int index, String symbol, boolean spaceBefore) {
        this.insertSymbol(index, symbol, spaceBefore, 2);
    }

    public void insertSymbol(int index, String symbol) {
        this.insertSymbol(index, symbol, false, 2);
    }

    public void insertNumber(int index, String number, boolean spaceBefore, int newLineIndex) {
        this.insert(index, new AstTokenNumber(this.sqlContext, number));
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertNumber(int index, String number, boolean spaceBefore) {
        this.insertNumber(index, number, spaceBefore, 2);
    }

    public void insertNumber(int index, String number) {
        this.insertNumber(index, number, false, 2);
    }

    public void insertString(int index, String str, boolean spaceBefore, int newLineIndex) {
        this.insert(index, new AstTokenString(this.sqlContext, str));
        if (spaceBefore) {
            this.insertSpace(index, newLineIndex);
        }
    }

    public void insertString(int index, String str, boolean spaceBefore) {
        this.insertString(index, str, spaceBefore, 2);
    }

    public void insertString(int index, String str) {
        this.insertString(index, str, false, 2);
    }

    public void addNewLine() {
        this.add(new AstNodeNewLine(this.sqlContext));
    }

    public void aNL() {
        this.addNewLine();
    }

    public AstNodeWithList space(int newLineIndex) {
        this.addSpace(newLineIndex);
        return this;
    }

    public AstNodeWithList space() {
        return this.space(2);
    }

    public AstNodeWithList newLine() {
        this.addNewLine();
        return this;
    }

    public AstNodeWithList node(AstNode node) {
        this.addNode(node);
        return this;
    }

    public AstNodeWithList keyword(String keyword) {
        this.addKeyword(keyword);
        return this;
    }

    public AstNodeWithList builtin(String builtin) {
        this.addBuiltin(builtin);
        return this;
    }

    public AstNodeWithList identifier(String identifier) {
        this.addIdentifier(identifier);
        return this;
    }

    public AstNodeWithList symbol(String symbol) {
        this.addSymbol(symbol);
        return this;
    }

    public AstNodeWithList number(String number) {
        this.addNumber(number);
        return this;
    }

    public AstNodeWithList string(String string) {
        this.addString(string);
        return this;
    }
}

