/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import oracle.dbtools.raptor.startup.HomeUtils;

abstract class Tester {
    private File m_home;

    protected static final void testStepStart(String string) {
        System.out.print(MessageFormat.format(HomeUtils.getResourceString("LOG_MESSAGE_TEST_START"), string));
    }

    protected static final boolean testStepPass(String ... stringArray) {
        System.out.println(HomeUtils.getResourceString("LOG_MESSAGE_TEST_PASS"));
        for (String string : stringArray) {
            Tester.outputDetail(string);
        }
        return true;
    }

    protected static final boolean testStepFailed(String ... stringArray) {
        System.out.println(HomeUtils.getResourceString("LOG_MESSAGE_TEST_FAILURE"));
        for (String string : stringArray) {
            Tester.outputDetail(string);
        }
        return false;
    }

    private static void outputDetail(String string) {
        System.out.println("  " + string);
    }

    protected Tester(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Client directory not specified");
        }
        this.m_home = new File(stringArray[0]);
    }

    protected abstract File getDriverJar();

    protected abstract File getNativeDir();

    protected final File getHomeDirectory() {
        return this.m_home;
    }

    protected abstract String getHomeType();

    protected final void doTest() {
        Driver driver;
        System.out.println(MessageFormat.format(HomeUtils.getResourceString("LOG_START"), this.getHomeType(), this.getHomeDirectory().getPath()));
        if (this.checkPath() && (driver = this.loadDriver()) != null && this.checkVersion(driver)) {
            if (!this.testConnection(driver)) {
                String[] stringArray;
                String string = MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_PATH_DETAILS"), "java.library.path", HomeUtils.getOSPathVariable(), this.getNativeDir().getAbsolutePath(), System.getProperty("java.library.path"));
                for (String string2 : stringArray = string.split("\n")) {
                    Tester.outputDetail(string2);
                }
            } else {
                System.out.println(HomeUtils.getResourceString("LOG_SUCCESS"));
            }
        }
    }

    private boolean checkPath() {
        Tester.testStepStart(HomeUtils.getResourceString("MESSAGE_START_DIRECTORY_CHECK"));
        File file = this.getHomeDirectory();
        if (file.exists()) {
            if (file.isDirectory()) {
                return Tester.testStepPass(new String[0]);
            }
            return Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_NON_DIRECTORY"), file.getPath()));
        }
        return Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_DIRECTORY_NON_EXIST"), file.getPath()));
    }

    private Driver loadDriver() {
        Tester.testStepStart(HomeUtils.getResourceString("MESSAGE_START_DRIVER_LOAD"));
        File file = this.getDriverJar();
        if (file.exists() && file.isFile()) {
            try {
                URL uRL = file.toURI().toURL();
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
                try {
                    Class<Driver> clazz = uRLClassLoader.loadClass("oracle.jdbc.OracleDriver").asSubclass(Driver.class);
                    Driver driver = clazz.newInstance();
                    Tester.testStepPass(new String[0]);
                    return driver;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_LOAD_DRIVER"), file.getPath()));
                }
                catch (InstantiationException instantiationException) {
                    Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_INSTANTIATE_DRIVER"), "oracle.jdbc.OracleDriver"));
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_ACCESS_DRIVER"), "oracle.jdbc.OracleDriver"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_UNKNOWN"), file.getPath()));
            }
        } else {
            Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_BAD_FILE"), file.getPath()));
        }
        return null;
    }

    private boolean checkVersion(Driver driver) {
        Tester.testStepStart(HomeUtils.getResourceString("MESSAGE_START_VERSION_CHECK"));
        try {
            Method method = driver.getClass().getMethod("getDriverVersion", new Class[0]);
            String string = (String)method.invoke(null, new Object[0]);
            String[] stringArray = string.split("\\.");
            if (HomeUtils.checkVersion(stringArray)) {
                Tester.testStepPass(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_SUCCESS_VERSION_CHECK"), string));
                return true;
            }
            Tester.testStepFailed(MessageFormat.format(HomeUtils.getResourceString("MESSAGE_FAILURE_VERSION_CHECK"), "23.0", string));
        }
        catch (Exception exception) {
            Tester.testStepFailed(HomeUtils.getResourceString("MESSAGE_FAILURE_BAD_VERSION"));
        }
        return false;
    }

    private boolean testConnection(Driver driver) {
        boolean bl = false;
        Tester.testStepStart(HomeUtils.getResourceString("MESSAGE_START_CONNECTION_TEST"));
        Properties properties = new Properties();
        properties.put("user", "sqldev");
        properties.put("password", "sqldev");
        try {
            Connection connection = driver.connect("jdbc:oracle:oci:@localhost", properties);
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = Tester.testStepPass(new String[0]);
        }
        catch (SQLException sQLException) {
            bl = Tester.testStepPass(new String[0]);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Tester.testStepFailed(HomeUtils.getResourceString("MESSAGE_FAILURE_CONNECTION_TEST"));
        }
        return bl;
    }
}

