/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.PullManifestParser;
import javax.ide.extension.spi.ScopedMap;
import javax.ide.extension.spi.XMLParsingUtils;

public class DeferredElementVisitorHelper {
    private List<TopLevelElementData> _topLevelElements = new CopyOnWriteArrayList<TopLevelElementData>();
    private ElementVisitorFactory _recordElementDataVisitorFactory = new RecordElementDataVisitorFactory();
    private RecordElementDataVisitor _recordElementDataVisitor = new RecordElementDataVisitor();
    private static final String _CURRENT_PARENT = "deferred-element-visitor-current-parent";
    private final WeakHashMap<ElementVisitor, Integer> _visitorToAlreadySeenIndex = new WeakHashMap();

    public void recordTopLevelElementStart(ElementStartContext context) {
        TopLevelElementData elementData = new TopLevelElementData(context.getElementName(), this._getCurrentLocator(context), context.getScopeData());
        this._recordAttributes(context, elementData);
        this._topLevelElements.add(elementData);
        this._setCurrentParent(context, elementData);
        context.registerVisitorFactory(this._recordElementDataVisitorFactory);
    }

    public void recordTopLevelElementEnd(ElementEndContext context) {
        ElementData elementData = this._getCurrentParent(context);
        this._recordText(context, elementData);
    }

    public void visitRecordedData(DefaultElementContext context, ElementVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor == null");
        }
        int size = this._topLevelElements.size();
        for (int i = 0; i < size; ++i) {
            TopLevelElementData element = this._topLevelElements.get(i);
            context.getScopeData().putAll(element.getRecordedScopeData());
            this._visitElement(visitor, element, context);
            context.reset();
        }
        this._visitorToAlreadySeenIndex.put(visitor, size);
    }

    public void visitNewlyRecordedData(DefaultElementContext context, ElementVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor == null");
        }
        Integer alreadySeen = this._visitorToAlreadySeenIndex.get(visitor);
        if (alreadySeen == null) {
            alreadySeen = 0;
        }
        int size = this._topLevelElements.size();
        for (int i = alreadySeen.intValue(); i < size; ++i) {
            TopLevelElementData element = this._topLevelElements.get(i);
            context.getScopeData().putAll(element.getRecordedScopeData());
            this._visitElement(visitor, element, context);
            context.reset();
        }
        this._visitorToAlreadySeenIndex.put(visitor, size);
    }

    public void clearRecordedData() {
        this._topLevelElements.clear();
        this._visitorToAlreadySeenIndex.clear();
    }

    private void _visitElement(ElementVisitor visitor, ElementData element, DefaultElementContext context) {
        ElementName name = element.getName();
        context.beginElement(name.getNamespaceURI(), name.getLocalName(), element.getAttributes());
        this._setCurrentLocator(context, element.getRecordedLocator());
        if (visitor != null) {
            try {
                visitor.start(context);
            }
            catch (Throwable re) {
                if (re instanceof ThreadDeath) {
                    throw (ThreadDeath)re;
                }
                ExtensionLogRecord r = new ExtensionLogRecord(context, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                r.setThrown(re);
                context.getLogger().log(r);
            }
        }
        context.postBeginElement();
        for (ElementData child : element.getChildren()) {
            ElementVisitor childVisitor = context.getVisitorForStartElement(child.getName());
            this._visitElement(childVisitor, child, context);
        }
        String text = element.getText();
        if (text != null && text.length() > 0) {
            char[] chars = text.toCharArray();
            context.appendCharacters(chars, 0, chars.length);
        }
        context.endElement(name.getNamespaceURI(), name.getLocalName());
        if (visitor != null) {
            try {
                visitor.end(context);
            }
            catch (Throwable re) {
                if (re instanceof ThreadDeath) {
                    throw (ThreadDeath)re;
                }
                ExtensionLogRecord r = new ExtensionLogRecord(context, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                r.setThrown(re);
                context.getLogger().log(r);
            }
        }
        context.postEndElement();
    }

    private void _setCurrentParent(ElementContext context, ElementData elementData) {
        context.getScopeData().put(_CURRENT_PARENT, elementData);
    }

    private ElementData _getCurrentParent(ElementContext context) {
        return (ElementData)context.getScopeData().get(_CURRENT_PARENT);
    }

    private void _setCurrentLocator(ElementContext context, LocationAdapter locator) {
        context.getScopeData().put("xml.locator", locator);
    }

    private LocationAdapter _getCurrentLocator(ElementContext context) {
        return (LocationAdapter)context.getScopeData().get("xml.locator");
    }

    private void _recordAttributes(ElementStartContext context, ElementData elementData) {
        if (context instanceof DefaultElementContext) {
            DefaultElementContext.Attributes attributes = ((DefaultElementContext)context).getRawAttributes();
            if (attributes != null) {
                elementData.getAttributes().setAttributes(attributes);
            }
        } else {
            Collection<String> attrNames = context.getAttributeNames();
            for (String attrName : attrNames) {
                elementData.addAttribute(attrName, context.getAttributeValue(attrName));
            }
        }
    }

    private void _recordText(ElementEndContext context, ElementData elementData) {
        if (context instanceof DefaultElementContext) {
            elementData.setText(((DefaultElementContext)context).getRawText());
        } else {
            elementData.setText(context.getText());
        }
    }

    private class RecordElementDataVisitorFactory
    implements ElementVisitorFactory {
        private RecordElementDataVisitorFactory() {
        }

        @Override
        public ElementVisitor getVisitor(ElementName name) {
            return DeferredElementVisitorHelper.this._recordElementDataVisitor;
        }
    }

    private class RecordElementDataVisitor
    extends ElementVisitor {
        private RecordElementDataVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            ElementData child = new ElementData(context.getElementName(), DeferredElementVisitorHelper.this._getCurrentLocator(context));
            DeferredElementVisitorHelper.this._recordAttributes(context, child);
            ElementData parent = DeferredElementVisitorHelper.this._getCurrentParent(context);
            parent.addChild(child);
            DeferredElementVisitorHelper.this._setCurrentParent(context, child);
            context.registerVisitorFactory(DeferredElementVisitorHelper.this._recordElementDataVisitorFactory);
        }

        @Override
        public void end(ElementEndContext context) {
            ElementData elementData = DeferredElementVisitorHelper.this._getCurrentParent(context);
            DeferredElementVisitorHelper.this._recordText(context, elementData);
        }
    }

    private class TopLevelElementData
    extends ElementData {
        private final Map _recordedScopeData;

        public TopLevelElementData(ElementName name, LocationAdapter locator, Map scopeData) {
            super(name, locator);
            this._recordedScopeData = ScopedMap.copyScopeData(scopeData, Collections.singleton("xml.locator"));
        }

        private Map getRecordedScopeData() {
            return this._recordedScopeData;
        }
    }

    private class ElementData {
        private final ElementName _name;
        private DefaultElementContext.AttributesImpl _attributes = new DefaultElementContext.AttributesImpl();
        private String _text = null;
        private List<ElementData> _children;
        private final LocationAdapter _recordedLocator;

        public ElementData(ElementName name, LocationAdapter locator) {
            this._name = name;
            this._recordedLocator = XMLParsingUtils.copyAndCastToLocationAdapter(locator);
        }

        public ElementName getName() {
            return this._name;
        }

        public void addAttribute(String attrName, String value) {
            this._attributes.addAttribute(new PullManifestParser.StAXAttribute(attrName, value));
        }

        public DefaultElementContext.AttributesImpl getAttributes() {
            return this._attributes;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getText() {
            return this._text;
        }

        public List<ElementData> getChildren() {
            if (this._children == null) {
                return Collections.emptyList();
            }
            return this._children;
        }

        public void addChild(ElementData child) {
            if (this._children == null) {
                this._children = new ArrayList<ElementData>(5);
            }
            this._children.add(child);
        }

        private LocationAdapter getRecordedLocator() {
            return this._recordedLocator;
        }
    }
}

