/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class TopThemeQueries {
    public static final int MAX_ENTRIES = 25;
    private static Hashtable topList = new Hashtable(31);
    private static Entry lowestTimer = null;

    public static final synchronized boolean add(long time, String theme, String dataSrc, String query, String info) {
        String key;
        Entry exists;
        if (dataSrc == null) {
            dataSrc = "nullds";
        }
        if (query == null) {
            query = "nullquery";
        }
        if ((exists = (Entry)topList.get(key = dataSrc.toUpperCase() + "#.#" + theme.toUpperCase())) != null) {
            if (exists.processTime < time) {
                exists.processTime = time;
                exists.query = query;
                exists.info = info;
                if (lowestTimer != null && lowestTimer == exists && topList.size() > 1) {
                    TopThemeQueries.updateLowestTimer();
                }
            }
            return true;
        }
        if (topList.size() < 25) {
            topList.put(key, new Entry(time, theme, dataSrc, query, info));
            TopThemeQueries.updateLowestTimer();
            return true;
        }
        if (time > TopThemeQueries.lowestTimer.processTime) {
            topList.remove(lowestTimer);
            lowestTimer = null;
            topList.put(key, new Entry(time, theme, dataSrc, query, info));
            TopThemeQueries.updateLowestTimer();
            return true;
        }
        return false;
    }

    private static void updateLowestTimer() {
        Enumeration e = topList.elements();
        while (e.hasMoreElements()) {
            Entry ent = (Entry)e.nextElement();
            if (lowestTimer == null) {
                lowestTimer = ent;
                continue;
            }
            if (TopThemeQueries.lowestTimer.processTime <= ent.processTime) continue;
            lowestTimer = ent;
        }
    }

    public static synchronized Entry[] report() {
        int size = topList.size();
        if (size == 0) {
            return new Entry[0];
        }
        ArrayList<Entry> list = new ArrayList<Entry>(size);
        Enumeration e = topList.elements();
        while (e.hasMoreElements()) {
            Entry ent = (Entry)e.nextElement();
            list.add(ent);
        }
        Collections.sort(list);
        Entry[] res = new Entry[size];
        for (int i = 0; i < size; ++i) {
            res[size - i - 1] = (Entry)list.get(i);
        }
        list = null;
        return res;
    }

    public static synchronized String reportAsXML() {
        Entry[] res = TopThemeQueries.report();
        StringBuffer sb = new StringBuffer();
        sb.append("<top_theme_queries>\n");
        for (int i = 0; i < res.length; ++i) {
            Entry e = res[i];
            sb.append("  <theme id=\"" + i + "\">\n");
            sb.append("    <name>" + e.theme + "</name>\n");
            sb.append("    <data_source>" + e.dataSource + "</data_source>\n");
            sb.append("    <time unit=\"ms\">" + e.processTime + "</time>\n");
            sb.append("    <query><![CDATA[\n" + e.query + "\n           ]]>\n    </query>\n");
            sb.append("    <note><![CDATA[" + e.info + "]]></note>\n");
            sb.append("  </theme>\n");
        }
        sb.append("</top_theme_queries>\n");
        return sb.toString();
    }

    public static synchronized void reset() {
        topList.clear();
        lowestTimer = null;
    }

    public static class Entry
    implements Comparable {
        public long processTime = 0L;
        public String query = "";
        public String theme = "";
        public String dataSource = "";
        public String info = "";

        public Entry(long time, String theme, String dataSrc, String query, String info) {
            this.processTime = time;
            this.theme = theme;
            this.dataSource = dataSrc;
            this.query = query;
            this.info = info;
        }

        public int compareTo(Object o) {
            Entry e = (Entry)o;
            return this.processTime > e.processTime ? 1 : (this.processTime < e.processTime ? -1 : 0);
        }
    }
}

