/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.maps.core.Layer;
import oracle.maps.util.PropertySupportObject;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.ui.CreateAnnotationTextTablePanel;
import oracle.spatial.edit.ui.CreateGeometryTablePanel;
import oracle.spatial.edit.ui.CreateTopologyTablePanel;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MVVectorLayerProvider
implements LayerProvider {
    protected MainAppPanel mainApp = null;
    protected String type = SpatialTableMetadata.GEOMETRY_TYPE;
    protected AbstractDataSource dataSource = null;
    protected Vector<SpatialTableMetadata> cache = null;
    protected Hashtable<String, String> tablePKeys = new Hashtable();
    protected Vector<String> topologyNames = null;
    protected static final SpatialTableMetadata NEWLAYER = new SpatialTableMetadata();
    protected TreeCellRenderer cellRenderer = new MyTreeCellRenderer();

    public MVVectorLayerProvider(String type, MainAppPanel mainApp, AbstractDataSource dataSource) {
        this.type = type;
        this.mainApp = mainApp;
        this.dataSource = dataSource;
    }

    @Override
    public String getProviderName() {
        return this.type.substring(0, 1).toUpperCase() + this.type.substring(1).toLowerCase() + " layers";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void clearEditorObjectCache() {
        this.dataSource = null;
        this.cache = null;
        this.tablePKeys = new Hashtable();
        this.topologyNames = null;
    }

    public SpatialTableMetadata[] getEditorObjects() {
        this.fetchLayerMetadata();
        if (this.cache == null) {
            return null;
        }
        Collections.sort(this.cache, new Comparator<SpatialTableMetadata>(){

            @Override
            public int compare(SpatialTableMetadata a, SpatialTableMetadata b) {
                return a.getName().compareTo(b.getName());
            }
        });
        ArrayList<SpatialTableMetadata> list = new ArrayList<SpatialTableMetadata>(this.cache.size() + 1);
        list.add(NEWLAYER);
        for (SpatialTableMetadata stm : this.cache) {
            if (!stm.getType().equals(this.type)) continue;
            list.add(stm);
        }
        return list.toArray(new SpatialTableMetadata[list.size()]);
    }

    @Override
    public Layer getEditorObject(TreePath layerDesc) {
        return null;
    }

    public Layer getEditorObject(Object layerDesc) {
        if (layerDesc == null || layerDesc == NEWLAYER || !(layerDesc instanceof SpatialTableMetadata)) {
            if (this.type.equals(SpatialTableMetadata.ANNOTATION_TYPE)) {
                return this.createAnnotationTextTable();
            }
            if (this.type.equals(SpatialTableMetadata.TOPOFEATURE_TYPE)) {
                return this.createTopologyFeatureTable();
            }
            return this.createGeomTable();
        }
        return this.createLayer((SpatialTableMetadata)layerDesc, null);
    }

    @Override
    public Layer removeEditorObject(TreePath layerDesc) {
        return null;
    }

    @Override
    public Layer createLayer(Element xmlElement) {
        Layer layer = null;
        String className = xmlElement.getAttribute("class");
        if (className != null && !className.trim().isEmpty()) {
            try {
                String jsessionid;
                layer = (Layer)Class.forName(className).newInstance();
                if (this.dataSource != null && (jsessionid = this.dataSource.getConnectionProperties().getProperty("jsessionID")) != null && !jsessionid.trim().isEmpty()) {
                    layer.setProperty("oracle.lbs.mapviewer.jsessionID", jsessionid);
                }
                layer.fromXMLElement(xmlElement);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return layer;
    }

    private Icon getLayerIcon(SpatialTableMetadata meta) {
        ImageIcon icon = null;
        if (meta == NEWLAYER) {
            icon = Icons.getIcon("addtable.png");
        } else {
            int sessionSRID = 0;
            EditSession ed = this.mainApp.getEditSessionPanel().getEditSession();
            if (ed instanceof MDSEditSession) {
                sessionSRID = ((MDSEditSession)ed).getSRID();
            }
            if (sessionSRID != 0 && sessionSRID != meta.getSRID() && meta.getSRID() > 0 && meta.getSRID() != 262148) {
                icon = Icons.getIcon("error.png");
            } else if (meta.getType().equals(SpatialTableMetadata.GEOMETRY_TYPE)) {
                icon = Icons.getIcon("ora_geomThemeItem.png");
            } else if (meta.getType().equals(SpatialTableMetadata.ANNOTATION_TYPE)) {
                icon = Icons.getIcon("annotext.png");
            } else if (meta.getType().equals(SpatialTableMetadata.TOPOFEATURE_TYPE)) {
                icon = Icons.getIcon("ora_topoThemeItem.png");
            }
        }
        return icon;
    }

    private Layer createLayer(SpatialTableMetadata meta, Map<Object, Object> extraProps) {
        if (meta == null) {
            return null;
        }
        String spatialColumn = meta.getSpatialColumn();
        if (spatialColumn == null) {
            return null;
        }
        String className = null;
        PropertySupportObject props = new PropertySupportObject(this);
        String type = meta.getType();
        if (type.equals(SpatialTableMetadata.GEOMETRY_TYPE) || type.equals(SpatialTableMetadata.ANNOTATION_TYPE) || type.equals(SpatialTableMetadata.TOPOFEATURE_TYPE)) {
            String owner;
            String keyColumn;
            String layerName = meta.getName();
            boolean isGeomFromTopoModel = false;
            if (type.equalsIgnoreCase(SpatialTableMetadata.GEOMETRY_TYPE)) {
                className = GeometrySetLayer.class.getCanonicalName();
                if (layerName.toUpperCase().endsWith("_NODE$") || layerName.toUpperCase().endsWith("_EDGE$") || layerName.toUpperCase().endsWith("_FACE$")) {
                    this.fetchTopologyNames();
                    if (this.topologyNames == null) {
                        return null;
                    }
                    isGeomFromTopoModel = this.topologyNames.contains(layerName.substring(0, layerName.length() - 6));
                }
            } else if (type.equalsIgnoreCase(SpatialTableMetadata.ANNOTATION_TYPE)) {
                className = AnnotationTextSetLayer.class.getCanonicalName();
            } else {
                className = TopologySetLayer.class.getCanonicalName();
                String topology = this.getTopologyName(layerName, spatialColumn);
                if (topology != null) {
                    props.setProperty("topology", topology);
                } else {
                    System.out.println("unable to get a topology name for [" + layerName + "," + spatialColumn + "]. Layer not added.");
                    return null;
                }
            }
            if ((keyColumn = this.fetchTablePrimaryKey(layerName)) == null) {
                keyColumn = "ROWID";
            }
            if (!isGeomFromTopoModel) {
                props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", keyColumn);
            } else {
                if (layerName.toUpperCase().endsWith("_NODE$")) {
                    props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "NODE_ID");
                } else if (layerName.toUpperCase().endsWith("_EDGE$")) {
                    props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "EDGE_ID");
                } else if (layerName.toUpperCase().endsWith("_FACE$")) {
                    props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "FACE_ID");
                }
                props.setProperty("topology", layerName.substring(0, layerName.length() - 6));
            }
            props.setProperty("oracle.maps.core.Layer.name", layerName);
            props.setProperty("oracle.maps.core.Layer.srid", meta.getSRID() + "");
            props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable", layerName);
            props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", spatialColumn);
            if (this.dataSource != null) {
                props.setProperty("oracle.lbs.mapviewer.serverURL", this.dataSource.getConnectionProperties().getProperty("serverURL"));
                props.setProperty("oracle.lbs.mapviewer.dataSource", this.dataSource.getConnectionProperties().getProperty("dataSource"));
                props.setProperty("oracle.lbs.mapviewer.editor", this.dataSource.getConnectionProperties().getProperty("editor"));
                String jsessionid = this.dataSource.getConnectionProperties().getProperty("jsessionID");
                if (jsessionid != null && !jsessionid.trim().isEmpty()) {
                    props.setProperty("oracle.lbs.mapviewer.jsessionID", jsessionid);
                }
            }
            if ((owner = meta.getOwner()) != null) {
                props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.owner", owner);
            }
            if (extraProps != null) {
                for (Map.Entry<Object, Object> e : extraProps.entrySet()) {
                    props.setProperty(e.getKey().toString(), e.getValue().toString());
                }
            }
        }
        if (className != null) {
            XMLDocument doc = new XMLDocument();
            doc.setXmlVersion("1.0");
            Element root = doc.createElement("layer");
            root.setAttribute("class", className);
            if (props.size() > 0) {
                try {
                    Element propsElem = props.toXMLElement();
                    if (propsElem != null) {
                        root.appendChild(doc.adoptNode((Node)propsElem));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SAXException ex) {
                    ex.printStackTrace();
                }
            }
            return this.createLayer(root);
        }
        return null;
    }

    private Layer createGeomTable() {
        if (this.dataSource == null) {
            return null;
        }
        OlafDialog ctDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Create_geometry_table"), null);
        long sessionSRID = 8307L;
        EditSession session = this.mainApp.getEditSessionPanel().getEditSession();
        if (session instanceof MDSEditSession) {
            sessionSRID = ((MDSEditSession)session).getSRID();
        }
        CreateGeometryTablePanel cgPanel = new CreateGeometryTablePanel(this.dataSource, sessionSRID, ctDlg);
        ctDlg.setVisible(true);
        if (ctDlg.isCancelled()) {
            return null;
        }
        SpatialTableMetadata meta = cgPanel.getSpatialTableMetadata();
        if (meta == null) {
            return null;
        }
        this.cache.add(meta);
        String keyColumn = cgPanel.getKeyColumn();
        if (keyColumn != null) {
            this.tablePKeys.put((this.dataSource.getName() + "_" + meta.getName()).toUpperCase(), keyColumn.toUpperCase());
        }
        Properties props = new Properties();
        String keySequence = cgPanel.getKeySequence();
        if (keySequence != null) {
            props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence", keySequence);
        }
        return this.createLayer(meta, props);
    }

    private Layer createAnnotationTextTable() {
        if (this.dataSource == null) {
            return null;
        }
        OlafDialog ctDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Create_annotationtext_table"), null);
        CreateAnnotationTextTablePanel cgPanel = new CreateAnnotationTextTablePanel(this.dataSource, ctDlg);
        ctDlg.setVisible(true);
        if (ctDlg.isCancelled()) {
            return null;
        }
        SpatialTableMetadata meta = cgPanel.getSpatialTableMetadata();
        if (meta == null) {
            return null;
        }
        this.cache.add(meta);
        String keyColumn = cgPanel.getKeyColumn();
        if (keyColumn != null) {
            this.tablePKeys.put((this.dataSource.getName() + "_" + meta.getName()).toUpperCase(), keyColumn.toUpperCase());
        }
        Properties props = new Properties();
        String keySequence = cgPanel.getKeySequence();
        if (keySequence != null) {
            props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence", keySequence);
        }
        return this.createLayer(meta, props);
    }

    private Layer createTopologyFeatureTable() {
        if (this.dataSource == null) {
            return null;
        }
        this.fetchTopologyNames();
        OlafDialog ctDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Create_topology_table"), null);
        CreateTopologyTablePanel cgPanel = new CreateTopologyTablePanel(this.dataSource, this.topologyNames, ctDlg);
        ctDlg.setVisible(true);
        if (ctDlg.isCancelled()) {
            return null;
        }
        SpatialTableMetadata meta = cgPanel.getSpatialTableMetadata();
        if (meta == null) {
            return null;
        }
        this.cache.add(meta);
        String keyColumn = cgPanel.getKeyColumn();
        if (keyColumn != null) {
            this.tablePKeys.put((this.dataSource.getName() + "_" + meta.getName()).toUpperCase(), keyColumn.toUpperCase());
        }
        Properties props = new Properties();
        String keySequence = cgPanel.getKeySequence();
        String topology = cgPanel.getTopologyName();
        if (keySequence != null) {
            props.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence", keySequence);
        }
        if (topology != null) {
            props.setProperty("oracle.spatial.edit.layer.TopologySetLayer.topology", topology);
        }
        return this.createLayer(meta, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchLayerMetadata() {
        if (this.cache == null) {
            if (this.dataSource == null) {
                return;
            }
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            Vector<SpatialTableMetadata> sptMeta = null;
            try {
                dataAccess.openConnection();
                sptMeta = dataAccess.getSpatialTablesMetadata();
            }
            catch (MDSException ex) {
                return;
            }
            catch (Exception ex) {
                return;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (sptMeta != null) {
                this.cache = new Vector(sptMeta.size());
                for (SpatialTableMetadata meta : sptMeta) {
                    this.cache.add(meta);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchTablePrimaryKey(String table) {
        if (table == null) {
            return null;
        }
        if (this.dataSource == null) {
            return null;
        }
        String tb = (this.dataSource.getName() + "_" + table).toUpperCase();
        String pkey = this.tablePKeys.get(tb);
        if (pkey == null) {
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            Throwable exception = null;
            try {
                dataAccess.openConnection();
                pkey = dataAccess.getTablePrimaryKey(table);
                if (pkey != null) {
                    this.tablePKeys.put(tb, pkey);
                }
            }
            catch (MDSException ex) {
                exception = ex;
            }
            catch (Exception ex) {
                exception = ex;
            }
            finally {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (exception != null) {
                ErrorDialog.showErrorDialog(exception, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Unable_toget_table_primarykey"), MessagesBundle.getMessage("Error"), 2);
            }
        }
        return pkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTopologyNames() {
        if (this.topologyNames == null) {
            if (this.dataSource == null) {
                return;
            }
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            String[] topoNames = null;
            try {
                dataAccess.openConnection();
                topoNames = dataAccess.getTopologyNames();
            }
            catch (MDSException ex) {
                return;
            }
            catch (Exception ex) {
                return;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (topoNames != null) {
                this.topologyNames = new Vector(topoNames.length);
                for (String topoName : topoNames) {
                    this.topologyNames.add(topoName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTopologyName(String featureTable, String topoColumn) {
        if (featureTable == null || topoColumn == null) {
            return null;
        }
        String topology = null;
        if (this.dataSource == null) {
            return null;
        }
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            int i;
            dataAccess.openConnection();
            String[] topologies = dataAccess.getFeatureTableTopologies(featureTable, topoColumn);
            if (topologies != null && topologies.length > 0 && (i = 0) < topologies.length) {
                String topoUser = null;
                String topoName = topologies[i];
                int idx = topologies[i].indexOf(".");
                if (idx > -1) {
                    topoUser = topologies[i].substring(0, idx);
                    topoName = topologies[i].substring(idx + 1);
                }
                topology = topoName;
            }
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (exception != null) {
            return null;
        }
        return topology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTopologyNames() {
        if (this.dataSource == null) {
            return null;
        }
        AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
        Throwable exception = null;
        try {
            da.openConnection();
            String[] stringArray = da.getTopologyNames();
            return stringArray;
        }
        catch (MDSException ex) {
            exception = ex;
            String[] stringArray = null;
            return stringArray;
        }
        catch (Exception ex) {
            exception = ex;
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getProviderRootNode() {
        return new EmptyNonLeaf(this);
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener() {
        return null;
    }

    private void populate(EmptyNonLeaf root, JTree tree) {
        root.removeAllChildren();
        if (!root.isWorking()) {
            new GetLayersWorker(root, tree).execute();
        }
    }

    @Override
    public TreeWillExpandListener getTreeWillExpandListener() {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                EmptyNonLeaf node = (EmptyNonLeaf)evt.getPath().getLastPathComponent();
                MVVectorLayerProvider.this.populate(node, (JTree)evt.getSource());
                throw new ExpandVetoException(evt);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }
        };
    }

    @Override
    public TreeSelectionListener getTreeSelectionListener() {
        return null;
    }

    @Override
    public MouseListener getMouseListener() {
        return null;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer() {
        return this.cellRenderer;
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            String txt = "";
            Icon icon = null;
            if (obj instanceof SpatialTableMetadata) {
                SpatialTableMetadata meta = (SpatialTableMetadata)obj;
                icon = MVVectorLayerProvider.this.getLayerIcon(meta);
                txt = meta == NEWLAYER ? "Create new " + MVVectorLayerProvider.this.type.substring(0, 1).toUpperCase() + MVVectorLayerProvider.this.type.substring(1).toLowerCase() + " layer" : meta.getName() + " [" + meta.getSRID() + "]";
            } else if (obj == MVVectorLayerProvider.this) {
                txt = MVVectorLayerProvider.this.getProviderName();
            }
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, txt, selected, expanded, leaf, row, hasFocus);
            if (icon != null) {
                label.setIcon(icon);
            }
            return label;
        }
    }

    private class EmptyNonLeaf
    extends DefaultMutableTreeNode {
        private boolean working;

        public EmptyNonLeaf(Object userObject) {
            super(userObject);
            this.working = false;
        }

        @Override
        public boolean isLeaf() {
            return this.isWorking();
        }

        public void setWorking(boolean working) {
            this.working = working;
        }

        public boolean isWorking() {
            return this.working;
        }
    }

    private class GetLayersWorker
    extends SwingWorker {
        private EmptyNonLeaf root = null;
        private JTree tree = null;
        private SpatialTableMetadata[] stm = null;

        public GetLayersWorker(EmptyNonLeaf root, JTree tree) {
            this.root = root;
            this.tree = tree;
        }

        public Object doInBackground() {
            this.root.setWorking(true);
            this.stm = MVVectorLayerProvider.this.getEditorObjects();
            this.root.setWorking(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetLayersWorker.this.tree.getModel();
                    boolean added = false;
                    if (GetLayersWorker.this.stm != null) {
                        for (SpatialTableMetadata meta : GetLayersWorker.this.stm) {
                            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(meta);
                            model.insertNodeInto(layerNode, GetLayersWorker.this.root, GetLayersWorker.this.root.getChildCount());
                            added = true;
                        }
                    }
                    model.nodeStructureChanged(GetLayersWorker.this.root);
                    if (added) {
                        GetLayersWorker.this.tree.expandPath(new TreePath(GetLayersWorker.this.root.getPath()));
                    }
                }
            });
            return null;
        }
    }
}

