/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.mapviewer.share.XMLUtil;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPanel
extends JPanel {
    private JTextPane textPane = new JTextPane();
    private JTextArea textArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.textPane);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private AbstractDocument doc = null;

    public XMLPanel() {
        this.textPane.setCaretPosition(0);
        this.textPane.setEditable(false);
        this.textPane.setMargin(new Insets(5, 5, 5, 5));
        StyledDocument styledDoc = this.textPane.getStyledDocument();
        if (styledDoc instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDoc);
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
            System.exit(-1);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(456, 395));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.textArea.setEditable(false);
    }

    private void insertNode(Node node, String spaces) {
        SimpleAttributeSet grey = new SimpleAttributeSet();
        StyleConstants.setForeground(grey, Color.gray);
        SimpleAttributeSet blue = new SimpleAttributeSet();
        StyleConstants.setForeground(blue, Color.blue);
        SimpleAttributeSet red = new SimpleAttributeSet();
        StyleConstants.setForeground(red, Color.red);
        SimpleAttributeSet bold = new SimpleAttributeSet();
        StyleConstants.setBold(bold, true);
        try {
            switch (node.getNodeType()) {
                case 8: {
                    this.doc.insertString(this.doc.getLength(), spaces, null);
                    this.doc.insertString(this.doc.getLength(), "<!--", blue);
                    this.doc.insertString(this.doc.getLength(), node.getNodeValue(), grey);
                    this.doc.insertString(this.doc.getLength(), "-->", blue);
                    this.doc.insertString(this.doc.getLength(), "\n", null);
                    break;
                }
                case 4: {
                    this.doc.insertString(this.doc.getLength(), "<![CDATA[", bold);
                    this.doc.insertString(this.doc.getLength(), node.toString(), null);
                    this.doc.insertString(this.doc.getLength(), "]]>", bold);
                    break;
                }
                case 1: {
                    this.doc.insertString(this.doc.getLength(), spaces, null);
                    this.doc.insertString(this.doc.getLength(), "<", blue);
                    this.doc.insertString(this.doc.getLength(), node.getNodeName(), red);
                    NamedNodeMap attributes = node.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Attr att = (Attr)attributes.item(i);
                        this.doc.insertString(this.doc.getLength(), " ", null);
                        this.doc.insertString(this.doc.getLength(), att.getName(), blue);
                        this.doc.insertString(this.doc.getLength(), "=\"", null);
                        this.doc.insertString(this.doc.getLength(), XMLUtil.replaceXMLEntities((String)att.getValue()), bold);
                        this.doc.insertString(this.doc.getLength(), "\"", null);
                        att.getValue();
                    }
                    NodeList children = node.getChildNodes();
                    if (children.getLength() == 0) {
                        this.doc.insertString(this.doc.getLength(), "/>", blue);
                    } else {
                        this.doc.insertString(this.doc.getLength(), ">", blue);
                    }
                    this.doc.insertString(this.doc.getLength(), "\n", null);
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.insertNode(children.item(i), spaces + "  ");
                    }
                    if (children.getLength() <= 0) break;
                    if (children.item(children.getLength() - 1).getNodeType() != 3) {
                        this.doc.insertString(this.doc.getLength(), spaces, null);
                    }
                    this.doc.insertString(this.doc.getLength(), "</", blue);
                    this.doc.insertString(this.doc.getLength(), node.getNodeName(), red);
                    this.doc.insertString(this.doc.getLength(), ">", blue);
                    this.doc.insertString(this.doc.getLength(), "\n", null);
                    break;
                }
                case 3: {
                    Node parent = node.getParentNode();
                    Node grandparent = null;
                    Node grandgrandparent = null;
                    if (parent != null && (grandparent = parent.getParentNode()) != null) {
                        grandgrandparent = grandparent.getParentNode();
                    }
                    this.doc.remove(this.doc.getLength() - 1, 1);
                    if (parent != null && parent.getNodeName().equalsIgnoreCase("value") && grandparent != null && grandparent.getNodeName().equalsIgnoreCase("tag") && grandgrandparent != null && grandgrandparent.getNodeName().equalsIgnoreCase("custom_tags")) {
                        this.doc.insertString(this.doc.getLength(), " <![CDATA[ " + node.getNodeValue() + " ]]> ", null);
                        break;
                    }
                    this.doc.insertString(this.doc.getLength(), XMLUtil.replaceXMLEntities((String)node.getNodeValue()), null);
                }
            }
        }
        catch (BadLocationException be) {
            be.printStackTrace();
        }
    }

    public void setText(String text) {
        try {
            this.doc.remove(0, this.doc.getLength());
            if (text == null || text.trim().length() == 0) {
                this.doc.insertString(0, "", null);
                return;
            }
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(text = text.trim())) {
                System.out.println(MessagesBundle.getMessage("Unable_toparse_definition"));
                this.doc.insertString(0, text, null);
                return;
            }
            if (text.startsWith("<?xml ")) {
                this.doc.insertString(0, text.substring(0, text.indexOf("?>") + 2), null);
                this.doc.insertString(this.doc.getLength(), "\n", null);
            }
            Document xmlDoc = parser.getDocument();
            NodeList children = xmlDoc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.insertNode(children.item(i), "");
            }
        }
        catch (Exception be) {
            be.printStackTrace();
        }
    }

    public String getText() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException be) {
            be.printStackTrace();
            return "";
        }
    }

    public void resetTextAreaPosition() {
        this.textPane.setCaretPosition(0);
    }
}

