/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.maps.core.Drawable;

public class DynamicVertexSet {
    private ArrayList<Point2D> vertices = new ArrayList();
    int count = 0;
    int capacity = 0;
    double boxWidth = 1.0;

    public DynamicVertexSet(double boxWidth) {
        this.boxWidth = boxWidth;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public void createVertexHandles(Double[] coords) {
        int numPoints = coords.length / 2;
        this.count = 0;
        this.ensureCapacity(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            double x = coords[i * 2];
            double y = coords[i * 2 + 1];
            Point2D point = this.vertices.get(i);
            point.setLocation(x, y);
            ++this.count;
        }
    }

    public void createVertexHandles(Drawable dr, Point2D cursorPt, float buffer) {
        ArrayList<Double> res = new ArrayList<Double>(50);
        double px = cursorPt.getX();
        double py = cursorPt.getY();
        double dist2 = buffer * buffer;
        for (Drawable draw = dr; draw != null; draw = draw.getNext()) {
            if (draw.isPoint()) {
                Point2D pt = draw.getPoint();
                res.add(pt.getX());
                res.add(pt.getY());
                continue;
            }
            if (!draw.isShape()) continue;
            Shape shp = draw.getShape();
            PathIterator pi = shp.getPathIterator(null);
            double[] seg = new double[6];
            while (!pi.isDone()) {
                switch (pi.currentSegment(seg)) {
                    case 0: 
                    case 1: {
                        double x = seg[0];
                        double y = seg[1];
                        if (!((px - x) * (px - x) + (py - y) * (py - y) < dist2)) break;
                        res.add(x);
                        res.add(y);
                        break;
                    }
                }
                pi.next();
            }
        }
        this.createVertexHandles(res.toArray(new Double[res.size()]));
    }

    public Rectangle2D[] getBoxes() {
        return this.getBoxes(null);
    }

    public Rectangle2D[] getBoxes(AffineTransform at) {
        Rectangle2D[] res = new Rectangle2D[this.count];
        for (int i = 0; i < this.count; ++i) {
            res[i] = this.getBox(i, at);
        }
        return res;
    }

    public Rectangle2D getBox(int idx) {
        return this.getBox(idx, null);
    }

    public Rectangle2D getBox(int idx, AffineTransform at) {
        Point2D c = this.vertices.get(idx);
        Rectangle2D.Double rec = new Rectangle2D.Double(c.getX() - this.boxWidth / 2.0, c.getY() - this.boxWidth / 2.0, this.boxWidth, this.boxWidth);
        if (at != null && !at.isIdentity()) {
            ((Rectangle2D)rec).setRect(at.createTransformedShape(rec).getBounds2D());
        }
        return rec;
    }

    private void ensureCapacity(int cap) {
        if (this.vertices.size() >= cap) {
            return;
        }
        int gap = cap - this.vertices.size();
        for (int i = 0; i < gap; ++i) {
            this.vertices.add(new Point2D.Double(0.0, 0.0));
        }
    }

    public int hitTest(double x, double y) {
        if (this.vertices.size() <= 0) {
            return -1;
        }
        for (int i = 0; i < this.count; ++i) {
            Point2D c = this.vertices.get(i);
            Rectangle2D.Double box = new Rectangle2D.Double(c.getX() - this.boxWidth / 2.0, c.getY() - this.boxWidth / 2.0, this.boxWidth, this.boxWidth);
            if (!box.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public void setBoxWidth(double boxWidth) {
        this.boxWidth = boxWidth;
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }
}

