/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.util.JGeometrySegmentUtil;
import oracle.spatial.geometry.JGeometry;

public class VertexRemoveTool
extends BasicTool {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private Layer targetLayer = null;
    private ActiveFeaturesLayer featureLayer = null;
    private GeoObject activeFeature = null;
    private JGeometrySegmentPoint snapInterPoint = null;
    private Point lastDrag = null;
    private Point startDrag = new Point();
    private boolean recStarted = false;
    Rectangle2D boxDrag = null;
    private RTreeIndex sptIndex = null;

    public VertexRemoveTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Remove vertex");
    }

    @Override
    public void clear() {
        this.snapInterPoint = null;
        this.lastDrag = null;
        this.startDrag = new Point();
        this.recStarted = false;
        this.boxDrag = null;
        this.sptIndex = null;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseEvent) {
            boolean handle;
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            this.targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
            this.activeFeature = this.featureLayer.getActiveFeature();
            boolean bl = handle = id == 503 || e.getButton() == 1 || (e.getModifiersEx() & 0x400) == 1024;
            if (handle) {
                propagate = false;
                switch (id) {
                    case 500: {
                        this.mouseClicked(e);
                        break;
                    }
                    case 501: {
                        this.mousePressed(e);
                        break;
                    }
                    case 503: {
                        this.mouseMoved(e);
                        break;
                    }
                    case 506: {
                        this.mouseDragged(e);
                        break;
                    }
                    case 502: {
                        this.mouseReleased(e);
                        break;
                    }
                    default: {
                        propagate = true;
                    }
                }
            }
        }
        return propagate;
    }

    protected void mouseClicked(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.snapInterPoint == null) {
            return;
        }
        double wcTolerance = TransformUtils.getWCTolerance(this.snapInterPoint.getPoint(), 3, this.canvas.getViewportTransform());
        if (this.targetLayer instanceof GeometrySetLayer) {
            GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
            GeometrySetLayer gl = (GeometrySetLayer)this.targetLayer;
            JGeometrySegmentPoint[] linkSeg = null;
            linkSeg = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPointOfFeatures(this.snapInterPoint.getPoint(), wcTolerance, false, false, false, false);
            if (linkSeg == null || linkSeg.length == 0) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
            String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
            try {
                gl.removeVertex(key, linkSeg);
            }
            catch (Exception ex) {
                log.severe("(VertexRemoveTool:mouseClicked) " + ex.getMessage());
                ex.printStackTrace();
            }
        } else if (this.targetLayer instanceof TopologyPrimitiveLayer) {
            try {
                GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                int edgeId = Integer.parseInt(selectedFeature.getKey().toString());
                JGeometry change = JGeometryUtil.removeVertex((JGeometry)selectedFeature.getSpatialAttribute(), (JGeometrySegmentPoint)this.snapInterPoint);
                ((TopologyPrimitiveLayer)this.targetLayer).changeEdgeGeometry(edgeId, change);
                selectedFeature.setSpatialAttribute(change);
            }
            catch (Exception ex) {
                log.severe("(VertexRemoveTool:mouseClicked) " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.snapInterPoint = null;
        this.sptIndex = null;
        this.featureLayer.setSnapPoint(null);
    }

    protected void mousePressed(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        if (!this.recStarted) {
            this.startDrag.x = evt.getX();
            this.startDrag.y = evt.getY();
            this.boxDrag = new Rectangle2D.Float(this.startDrag.x, this.startDrag.y, 0.0f, 0.0f);
            this.featureLayer.setDragBox(this.boxDrag);
            this.recStarted = true;
            this.lastDrag = null;
        }
        this.featureLayer.getVertexHandles().clear();
    }

    protected void mouseMoved(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        try {
            Point2D.Double center = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), center);
            double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
            if (this.targetLayer instanceof GeometrySetLayer) {
                GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                GeometrySetLayer gl = (GeometrySetLayer)this.targetLayer;
                String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                this.snapInterPoint = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(key, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false);
            } else if (this.targetLayer instanceof TopologyPrimitiveLayer) {
                JGeometry geom = ((GeometryFeature)this.activeFeature).getSpatialAttribute();
                if (this.sptIndex == null) {
                    this.sptIndex = JGeometrySegmentUtil.buildSegmentTree(geom);
                }
                this.snapInterPoint = JGeometrySegmentUtil.getSegmentPoint(geom, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false, this.sptIndex, ((GeometryFeature)this.activeFeature).getKey().toString());
            }
            if (this.snapInterPoint == null || this.snapInterPoint.getPointLocation() == 2) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            this.featureLayer.setSnapPoint(this.snapInterPoint.getPoint());
        }
        catch (Exception ex) {
            this.snapInterPoint = null;
            this.sptIndex = null;
            this.featureLayer.setSnapPoint(null);
        }
    }

    protected void mouseDragged(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        int x = -1;
        int y = -1;
        if (this.recStarted) {
            if (this.lastDrag == null) {
                this.lastDrag = new Point();
            }
            this.lastDrag.x = evt.getX();
            this.lastDrag.y = evt.getY();
            if (this.boxDrag != null) {
                int w = Math.abs(this.lastDrag.x - this.startDrag.x);
                int h = Math.abs(this.lastDrag.y - this.startDrag.y);
                this.boxDrag.setRect(this.lastDrag.x < this.startDrag.x ? (double)this.lastDrag.x : (double)this.startDrag.x, this.lastDrag.y < this.startDrag.y ? (double)this.lastDrag.y : (double)this.startDrag.y, w, h);
            }
        }
    }

    protected void mouseReleased(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        if (this.recStarted) {
            this.recStarted = false;
            this.boxDrag = null;
            this.featureLayer.setDragBox(this.boxDrag);
            if (this.lastDrag != null && this.lastDrag.x >= 0 && this.lastDrag.y >= 0 && this.startDrag.x != this.lastDrag.x && this.startDrag.y != this.lastDrag.y) {
                Point2D.Double startPT = new Point2D.Double(this.startDrag.x, this.startDrag.y);
                Point2D.Double lastPT = new Point2D.Double(this.lastDrag.x, this.lastDrag.y);
                Point2D.Double sdC = new Point2D.Double();
                Point2D.Double ldC = new Point2D.Double();
                try {
                    this.canvas.getViewportTransform().inverseTransform(lastPT, ldC);
                    this.canvas.getViewportTransform().inverseTransform(startPT, sdC);
                }
                catch (Exception ex) {
                    this.lastDrag = null;
                    this.recStarted = false;
                    return;
                }
                double xmin = Math.min(((Point2D)sdC).getX(), ((Point2D)ldC).getX());
                double xmax = Math.max(((Point2D)sdC).getX(), ((Point2D)ldC).getX());
                double ymin = Math.min(((Point2D)sdC).getY(), ((Point2D)ldC).getY());
                double ymax = Math.max(((Point2D)sdC).getY(), ((Point2D)ldC).getY());
                Rectangle2D.Double searchMbr = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
                if (this.targetLayer instanceof GeometrySetLayer) {
                    GeometrySetLayer gl = (GeometrySetLayer)this.targetLayer;
                    GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                    Hashtable<String, JGeometrySegmentPoint[]> featSegs = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPointsOfFeaturesWithinBox(searchMbr);
                    if (featSegs == null || featSegs.size() == 0) {
                        this.lastDrag = null;
                        return;
                    }
                    String keyColumn = ((IndexedGeometrySet)gl.getIndexedDataSet()).getGeometrySet().getKeyColumn();
                    String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                    try {
                        gl.removeVertexes(key, featSegs);
                    }
                    catch (Exception ex) {
                        log.severe("(VertexRemoveTool:mouseReleased) " + ex.getMessage());
                        ex.printStackTrace();
                    }
                } else if (this.targetLayer instanceof TopologyPrimitiveLayer) {
                    try {
                        JGeometrySegmentPoint[] featSegs;
                        GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                        JGeometry geom = ((GeometryFeature)this.activeFeature).getSpatialAttribute();
                        if (this.sptIndex == null) {
                            this.sptIndex = JGeometrySegmentUtil.buildSegmentTree(geom);
                        }
                        if ((featSegs = JGeometrySegmentUtil.getSegmentPointsWithinBox(geom, searchMbr, this.sptIndex, selectedFeature.getKey().toString())) == null || featSegs.length == 0) {
                            this.lastDrag = null;
                            this.sptIndex = null;
                            return;
                        }
                        int edgeId = Integer.parseInt(selectedFeature.getKey().toString());
                        JGeometry change = JGeometryUtil.removeVertexes((JGeometry)geom, (JGeometrySegmentPoint[])featSegs);
                        ((TopologyPrimitiveLayer)this.targetLayer).changeEdgeGeometry(edgeId, change);
                        selectedFeature.setSpatialAttribute(change);
                    }
                    catch (Exception ex) {
                        log.severe("(VertexRemoveTool:mouseReleased) " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
            this.lastDrag = null;
            this.sptIndex = null;
        }
    }

    @Override
    public boolean isInAction() {
        return this.recStarted;
    }

    public Layer getActiveFeatureLayer() {
        return this.featureLayer;
    }

    public void setFeatureLayer(ActiveFeaturesLayer featureLayer) {
        this.featureLayer = featureLayer;
    }
}

