/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.GeoObject;

public class HoverManager {
    EventListenerList listenerList = new EventListenerList();
    private GeoObject hover = null;

    public void setHover(GeoObject obj) {
        if (this.hover == null && obj == null) {
            return;
        }
        if (this.hover != null && this.hover == obj) {
            return;
        }
        this.hover = obj;
        this.fireStateChanged();
    }

    public void clear() {
        if (this.hover != null) {
            this.hover = null;
            this.fireStateChanged();
        }
    }

    public GeoObject getHover() {
        return this.hover;
    }

    public int size() {
        return this.hover == null ? 0 : 1;
    }

    public boolean isHover(GeoObject obj) {
        if (this.hover == null) {
            return false;
        }
        return this.hover.getKey() != null ? this.hover.getLayer() == obj.getLayer() && this.hover.getKey() == obj.getKey() : this.hover.getLayer() == obj.getLayer() && this.hover == obj;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }
}

