/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.StyleContext;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.ceditor.insight.ListDataItem;
import oracle.ide.config.Preferences;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopup;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.editor.popup.StaticHtmlContentProvider;
import oracle.javatools.ui.ColorUtils2;
import oracle.javatools.ui.WindowTiler;

public abstract class BasicInsight
extends AbstractInsight {
    protected HtmlPopupView _htmlPopupView;
    protected Listeners _listeners = new Listeners();
    private JPanel optionsPanel;
    private JLabel statusLabel;
    protected static final Color STATUS_DIVIDER_COLOR = new Color(125, 125, 125, 125);
    protected String visibilityPrefKey = String.format("%s.Visibility", ((Object)((Object)this)).getClass().getName());
    protected static final String COMPLETION_INSTANCE = "java-completion";
    protected static final String PARAMETER_INSTANCE = "java-parameter";

    protected abstract ListInsightView getListInsightView();

    protected boolean isDocInitiallyVisible() {
        Preferences preferences = Preferences.getPreferences();
        return preferences.getProperties().getBoolean(this.visibilityPrefKey, true);
    }

    protected void setDocVisibility(boolean visible) {
        Preferences preferences = Preferences.getPreferences();
        preferences.getProperties().putBoolean(this.visibilityPrefKey, visible);
    }

    public Context getContext() {
        Context context = CodeEditor.getContext(this.getEditorPane());
        return context;
    }

    public AbstractInsight getInsight(int type) {
        String typeString = this.getTypeString(type);
        BasicEditorPane editor = this.getEditorPane();
        return (AbstractInsight)editor.getProperty(typeString);
    }

    protected String getTypeString(int type) {
        switch (type) {
            case 1: {
                return COMPLETION_INSTANCE;
            }
            case 2: {
                return PARAMETER_INSTANCE;
            }
        }
        throw new IllegalStateException("unknown type: " + type);
    }

    public void showInsight(boolean wasAutoInvoked) {
        boolean wasActive = this.isActive();
        super.showInsight(wasAutoInvoked);
        if (!wasActive && this.isActive()) {
            BasicEditorPane editorPane1 = this.getEditorPane();
            editorPane1.addPreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
            if (this.isDocInitiallyVisible()) {
                this.showQuickDoc();
            }
        }
    }

    public void hideInsight() {
        this._listeners._timer.stop();
        if (this.isActive()) {
            BasicEditorPane editorPane = this.getEditorPane();
            editorPane.removePreActionInvoker((ActionPreInvoker)this._listeners, 2.0);
            if (this._htmlPopupView != null) {
                this.hideQuickDoc();
            }
        }
        super.hideInsight();
    }

    protected void toggleHtmlDoc() {
        if (this._htmlPopupView == null) {
            this.showQuickDoc();
        } else {
            this.hideQuickDoc();
        }
    }

    protected HtmlContentProvider getSelectedContentProvider() {
        HtmlContentProvider ret = null;
        Object selectedValue = this.getListInsightView().getSelectedValue();
        if (selectedValue instanceof ListDataItem) {
            ListDataItem listDataItem = (ListDataItem)((Object)selectedValue);
            Context context = this.getContext();
            ret = listDataItem.getContentProvider(context);
        }
        return ret;
    }

    public void hideQuickDoc() {
        BasicEditorPane editorPane = this.getEditorPane();
        HtmlPopup.cancelPopup((BasicEditorPane)editorPane);
        if (this._htmlPopupView != null) {
            this._htmlPopupView.removePopupEventListener((PopupEventListener)this._listeners);
            this.getListInsightView().removeListSelectionListener((ListSelectionListener)this._listeners);
        }
    }

    public void showQuickDoc() {
        HtmlContentProvider contentProvider = this.getSelectedContentProvider();
        if (contentProvider != null) {
            BasicEditorPane editorPane = this.getEditorPane();
            EnumSet<HtmlPopup.Options> options = EnumSet.noneOf(HtmlPopup.Options.class);
            this._htmlPopupView = HtmlPopup.invokePopup((BasicEditorPane)editorPane, (HtmlContentProvider)contentProvider, options);
            if (this._htmlPopupView != null) {
                this._htmlPopupView.setToolbarVisible(false);
                this._htmlPopupView.addPopupEventListener((PopupEventListener)this._listeners);
                this.getListInsightView().addListSelectionListener((ListSelectionListener)this._listeners);
                Window docWindow = SwingUtilities.windowForComponent((Component)this._htmlPopupView);
                Window insightWindow = SwingUtilities.windowForComponent((Component)this.getListInsightView());
                if (docWindow != null && insightWindow != null) {
                    WindowTiler tiler = new WindowTiler((Component)insightWindow, docWindow);
                    ArrayList<WindowTiler.Alignment> alignments = new ArrayList<WindowTiler.Alignment>();
                    alignments.add(WindowTiler.Alignment.RIGHT);
                    alignments.add(WindowTiler.Alignment.LEFT);
                    alignments.add(WindowTiler.Alignment.BOTTOM);
                    tiler.setAlignment(alignments);
                }
            }
        }
    }

    protected JComponent createStatusComponent() {
        JPanel p = null;
        if (this.getListInsightView() != null) {
            this.statusLabel = new JLabel("");
            this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(9.0f));
            this.statusLabel.setHorizontalAlignment(10);
            this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, STATUS_DIVIDER_COLOR), BorderFactory.createEmptyBorder(1, 1, 1, 6)));
            OptionsButton optionsButton = new OptionsButton();
            optionsButton.setSelected(false);
            optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicInsight.this.optionsPanel.setVisible(!BasicInsight.this.optionsPanel.isVisible());
                    SwingUtilities.getWindowAncestor(BasicInsight.this.optionsPanel).pack();
                }
            });
            this.optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 1 2 0 2, gapy 0")){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (BasicInsight.this.statusLabel.getWidth() > 1) {
                        g = g.create();
                        g.setColor(STATUS_DIVIDER_COLOR);
                        g.drawLine(0, 0, BasicInsight.this.statusLabel.getWidth() - 1, 0);
                    }
                }
            };
            this.optionsPanel.setOpaque(false);
            this.optionsPanel.setVisible(false);
            final JCheckBox quickDocButton = new JCheckBox(InsightBundle.get("INSIGHT_DOC_POPUP_BUTTON"), this.isDocInitiallyVisible());
            quickDocButton.setFont(this.statusLabel.getFont());
            quickDocButton.setOpaque(false);
            quickDocButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicInsight.this.setDocVisibility(quickDocButton.isSelected());
                    if (quickDocButton.isSelected()) {
                        BasicInsight.this.showQuickDoc();
                    } else {
                        BasicInsight.this.hideQuickDoc();
                    }
                }
            });
            this.optionsPanel.add(quickDocButton);
            p = new JPanel(new BorderLayout(4, 0));
            p.add((Component)this.statusLabel, "Center");
            p.add((Component)optionsButton, "After");
            p.add((Component)this.optionsPanel, "South");
            p.setOpaque(true);
            Color c = ColorUtils2.shadeColorPercent((Color)this.getListInsightView().getBackground(), (double)12.0);
            p.setBackground(c);
        }
        return p;
    }

    protected JLabel getStatusLabel() {
        return this.statusLabel;
    }

    protected JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    static {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StyleContext.getDefaultStyleContext().getFont("Courier", 0, 11);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private class Listeners
    implements ActionPreInvoker,
    PopupEventListener,
    ListSelectionListener,
    ActionListener {
        private Timer _timer = new Timer(200, this);

        private Listeners() {
            this._timer.setRepeats(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("show-doc-popup")) {
                BasicInsight.this.toggleHtmlDoc();
                return true;
            } else {
                if (BasicInsight.this._htmlPopupView == null) return false;
                if (actionKey.equals("scroll-line-up")) {
                    BasicInsight.this._htmlPopupView.up();
                    return true;
                } else if (actionKey.equals("scroll-line-down")) {
                    BasicInsight.this._htmlPopupView.down();
                    return true;
                } else {
                    if (!actionKey.equals("cancel")) return false;
                    BasicInsight.this.hideQuickDoc();
                }
            }
            return true;
        }

        public void popupCanceled() {
        }

        public void popupClosed() {
            this._timer.stop();
            BasicInsight.this.getListInsightView().removeListSelectionListener((ListSelectionListener)this);
            BasicInsight.this.hideQuickDoc();
            BasicInsight.this._htmlPopupView.removePopupEventListener((PopupEventListener)this);
            BasicInsight.this._htmlPopupView = null;
        }

        public void contentsChanged() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this._timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicInsight.this.getEditorPane() == null) {
                return;
            }
            HtmlContentProvider contentProvider = BasicInsight.this.getSelectedContentProvider();
            if (contentProvider == null) {
                contentProvider = new StaticHtmlContentProvider(InsightBundle.get("INSIGHT_DOC_NO_INFORMATION_AVAILABLE"), true);
            }
            if (BasicInsight.this._htmlPopupView != null) {
                BasicInsight.this._htmlPopupView.push(contentProvider);
            }
        }
    }

    private class OptionsButton
    extends JToggleButton {
        private OptionsButton() {
            super(InsightBundle.get("POPUP_OPTIONS_BUTTON"), OptionsIcon.upIcon);
            this.setRolloverEnabled(true);
            this.setFont(this.getFont().deriveFont(9.0f));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setContentAreaFilled(false);
            this.setSelectedIcon(OptionsIcon.downIcon);
            this.setIconTextGap(2);
            this.setHorizontalTextPosition(10);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.getModel().isRollover()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground().brighter().brighter());
                g2.fillRoundRect(0, 1, this.getWidth() - 2, this.getHeight() - 3, 4, 4);
                g2.setColor(this.getBackground().darker());
                g2.drawRoundRect(0, 1, this.getWidth() - 2, this.getHeight() - 3, 4, 4);
            }
            super.paintComponent(g);
        }
    }

    private static class OptionsIcon
    implements Icon {
        static OptionsIcon upIcon = new OptionsIcon(true);
        static OptionsIcon downIcon = new OptionsIcon(false);
        boolean up;

        private OptionsIcon(boolean up) {
            this.up = up;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(x, y + 1);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int yGap = this.getIconHeight() / 4;
            GeneralPath triangle = new GeneralPath();
            g2.setColor(UIManager.getColor("Label.foreground"));
            int shapeWidth = this.getIconWidth() - 3;
            if (this.up) {
                triangle.moveTo(1.0f, yGap);
                triangle.lineTo(shapeWidth + 1, yGap);
                triangle.lineTo(shapeWidth / 2 + 1, this.getIconHeight() - yGap);
            } else {
                triangle.moveTo(1.0f, this.getIconHeight() - yGap - 1);
                triangle.lineTo(shapeWidth + 1, this.getIconHeight() - yGap - 1);
                triangle.lineTo(shapeWidth / 2 + 1, yGap - 1);
            }
            g2.fill(triangle);
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }
}

