/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.graph.TextRendererImpl;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.VertexLookup;
import oracle.dbtools.common.graph.Visitor;

class DepthFirstTraversal<V, E>
implements VertexLookup<V, E> {
    private final transient TextRendererImpl<V, E> textRenderer;
    private final List<? extends Vertex<V, E>> vertices;
    private static final byte BLACK = 2;
    private static final byte GREY = 1;
    private static final byte WHITE = 0;

    DepthFirstTraversal(List<? extends Vertex<V, E>> vertices, TextRendererImpl<V, E> textRenderer) {
        this.vertices = vertices;
        this.textRenderer = textRenderer;
    }

    public void accept(Visitor<V, E> visitor, int startVertex) {
        Vertex<V, E> start = this.vertex(startVertex);
        Path.Builder path = new Path.Builder(startVertex, start, this.textRenderer);
        byte[] visited = new byte[this.vertices.size()];
        ArrayDeque<Level<V, Level<V, E>>> levels = new ArrayDeque<Level<V, Level<V, E>>>(this.vertices.size());
        levels.push(this.level(startVertex));
        visited[startVertex] = 1;
        while (!levels.isEmpty()) {
            Path<V, E> cycle;
            Level currentLevel = (Level)levels.peek();
            if (currentLevel.isEmpty()) {
                byte colour;
                Level completed = (Level)levels.pop();
                if (!levels.isEmpty()) {
                    path.pop();
                }
                if (1 != (colour = visited[completed.index])) continue;
                visited[completed.index] = 2;
                visitor.visit(completed.index, completed.vertex);
                continue;
            }
            Edge edge = currentLevel.pop();
            int target = edge.destinationIndex();
            byte colour = visited[target];
            if (colour == 0) {
                visited[target] = 1;
                levels.push(this.level(target));
                path.push(edge);
                continue;
            }
            if (!this.isOnPath(levels, target) || visitor.cycle(cycle = new Path.Builder(path.build()).push(edge).build())) continue;
            return;
        }
    }

    private boolean isOnPath(Deque<Level<V, E>> levels, int target) {
        for (Level<V, E> level : levels) {
            if (target != level.index) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DepthFirstTraversal [vertices=");
        builder.append(this.vertices);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Vertex<V, E> vertex(int index) throws ArrayIndexOutOfBoundsException {
        return this.vertices.get(index);
    }

    private final Level<V, E> level(int index) {
        Vertex<V, E> vertex = this.vertex(index);
        Level<V, E> level = new Level<V, E>(index, vertex);
        return level;
    }

    private static class Level<V, E> {
        final int index;
        final Vertex<V, E> vertex;
        private final Deque<Edge<V, E>> targets;

        Level(int vertexIndex, Vertex<V, E> vertex) {
            this.index = vertexIndex;
            this.vertex = vertex;
            Collection<Edge<V, E>> edges = vertex.edges();
            this.targets = new ArrayDeque<Edge<V, E>>(edges.size());
            for (Edge<V, E> edge : edges) {
                this.targets.add(edge);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Level [index=");
            builder.append(this.index);
            builder.append(", vertex=");
            builder.append(this.vertex);
            builder.append(", targets=");
            builder.append(this.targets);
            builder.append("]");
            return builder.toString();
        }

        boolean isEmpty() {
            return this.targets.isEmpty();
        }

        Edge<V, E> pop() {
            return this.targets.pop();
        }
    }
}

