/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.buffers.BufferHandle;

class MemoryHandle
implements BufferHandle {
    private byte[] bytes;

    public MemoryHandle(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public void close() {
        this.bytes = null;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.bytes == null) {
            throw new IllegalStateException("Memory buffer has been disposed");
        }
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long size() {
        if (this.bytes == null) {
            throw new IllegalStateException("Memory buffer has been disposed");
        }
        return this.bytes.length;
    }
}

