/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.propertyeditor.StringEditor;

public class C_Editor
implements PropertyEditor {
    protected PropertyChangeListener listener;
    private Character value;

    @Override
    public void setValue(Object o) {
        this.value = (Character)o;
        this.fire();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public final boolean isPaintable() {
        return false;
    }

    @Override
    public final void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public final String getAsText() {
        return this.value == null ? null : StringEditor.rawTextToDisplay(this.value.toString());
    }

    @Override
    public String getJavaInitializationString() {
        FastStringBuffer fsb = new FastStringBuffer(StringEditor.textToSource(this.value.toString()));
        fsb.replaceCharAt(0, '\'');
        fsb.replaceCharAt(fsb.length() - 1, '\'');
        return fsb.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
        } else {
            String s = StringEditor.displayTextToRaw(text);
            this.setValue(Character.valueOf(s.charAt(0)));
        }
    }

    @Override
    public final String[] getTags() {
        return null;
    }

    @Override
    public final Component getCustomEditor() {
        return null;
    }

    @Override
    public final boolean supportsCustomEditor() {
        return false;
    }

    protected void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "C_Editor???", null, this.value));
        }
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

