/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class TimedLRUCache {
    public static final int NO_EXPIRATION = -1;
    public static final int MINIMUM_EXPIRATION = 60000;
    private static final int CHECK_INTERVAL = 5000;
    private int _maxSize;
    private int _expireTime;
    private HashMap _entryMap;
    private long _lastCheck;
    @CodeSharingSafe(value="StaticField")
    private static final Comparator ACCESS_COMPARATOR = new AccessComparator();

    public TimedLRUCache(int maxSize) {
        this(maxSize, -1);
    }

    public TimedLRUCache(int maxSize, int timeToLiveMillis) {
        this._maxSize = maxSize;
        this._expireTime = timeToLiveMillis;
        if (this._expireTime != -1) {
            this._expireTime = Math.max(this._expireTime, 60000);
        }
        this._lastCheck = System.currentTimeMillis();
        this._entryMap = new HashMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.get(key);
            if (entry != null) {
                entry.access = System.currentTimeMillis();
                return entry.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        this.checkForExpiration();
        if (value != null && key != null) {
            Entry entry = new Entry(key, value, System.currentTimeMillis());
            HashMap hashMap = this._entryMap;
            synchronized (hashMap) {
                this._entryMap.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this._entryMap.remove(key);
            if (entry != null) {
                return entry.value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsKey(Object key) {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            return this._entryMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int size() {
        this.checkForExpiration();
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            return this._entryMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForExpiration() {
        HashMap hashMap = this._entryMap;
        synchronized (hashMap) {
            int cacheSize;
            long dueTime = this._lastCheck + 5000L;
            long nowTime = System.currentTimeMillis();
            if (nowTime < dueTime) {
                return;
            }
            this._lastCheck = nowTime;
            if (this._expireTime != -1) {
                long current = System.currentTimeMillis();
                long oldest = current - (long)this._expireTime;
                Iterator iterator = this._entryMap.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    if (entry.access > oldest) continue;
                    iterator.remove();
                }
            }
            if ((cacheSize = this._entryMap.size()) > this._maxSize) {
                Object[] values = this._entryMap.values().toArray();
                Arrays.sort(values, ACCESS_COMPARATOR);
                for (int i = this._maxSize; i < cacheSize; ++i) {
                    Entry entry = (Entry)values[i];
                    this._entryMap.remove(entry.key);
                }
            }
        }
    }

    private static class Entry {
        private Object key;
        private Object value;
        private long access;

        private Entry(Object key, Object value, long access) {
            this.key = key;
            this.value = value;
            this.access = access;
        }
    }

    private static class AccessComparator
    implements Comparator {
        private AccessComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Entry entry1 = (Entry)obj1;
            Entry entry2 = (Entry)obj2;
            return (int)(entry2.access - entry1.access);
        }
    }
}

