/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class UIManagerDefaults
implements ActionListener,
ItemListener {
    private static final String[] COLUMN_NAMES = new String[]{"Key", "Value", "Sample"};
    private static String selectedItem;
    private JComponent contentPane;
    private JMenuBar menuBar;
    private JComboBox comboBox;
    private JRadioButton byComponent;
    private JTable table;
    private TreeMap<String, TreeMap<String, Object>> items = new TreeMap();
    private HashMap<String, DefaultTableModel> models = new HashMap();

    public UIManagerDefaults() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.buildNorthComponent(), "North");
        this.contentPane.add((Component)this.buildCenterComponent(), "Center");
        this.resetComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = this.createMenuBar();
        }
        return this.menuBar;
    }

    private JComponent buildNorthComponent() {
        this.comboBox = new JComboBox();
        JLabel jLabel = new JLabel("Select Item:");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setLabelFor(this.comboBox);
        this.byComponent = new JRadioButton("By Component", true);
        this.byComponent.setMnemonic('C');
        this.byComponent.addActionListener(this);
        JRadioButton jRadioButton = new JRadioButton("By Value Type");
        jRadioButton.setMnemonic('V');
        jRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byComponent);
        buttonGroup.add(jRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(15, 0, 15, 0));
        jPanel.add(jLabel);
        jPanel.add(this.comboBox);
        jPanel.add(this.byComponent);
        jPanel.add(jRadioButton);
        return jPanel;
    }

    private JComponent buildCenterComponent() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(COLUMN_NAMES, 0);
        this.table = new JTable(defaultTableModel);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(500);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new SampleRenderer());
        Dimension dimension = this.table.getPreferredSize();
        dimension.height = 350;
        this.table.setPreferredScrollableViewportSize(dimension);
        return new JScrollPane(this.table);
    }

    public void resetComponents() {
        this.items.clear();
        this.models.clear();
        ((DefaultTableModel)this.table.getModel()).setRowCount(0);
        this.buildItemsMap();
        Vector<String> vector = new Vector<String>(50);
        for (String string : this.items.keySet()) {
            vector.add(string);
        }
        this.comboBox.removeItemListener(this);
        this.comboBox.setModel(new DefaultComboBoxModel(vector));
        this.comboBox.setSelectedIndex(-1);
        this.comboBox.addItemListener(this);
        this.comboBox.requestFocusInWindow();
        if (selectedItem != null) {
            this.comboBox.setSelectedItem(selectedItem);
        }
    }

    private TreeMap buildItemsMap() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            String string = this.getItemName(k.toString(), object);
            if (string == null) continue;
            TreeMap<String, Object> treeMap = this.items.get(string);
            if (treeMap == null) {
                treeMap = new TreeMap();
                this.items.put(string, treeMap);
            }
            treeMap.put(k.toString(), object);
        }
        return this.items;
    }

    private String getItemName(String string, Object object) {
        if (string.startsWith("class") || string.startsWith("javax")) {
            return null;
        }
        if (this.byComponent.isSelected()) {
            return this.getComponentName(string, object);
        }
        return this.getValueName(string, object);
    }

    private String getComponentName(String string, Object object) {
        int n = string.indexOf(".");
        String string2 = n != -1 ? string.substring(0, n) : (string.endsWith("UI") ? string.substring(0, string.length() - 2) : (object instanceof ColorUIResource ? "System Colors" : "Miscellaneous"));
        if (string2.equals("Checkbox")) {
            string2 = "CheckBox";
        }
        return string2;
    }

    private String getValueName(String string, Object object) {
        if (object instanceof Icon) {
            return "Icon";
        }
        if (object instanceof Font) {
            return "Font";
        }
        if (object instanceof Border) {
            return "Border";
        }
        if (object instanceof Color) {
            return "Color";
        }
        if (object instanceof Insets) {
            return "Insets";
        }
        if (object instanceof Boolean) {
            return "Boolean";
        }
        if (object instanceof Dimension) {
            return "Dimension";
        }
        if (object instanceof Number) {
            return "Number";
        }
        if (string.endsWith("UI")) {
            return "UI";
        }
        if (string.endsWith("InputMap")) {
            return "InputMap";
        }
        if (string.endsWith("RightToLeft")) {
            return "InputMap";
        }
        if (string.endsWith("radient")) {
            return "Gradient";
        }
        return "The Rest";
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createLAFMenu());
        return jMenuBar;
    }

    private JMenu createFileMenu() {
        JMenu jMenu = new JMenu("Application");
        jMenu.setMnemonic('A');
        jMenu.addSeparator();
        jMenu.add(new ExitAction());
        return jMenu;
    }

    private JMenu createLAFMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = new JMenu("Look & Feel");
        jMenu.setMnemonic('L');
        String string = UIManager.getLookAndFeel().getID();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string2 = lookAndFeelInfoArray[i].getClassName();
            String string3 = lookAndFeelInfoArray[i].getName();
            ChangeLookAndFeelAction changeLookAndFeelAction = new ChangeLookAndFeelAction(this, string2, string3);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(changeLookAndFeelAction);
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            if (!string3.equals(string)) continue;
            jRadioButtonMenuItem.setSelected(true);
        }
        return jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        selectedItem = null;
        this.resetComponents();
        this.comboBox.requestFocusInWindow();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        this.changeTableModel(string);
        this.updateRowHeights();
        selectedItem = string;
    }

    private void changeTableModel(String string) {
        DefaultTableModel defaultTableModel = this.models.get(string);
        if (defaultTableModel != null) {
            this.table.setModel(defaultTableModel);
            return;
        }
        defaultTableModel = new DefaultTableModel(COLUMN_NAMES, 0);
        Map map = this.items.get(string);
        for (String string2 : map.keySet()) {
            Object object = map.get(string2);
            Vector<String> vector = new Vector<String>(3);
            vector.add(string2);
            if (object != null) {
                vector.add(object.toString());
                if (object instanceof Icon) {
                    object = new SafeIcon((Icon)object);
                }
                vector.add((String)object);
            } else {
                vector.add("null");
                vector.add("");
            }
            defaultTableModel.addRow(vector);
        }
        this.table.setModel(defaultTableModel);
        this.models.put(string, defaultTableModel);
    }

    private void updateRowHeights() {
        try {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                int n = this.table.getRowHeight();
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    Component component = this.table.prepareRenderer(this.table.getCellRenderer(i, j), i, j);
                    n = Math.max(n, component.getPreferredSize().height);
                }
                this.table.setRowHeight(i, n);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static void createAndShowGUI() {
        UIManagerDefaults uIManagerDefaults = new UIManagerDefaults();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("UIManager Defaults");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setJMenuBar(uIManagerDefaults.getMenuBar());
        jFrame.getContentPane().add(uIManagerDefaults.getContentPane());
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManagerDefaults.createAndShowGUI();
            }
        });
    }

    class SampleRenderer
    extends JLabel
    implements TableCellRenderer {
        public SampleRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(null);
            this.setBorder(null);
            this.setIcon(null);
            this.setText("");
            if (object instanceof Color) {
                this.setBackground((Color)object);
            } else if (object instanceof Border) {
                this.setBorder((Border)object);
            } else if (object instanceof Font) {
                this.setText("Sample");
                this.setFont((Font)object);
            } else if (object instanceof Icon) {
                this.setIcon((Icon)object);
            }
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", new Integer(88));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        private UIManagerDefaults defaults;
        private String laf;

        protected ChangeLookAndFeelAction(UIManagerDefaults uIManagerDefaults2, String string, String string2) {
            this.defaults = uIManagerDefaults2;
            this.laf = string;
            this.putValue("Name", string2);
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UIManager.setLookAndFeel(this.laf);
                this.defaults.resetComponents();
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
                JRootPane jRootPane = SwingUtilities.getRootPane(jPopupMenu.getInvoker());
                SwingUtilities.updateComponentTreeUI(jRootPane);
                JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(jRootPane);
                jFrame.dispose();
                if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                    jFrame.setUndecorated(true);
                    jFrame.getRootPane().setWindowDecorationStyle(1);
                } else {
                    jFrame.setUndecorated(false);
                }
                jFrame.setVisible(true);
            }
            catch (Exception exception) {
                System.out.println("Failed loading L&F: " + this.laf);
                System.out.println(exception);
            }
        }
    }

    public static class SafeIcon
    implements Icon {
        private Icon wrappee;
        private Icon standIn;

        public SafeIcon(Icon icon) {
            this.wrappee = icon;
        }

        @Override
        public int getIconHeight() {
            return this.wrappee.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.wrappee.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.standIn == this) {
                this.paintFallback(component, graphics, n, n2);
            } else if (this.standIn != null) {
                this.standIn.paintIcon(component, graphics, n, n2);
            } else {
                try {
                    this.wrappee.paintIcon(component, graphics, n, n2);
                }
                catch (ClassCastException classCastException) {
                    this.createStandIn(classCastException, n, n2);
                    this.standIn.paintIcon(component, graphics, n, n2);
                }
            }
        }

        private void createStandIn(ClassCastException classCastException, int n, int n2) {
            try {
                Class<?> clazz = this.getClass(classCastException);
                JComponent jComponent = this.getSubstitute(clazz);
                this.standIn = this.createImageIcon(jComponent, n, n2);
            }
            catch (Exception exception) {
                this.standIn = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Icon createImageIcon(JComponent jComponent, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                this.wrappee.paintIcon(jComponent, graphics2D, 0, 0);
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                return imageIcon;
            }
            finally {
                graphics2D.dispose();
            }
        }

        private JComponent getSubstitute(Class<?> clazz) throws IllegalAccessException {
            JComponent jComponent;
            try {
                jComponent = (JComponent)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                jComponent = new AbstractButton(){};
                ((AbstractButton)jComponent).setModel(new DefaultButtonModel());
            }
            return jComponent;
        }

        private Class<?> getClass(ClassCastException classCastException) throws ClassNotFoundException {
            String string = classCastException.getMessage();
            string = string.substring(string.lastIndexOf(" ") + 1);
            return Class.forName(string);
        }

        private void paintFallback(Component component, Graphics graphics, int n, int n2) {
            graphics.drawRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.drawLine(n, n2, n + this.getIconWidth(), n2 + this.getIconHeight());
            graphics.drawLine(n + this.getIconWidth(), n2, n, n2 + this.getIconHeight());
        }
    }
}

