/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner.debug.probe;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerEngine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public final class RaptorDebugProbeConnector
implements DebugConnector {
    private static final String PROBE_DEBUGGER_CONNECT_ID = "ProbeDebugger.Connect";
    private static String FAILURE_MESSAGE = "Target failed to handshake.";

    public static String getVersion() {
        return "8";
    }

    public synchronized DebugConnectArg[] getConnectArgs() {
        DebugProbeConnectArg[] debugProbeConnectArgArray = new DebugProbeConnectArg[]{new DebugProbeConnectArg("connection", DebugProbeArb.getString((String)"CONNECT_LABEL_CONNECTION"), "", false), new DebugProbeConnectArg("session", DebugProbeArb.getString((String)"CONNECT_LABEL_SESSION"), "", false)};
        return debugProbeConnectArgArray;
    }

    public synchronized DebugVirtualMachine connect(DebugConnectArg[] debugConnectArgArray, DebuggerEngine debuggerEngine) throws Exception {
        DebugProbe debugProbe = null;
        String string = debugConnectArgArray[0].getValue();
        String string2 = debugConnectArgArray[1].getValue();
        if (string != null) {
            Connections connections = Connections.getInstance();
            Connection connection = null;
            try {
                connection = connections.getUniqueConnection(string);
            }
            catch (ConnectionException connectionException) {
                int n;
                Throwable throwable = connectionException.getCause();
                ((DebuggingProcess)debuggerEngine).log((Object)throwable.getLocalizedMessage());
                if (throwable instanceof SQLException && (n = ((SQLException)throwable).getErrorCode()) == 1017) {
                    throw (SQLException)throwable;
                }
                throw new IOException(FAILURE_MESSAGE);
            }
            Database database = connections.getDatabase(connection);
            String string3 = QueryHolder.getQuery(PROBE_DEBUGGER_CONNECT_ID, connection).getSql();
            try (CallableStatement callableStatement = connection.prepareCall(string3);){
                callableStatement.setString(1, string2);
                callableStatement.registerOutParameter(2, 4);
                callableStatement.registerOutParameter(3, 4);
                callableStatement.registerOutParameter(4, 12);
                callableStatement.execute();
                int n = callableStatement.getInt(2);
                int n2 = callableStatement.getInt(3);
                String string4 = callableStatement.getString(4);
                debugProbe = new DebugProbe(database, n, n2, string4);
            }
            catch (SQLException sQLException) {
                ((DebuggingProcess)debuggerEngine).log((Object)sQLException.getLocalizedMessage());
                throw new IOException(FAILURE_MESSAGE);
            }
        }
        return debugProbe;
    }

    public synchronized void startListening(DebugConnectArg[] debugConnectArgArray, DebugConnectionListener debugConnectionListener) throws Exception {
        throw new UnsupportedOperationException("Can not listen. Not supported.");
    }

    public synchronized void stopListening() {
        throw new IllegalStateException("Can not stop listening. Not currently listening.");
    }

    private static class QueryHolder {
        static final QueryXMLSupport XML = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(RaptorDebugProbeConnector.class.getClassLoader(), "oracle/dbtools/raptor/runner/source.xml"));

        private QueryHolder() {
        }

        static Query getQuery(String string, Connection connection) {
            return XML.getQuery(string, connection);
        }
    }
}

