/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.language;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.plsql.language.CustomSyntaxStyle;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class PLSQLStyles {
    public static final String PLSQL_COMMENT_STYLE = "plsql-comment-style";
    public static final String PLSQL_KEYWORD_STYLE = "plsql-keyword-style";
    public static final String PLSQL_IDENTIFIER_STYLE = "plsql-identifier-style";
    public static final String PLSQL_STRING_STYLE = "plsql-string-style";
    public static final String PLSQL_NUMBER_STYLE = "plsql-number-style";
    public static final String PLSQL_BRACE_STYLE = "plsql-brace-style";
    public static final String PLSQL_OPERATOR_STYLE = "plsql-operator-style";
    public static final String PLSQL_MACROS_STYLE = "plsql-macros-style";
    public static final String SQL_AGGREGATE_STYLE = "base-attribute-name-style";
    public static final String[] BASIC_STYLE_NAMES = new String[]{"plsql-comment-style", "plsql-keyword-style", "plsql-identifier-style", "plsql-string-style", "plsql-number-style", "plsql-brace-style", "plsql-operator-style", "base-attribute-name-style"};
    public static String[] additionalStyleNames = null;
    public static BaseStyle plsqlPlainStyle;
    public static BaseStyle plsqlCommentStyle;
    public static BaseStyle plsqlKeywordStyle;
    public static BaseStyle plsqlIdentifierStyle;
    public static BaseStyle plsqlStringStyle;
    public static BaseStyle plsqlNumberStyle;
    public static BaseStyle plsqlBraceStyle;
    public static BaseStyle plsqlOperatorStyle;
    public static BaseStyle plSqlMacrosStyle;
    public static BaseStyle sqlAggregateStyle;
    public static HashSet<String> builtInFunctions;

    public static String[] getAllStyleNames() {
        String[] stringArray;
        if (additionalStyleNames == null) {
            additionalStyleNames = new String[0];
            try {
                stringArray = CustomSyntaxStyle.getActiveCustomSyntaxStyleProgram();
                SqlProgram sqlProgram = new SqlProgram((String)stringArray, "JS"){};
                Set set = sqlProgram.namedPredicates.keySet();
                additionalStyleNames = new String[set.size()];
                int n = 0;
                for (String string : set) {
                    PLSQLStyles.additionalStyleNames[n++] = string;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return BASIC_STYLE_NAMES;
            }
        }
        stringArray = Arrays.copyOf(BASIC_STYLE_NAMES, BASIC_STYLE_NAMES.length + additionalStyleNames.length);
        System.arraycopy(additionalStyleNames, 0, stringArray, BASIC_STYLE_NAMES.length, additionalStyleNames.length);
        return stringArray;
    }

    public PLSQLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        plsqlPlainStyle = builtInStyles.plainStyle;
        plsqlCommentStyle = styleRegistry.lookupStyle(PLSQL_COMMENT_STYLE);
        if (plsqlCommentStyle == null) {
            String object = bundleHelper.getString("PLSQL_COMMENT_STYLE");
            plsqlCommentStyle = styleRegistry.createStyle(PLSQL_COMMENT_STYLE, object, "base-comment-style");
        }
        if ((plsqlStringStyle = styleRegistry.lookupStyle(PLSQL_STRING_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_STRING_STYLE");
            plsqlStringStyle = styleRegistry.createStyle(PLSQL_STRING_STYLE, string, "base-string-style");
        }
        if ((plsqlKeywordStyle = styleRegistry.lookupStyle(PLSQL_KEYWORD_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_KEYWORD_STYLE");
            plsqlKeywordStyle = styleRegistry.createStyle(PLSQL_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((plsqlIdentifierStyle = styleRegistry.lookupStyle(PLSQL_IDENTIFIER_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_IDENTIFIER_STYLE");
            plsqlIdentifierStyle = styleRegistry.createStyle(PLSQL_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((plsqlNumberStyle = styleRegistry.lookupStyle(PLSQL_NUMBER_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_NUMBER_STYLE");
            plsqlNumberStyle = styleRegistry.createStyle(PLSQL_NUMBER_STYLE, string, "base-number-style");
        }
        if ((plsqlBraceStyle = styleRegistry.lookupStyle(PLSQL_BRACE_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_BRACE_STYLE");
            plsqlBraceStyle = styleRegistry.createStyle(PLSQL_BRACE_STYLE, string, "base-brace-style");
        }
        if ((plsqlOperatorStyle = styleRegistry.lookupStyle(PLSQL_OPERATOR_STYLE)) == null) {
            String string = bundleHelper.getString("PLSQL_OPERATOR_STYLE");
            plsqlOperatorStyle = styleRegistry.createStyle(PLSQL_OPERATOR_STYLE, string, "base-operator-style");
        }
        if ((sqlAggregateStyle = styleRegistry.lookupStyle(SQL_AGGREGATE_STYLE)) == null) {
            String string = bundleHelper.getString("SQL_AGGREGATE_STYLE");
            sqlAggregateStyle = styleRegistry.createStyle(SQL_AGGREGATE_STYLE, string, SQL_AGGREGATE_STYLE);
        }
        if ((plSqlMacrosStyle = styleRegistry.lookupStyle(PLSQL_MACROS_STYLE)) == null) {
            String string2 = bundleHelper.getString("PLSQL_MACROS_STYLE");
            string2 = "PL/SQL Macros";
            plSqlMacrosStyle = styleRegistry.createStyle(PLSQL_MACROS_STYLE, string2, "base-attribute-removal-style");
        }
        PLSQLStyles.getAllStyleNames();
        for (String string : additionalStyleNames) {
            BaseStyle baseStyle = styleRegistry.lookupStyle(string);
            if (baseStyle != null) continue;
            Color color = null;
            if ("PlSqlColTabAlases".equals(string)) {
                color = new Color(150, 150, 0);
            }
            if ("PlSqlLogger".equals(string)) {
                color = new Color(125, 150, 175);
            }
            if (color != null) {
                styleRegistry.createStyle(string, string, "base-comment-style", color);
                continue;
            }
            styleRegistry.createStyle(string, string, "base-comment-style");
        }
    }

    public static String highlightSyntax(String string) {
        List list = LexerToken.parse((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (LexerToken lexerToken : list) {
            if (lexerToken.type == Token.IDENTIFIER && PLSQLStyles.isKeyword(lexerToken.content)) {
                stringBuilder.append(PLSQLStyles.sugarcoat(lexerToken.content));
                continue;
            }
            stringBuilder.append(lexerToken.content);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String sugarcoat(String string) {
        return "<font color=#005577><b>" + string + "</b></font>";
    }

    public static boolean isKeyword(String string) {
        if (string.length() == 1) {
            return false;
        }
        String string2 = string.toUpperCase();
        if (builtInFunctions.contains(string2)) {
            return true;
        }
        return SqlEarley.getInstance().symbolIndexes.containsKey("'" + string2 + "'");
    }

    static {
        builtInFunctions = new HashSet();
        builtInFunctions.add("ABS");
        builtInFunctions.add("ACOS");
        builtInFunctions.add("ASIN");
        builtInFunctions.add("ATAN");
        builtInFunctions.add("ATAN2");
        builtInFunctions.add("BITAND");
        builtInFunctions.add("CEIL");
        builtInFunctions.add("COS");
        builtInFunctions.add("COSH");
        builtInFunctions.add("EXP");
        builtInFunctions.add("FLOOR");
        builtInFunctions.add("LN");
        builtInFunctions.add("LOG");
        builtInFunctions.add("MOD");
        builtInFunctions.add("NANVL");
        builtInFunctions.add("POWER");
        builtInFunctions.add("REMAINDER");
        builtInFunctions.add("ROUND");
        builtInFunctions.add("SIGN");
        builtInFunctions.add("SIN");
        builtInFunctions.add("SINH");
        builtInFunctions.add("SQRT");
        builtInFunctions.add("TAN");
        builtInFunctions.add("TANH");
        builtInFunctions.add("TRUNC");
        builtInFunctions.add("WIDTH_BUCKET");
        builtInFunctions.add("CHR");
        builtInFunctions.add("CONCAT");
        builtInFunctions.add("INITCAP");
        builtInFunctions.add("LOWER");
        builtInFunctions.add("LPAD");
        builtInFunctions.add("LTRIM");
        builtInFunctions.add("NCHR");
        builtInFunctions.add("NLS_INITCAP");
        builtInFunctions.add("NLS_LOWER");
        builtInFunctions.add("NLS_UPPER");
        builtInFunctions.add("NLSSORT");
        builtInFunctions.add("REGEXP_REPLACE");
        builtInFunctions.add("REGEXP_SUBSTR");
        builtInFunctions.add("REPLACE");
        builtInFunctions.add("RPAD");
        builtInFunctions.add("RTRIM");
        builtInFunctions.add("SOUNDEX");
        builtInFunctions.add("SUBSTR");
        builtInFunctions.add("TRANSLATE");
        builtInFunctions.add("TRIM");
        builtInFunctions.add("UPPER");
        builtInFunctions.add("ASCII");
        builtInFunctions.add("INSTR");
        builtInFunctions.add("LENGTH");
        builtInFunctions.add("REGEXP_COUNT");
        builtInFunctions.add("REGEXP_INSTR");
        builtInFunctions.add("NLS_CHARSET_DECL_LEN");
        builtInFunctions.add("NLS_CHARSET_ID");
        builtInFunctions.add("NLS_CHARSET_NAME");
        builtInFunctions.add("GREATEST");
        builtInFunctions.add("LEAST");
        builtInFunctions.add("ASCIISTR");
        builtInFunctions.add("BIN_TO_NUM");
        builtInFunctions.add("CAST");
        builtInFunctions.add("CHARTOROWID");
        builtInFunctions.add("COMPOSE");
        builtInFunctions.add("CONVERT");
        builtInFunctions.add("DECOMPOSE");
        builtInFunctions.add("HEXTORAW");
        builtInFunctions.add("NUMTODSINTERVAL");
        builtInFunctions.add("NUMTOYMINTERVAL");
        builtInFunctions.add("RAWTOHEX");
        builtInFunctions.add("RAWTONHEX");
        builtInFunctions.add("ROWIDTOCHAR");
        builtInFunctions.add("ROWIDTONCHAR");
        builtInFunctions.add("SCN_TO_TIMESTAMP");
        builtInFunctions.add("TIMESTAMP_TO_SCN");
        builtInFunctions.add("TO_BINARY_DOUBLE");
        builtInFunctions.add("TO_BINARY_FLOAT");
        builtInFunctions.add("TO_BLOB");
        builtInFunctions.add("TO_CHAR");
        builtInFunctions.add("TO_CLOB");
        builtInFunctions.add("TO_DATE");
        builtInFunctions.add("TO_DSINTERVAL");
        builtInFunctions.add("TO_LOB");
        builtInFunctions.add("TO_MULTI_BYTE");
        builtInFunctions.add("TO_NCHAR");
        builtInFunctions.add("TO_NCLOB");
        builtInFunctions.add("TO_NUMBER");
        builtInFunctions.add("TO_SINGLE_BYTE");
        builtInFunctions.add("TO_TIMESTAMP");
        builtInFunctions.add("TO_TIMESTAMP_TZ");
        builtInFunctions.add("TO_YMINTERVAL");
        builtInFunctions.add("TREAT");
        builtInFunctions.add("UNISTR");
        builtInFunctions.add("VALIDATE_CONVERSION");
    }
}

