/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;
import oracle.javatools.ui.infotip.templates.TemplateUtils;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.Log;

public final class SyntaxErrorTemplate
extends BasicTemplate
implements ItemTemplate {
    private static int MAX_VISIBLE_ROWS = 16;
    public static final String CONFIGURE = "Configure";
    private SuperLabel title = new SuperLabel();
    private JTextArea desc;
    private JScrollPane sp = TemplateUtils.createScrollPane();
    private static int PREFERRED_WIDTH = 400;
    private boolean expanded = false;
    private List<JComponent> expansionComponenets = new ArrayList<JComponent>();

    public SyntaxErrorTemplate(RecognizedRule[] recognizedRuleArray, InfoTipStyles infoTipStyles, final BasicEditorPane basicEditorPane, final int n, final int n2, final int n3) {
        super((JComponent)new JPanel((LayoutManager)new MigLayout("ins 0, gapx 2, gapy 0, hidemode 3, filly, nogrid")));
        this.title.setLabelOverride(true);
        this.content.setOpaque(false);
        this.sp.setVisible(this.expanded);
        int n4 = (int)basicEditorPane.getVisibleRect().getWidth();
        this.title.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, n4));
        this.desc = TemplateUtils.createDescriptionArea((InfoTipStyles)infoTipStyles);
        this.sp.setViewportView(this.desc);
        Icon icon = infoTipStyles.scaleIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
        Icon icon2 = infoTipStyles.scaleIcon(OracleIcons.getIcon((String)"fix.png"));
        this.title.setForeground(infoTipStyles.getItemTextColor());
        this.title.setFont(infoTipStyles.getItemTitleFont());
        this.title.setText(Messages.getString("SyntaxError"));
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setIcon(icon);
        this.content.add((Component)jLabel, "alignx left, grow 0, aligny baseline");
        this.content.add((Component)this.title, "alignx left, w 100%, growy, aligny baseline");
        this.content.add(Box.createVerticalStrut(infoTipStyles.getItemTitleInsets().bottom), "newline");
        int n5 = jLabel.getIcon().getIconWidth() + 2;
        for (RecognizedRule recognizedRule : recognizedRuleArray) {
            JLabel jLabel2;
            String string;
            int n6;
            boolean bl = false;
            String string2 = recognizedRule.rhs[recognizedRule.pos];
            if (string2.charAt(0) == '\'') {
                string2 = string2.substring(1, string2.length() - 1);
                bl = true;
            }
            final String string3 = string2;
            Map map = HarvestDoc.getRailroads();
            DocURL docURL = (DocURL)map.get(SqlEarley.getInstance().getSymbol(recognizedRule.head));
            if (docURL == null) {
                docURL = (DocURL)map.get(SqlEarley.getInstance().getSymbol(recognizedRule.rhs[0]));
            }
            final DocURL docURL2 = docURL;
            final SuperLabel superLabel = new SuperLabel(recognizedRule.head);
            superLabel.setLabelOverride(true);
            superLabel.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, n4));
            final Font font = superLabel.getFont();
            Map<TextAttribute, ?> map2 = font.getAttributes();
            map2.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font font2 = font.deriveFont(map2);
            map2 = font.getAttributes();
            map2.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            map2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            final Font font3 = font.deriveFont(map2);
            map2 = font.getAttributes();
            map2.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            final Font font4 = font.deriveFont(map2);
            superLabel.setBackground(null);
            superLabel.setOpaque(false);
            superLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            superLabel.setForeground(infoTipStyles.getHyperLinkTextColor(false));
            superLabel.setEnabled(docURL2 != null);
            final JLabel jLabel3 = new JLabel("  " + string2 + "  ");
            final Color color = new Color(231, 200, 231);
            jLabel3.setBackground(color);
            jLabel3.setOpaque(true);
            jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            jLabel3.setFont(font4);
            if (bl) {
                jLabel3.setForeground(infoTipStyles.getHyperLinkTextColor(true));
                jLabel3.setToolTipText(Messages.getString("SyntaxErrorTemplate.fix"));
            }
            JButton jButton = new JButton();
            jButton.setToolTipText(UIBundle.get((String)"INFO_TIP_CONFIGURE"));
            jButton.setIcon(OracleIcons.getIcon((String)"library.png"));
            IconicButtonUI.install((AbstractButton)jButton);
            jButton.setVisible(true);
            jButton.setEnabled(docURL2 != null);
            jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            jButton.setOpaque(false);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    superLabel.setFont(font2);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    superLabel.setFont(font);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        Desktop.getDesktop().browse(new URI(docURL2.getPublicURL()));
                    }
                    catch (Exception exception) {
                        Log.error((String)("Failed to go to URL, " + exception.getMessage()));
                    }
                }
            };
            if (docURL2 != null) {
                jButton.addMouseListener(mouseAdapter);
                superLabel.addMouseListener((MouseListener)mouseAdapter);
                jButton.setToolTipText(Messages.getString("SyntaxErrorTemplate.docRef"));
                jButton.setToolTipText(Messages.getString("SyntaxErrorTemplate.docRef"));
            }
            int n7 = Math.max(superLabel.getPreferredSize().height, jButton.getPreferredSize().height);
            this.content.add((Component)jButton, "newline, alignx left, gapleft 0, height " + n7);
            this.content.add((Component)superLabel, "alignx left, grow 0, gapbottom 2, gapleft " + (n5 - 1) + ", height " + n7);
            JLabel jLabel4 = new JLabel(":=");
            jLabel4.setForeground(new Color(25, 25, 112));
            this.content.add((Component)jLabel4, "alignx left, grow 0, gapbottom 2, gapleft " + (n5 - 1) + ", height " + n7);
            for (n6 = 0; n6 < recognizedRule.pos; ++n6) {
                string = recognizedRule.rhs[n6];
                if (string.charAt(0) == '\'') {
                    string = string.substring(1, string.length() - 1);
                }
                jLabel2 = new JLabel("  " + string + "  ");
                jLabel2.setOpaque(true);
                jLabel2.setBackground(new Color(192, 251, 230));
                this.content.add((Component)jLabel2, "alignx left, grow 0, gapbottom 2, gapleft 2, height " + n7);
            }
            this.content.add((Component)jLabel3, "alignx left, grow 0, gapbottom 2, gapleft 2, height " + n7);
            for (n6 = recognizedRule.pos + 1; n6 < recognizedRule.rhs.length; ++n6) {
                string = recognizedRule.rhs[n6];
                if (string.charAt(0) == '\'') {
                    string = string.substring(1, string.length() - 1);
                }
                jLabel2 = new JLabel(string);
                jLabel2.setBackground(color);
                this.content.add((Component)jLabel2, "alignx left, grow 0, gapbottom 2, gapleft " + (n5 - 1) + ", height " + n7);
            }
            MouseAdapter mouseAdapter2 = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel3.setFont(font3);
                    jLabel3.setBackground(new Color(127, 255, 212));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel3.setFont(font4);
                    jLabel3.setBackground(color);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String string;
                    SyntaxErrorTemplate.this.fireActionPerformed("closeInfotipCommand");
                    int n4 = basicEditorPane.getLineFromOffset(n);
                    int n22 = basicEditorPane.getLineStartOffset(n4);
                    int n32 = basicEditorPane.getLineEndOffset(n4);
                    String string2 = "";
                    try {
                        string = basicEditorPane.getText(n22, n32 - n22);
                        List list = LexerToken.parse((String)string);
                        for (LexerToken lexerToken : list) {
                            if (n3 >= lexerToken.end) continue;
                            n32 = n22 + lexerToken.end;
                            n22 += lexerToken.begin;
                            break;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        System.out.println(badLocationException.getMessage());
                    }
                    basicEditorPane.setSelectionStart(n22);
                    basicEditorPane.setSelectionEnd(n32);
                    string2 = basicEditorPane.getSelectedText();
                    string = string3.trim();
                    if (!string.startsWith(string2.toUpperCase())) {
                        basicEditorPane.setSelectionStart(n2);
                        basicEditorPane.setSelectionEnd(n2 + 1);
                        basicEditorPane.replaceSelection(" " + string);
                    } else {
                        basicEditorPane.replaceSelection(string);
                    }
                }
            };
            if (!bl) continue;
            jLabel3.addMouseListener(mouseAdapter2);
        }
    }

    private void toggleExpansion() {
        this.expanded = !this.expanded;
        for (JComponent jComponent : this.expansionComponenets) {
            jComponent.setVisible(this.expanded);
        }
        this.fireActionPerformed("sizeChangedCommand");
    }

    public void setHover(InfoTipHover infoTipHover) {
    }

    public int getPreferredWidth() {
        return this.title.getPreferredSize().width;
    }

    public void setPreferredWidth(int n) {
        this.desc.setSize(n, 99999999);
        Dimension dimension = this.desc.getPreferredSize();
        this.desc.setPreferredSize(dimension);
        int n2 = this.desc.getFontMetrics(this.desc.getFont()).getHeight();
        int n3 = Math.min(n2 * MAX_VISIBLE_ROWS, this.desc.getPreferredSize().height);
        Insets insets = this.sp.getInsets();
        this.sp.setPreferredSize(new Dimension(n, n3 + insets.top + insets.bottom));
    }
}

