/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.i18n.util.OraLocaleInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Predicate {
    EQ("="),
    NOT_EQ("<>"),
    LIKE("LIKE"),
    NOT_LIKE("NOT LIKE"),
    LT("<"),
    GT(">"),
    LT_EQ("<="),
    GT_EQ(">="),
    BETWEEN("BETWEEN"){

        @Override
        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_BETWEEN;
        }

        @Override
        public int getArgCount() {
            return 2;
        }
    }
    ,
    NOT_BETWEEN("NOT BETWEEN"){

        @Override
        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_BETWEEN;
        }

        @Override
        public int getArgCount() {
            return 2;
        }
    }
    ,
    IN("IN"),
    NOT_IN("NOT_IN"),
    NULL("IS NULL"){

        @Override
        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_NULL;
        }

        @Override
        public int getArgCount() {
            return 0;
        }
    }
    ,
    NOT_NULL("IS NOT NULL"){

        @Override
        protected String getFragmentFormat(boolean bl) {
            return Predicate.PATTERN_NULL;
        }

        @Override
        public int getArgCount() {
            return 0;
        }
    }
    ,
    COMPLEX(" "){

        @Override
        protected String getFragmentFormat(boolean bl) {
            throw new RuntimeException("VT: N/A");
        }

        @Override
        public int getArgCount() {
            throw new RuntimeException("VT: N/A");
        }
    };

    private String _label;
    private static OraDATEFormat _format;
    public static final String FORMAT_GENERIC_DATE = "YYYY-MM-DD";
    private static final String PATTERN_STANDARD = "{0} {1} :{2}";
    private static final String PATTERN_DATE = "TRUNC({0}) {1} TRUNC(TO_DATE(:{2}))";
    private static final String PATTERN_GENERIC_DATE = "TRUNC({0}) {1} TRUNC(TO_DATE(:{2},''YYYY-MM-DD''))";
    private static final String PATTERN_STANDARD_INSENSITIVE = "UPPER({0}) {1} (UPPER(:{2}))";
    private static final String PATTERN_BETWEEN = "{0} {1} :{2}_0 AND :{2}_1";
    private static final String PATTERN_DATE_BETWEEN_0 = "TRUNC({0}) {1} TRUNC(TO_DATE(:{2}_0))";
    private static final String PATTERN_GENERIC_DATE_BETWEEN_0 = "TRUNC({0}) {1} TRUNC(TO_DATE(:{2}_0,''YYYY-MM-DD''))";
    private static final String PATTERN_DATE_BETWEEN_1 = " AND TRUNC(TO_DATE(:{2}_1))";
    private static final String PATTERN_GENERIC_DATE_BETWEEN_1 = " AND TRUNC(TO_DATE(:{2}_1,''YYYY-MM-DD''))";
    private static final String PATTERN_NULL = "{0} {1}";
    public static final Set<Predicate> NUMBER_PREDICATES;
    public static final Set<Predicate> CHAR_PREDICATES;
    public static final Set<Predicate> DATE_PREDICATES;
    public static final Set<Predicate> COMPLEX_PREDICATES;

    private Predicate(String string2) {
        this._label = string2;
    }

    public String toString() {
        return this._label;
    }

    protected String getFragmentFormat(boolean bl) {
        return bl ? PATTERN_STANDARD_INSENSITIVE : PATTERN_STANDARD;
    }

    public String getSQLFragment(String string, String string2) {
        return this.getSQLFragment(string, string2, false);
    }

    public String getSQLFragment(String string, String string2, boolean bl) {
        if (this == COMPLEX) {
            return string;
        }
        return MessageFormat.format(this.getFragmentFormat(bl), string, this._label, string2);
    }

    public String getDateSQLFragment(String string, String string2, String[] stringArray) {
        boolean bl = stringArray != null && stringArray.length > 0 && Predicate.isGenericDateText(stringArray[0]);
        Object object = null;
        if (this._label.equals(Predicate.BETWEEN._label) || this._label.equals(Predicate.NOT_BETWEEN._label)) {
            boolean bl2 = stringArray != null && stringArray.length > 1 && Predicate.isGenericDateText(stringArray[1]);
            object = MessageFormat.format(bl ? PATTERN_GENERIC_DATE_BETWEEN_0 : PATTERN_DATE_BETWEEN_0, string, this._label, string2) + MessageFormat.format(bl2 ? PATTERN_GENERIC_DATE_BETWEEN_1 : PATTERN_DATE_BETWEEN_1, string, this._label, string2);
        } else {
            object = MessageFormat.format(bl ? PATTERN_GENERIC_DATE : PATTERN_DATE, string, this._label, string2);
        }
        return object;
    }

    public int getArgCount() {
        return 1;
    }

    public static OraDATEFormat getGenericDateFormat() {
        if (_format == null) {
            try {
                _format = new OraDATEFormat(FORMAT_GENERIC_DATE, OraLocaleInfo.getInstance((Locale)Locale.US));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _format;
    }

    public static boolean isGenericDateText(String string) {
        try {
            OraDATEFormat oraDATEFormat = Predicate.getGenericDateFormat();
            if (oraDATEFormat != null && string != null && string.length() > 0) {
                oraDATEFormat.parse(string);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static {
        _format = null;
        NUMBER_PREDICATES = EnumSet.of(EQ, new Predicate[]{NOT_EQ, LT, GT, LT_EQ, GT_EQ, BETWEEN, NOT_BETWEEN});
        CHAR_PREDICATES = EnumSet.of(EQ, NOT_EQ, LIKE, NOT_LIKE);
        DATE_PREDICATES = EnumSet.copyOf(NUMBER_PREDICATES);
        COMPLEX_PREDICATES = EnumSet.of(COMPLEX);
    }
}

